/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.baremetal.jenkins.credentials;

import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;
import org.jenkinsci.remoting.RoleChecker;

public class OciConfigWriter
implements Serializable {
    public static final String ENV_USER_ID = "OCI_USER_ID";
    public static final String ENV_FINGERPRINT = "OCI_FINGERPRINT";
    public static final String ENV_TENANT_ID = "OCI_TENANT_ID";
    public static final String ENV_REGION_ID = "OCI_REGION_ID";
    public static final String ENV_KEY_FILE = "OCI_KEY_FILE";
    public static final String ENV_CONFIG_FILE = "OCI_CONFIG_FILE";
    private final String user;
    private final String fingerprint;
    private final String tenancy;
    private final String region;
    private final String keyFileContents;

    public OciConfigWriter(String user, String fingerprint, String tenancy, String region, String keyFileContents) {
        this.user = user;
        this.fingerprint = fingerprint;
        this.tenancy = tenancy;
        this.region = region;
        this.keyFileContents = keyFileContents;
    }

    public String getUser() {
        return this.user;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getTenancy() {
        return this.tenancy;
    }

    public String getRegion() {
        return this.region;
    }

    public String getKeyFileContents() {
        return this.keyFileContents;
    }

    public Callable asCallable() {
        return new Callable(this);
    }

    private String getConfigText(Path keyFile) throws IOException {
        try (InputStream stream = this.getClass().getResourceAsStream("config.template");){
            String string = new String(stream.readAllBytes(), StandardCharsets.UTF_8).replaceAll("%USER%", this.user).replaceAll("%FINGERPRINT%", this.fingerprint).replaceAll("%TENANCY%", this.tenancy).replaceAll("%REGION%", this.region).replaceAll("%KEY_FILE_PATH%", keyFile.toString());
            return string;
        }
    }

    public Map<String, String> createEnvironment(File dir) throws IOException {
        Path keyFile = dir.toPath().resolve("oci.pem");
        Path config = dir.toPath().resolve("oci.config");
        String text = this.getConfigText(keyFile);
        try (BufferedWriter writer = Files.newBufferedWriter(keyFile, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            writer.write(this.keyFileContents);
        }
        writer = Files.newBufferedWriter(config, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        try {
            writer.write(text);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        HashMap<String, String> env = new HashMap<String, String>();
        env.put(ENV_USER_ID, this.getUser());
        env.put(ENV_FINGERPRINT, this.getFingerprint());
        env.put(ENV_TENANT_ID, this.getTenancy());
        env.put(ENV_REGION_ID, this.getRegion());
        env.put(ENV_KEY_FILE, keyFile.toString());
        env.put(ENV_CONFIG_FILE, config.toString());
        return env;
    }

    public static class Callable
    implements FilePath.FileCallable<Map<String, String>> {
        private final OciConfigWriter writer;

        public Callable(OciConfigWriter writer) {
            this.writer = writer;
        }

        public Map<String, String> invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            return this.writer.createEnvironment(f);
        }

        public void checkRoles(RoleChecker checker) throws SecurityException {
        }
    }
}

