/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.baremetal.jenkins;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jvnet.localizer.LocaleProvider;

public class DynamicResourceBundleHolder {
    ClassLoader classLoader;
    private final String name;

    public static synchronized DynamicResourceBundleHolder get(Class<?> owner, String shortName) {
        String name = owner.getName().replace('.', '/') + "/" + shortName;
        return new DynamicResourceBundleHolder(owner.getClassLoader(), name);
    }

    private DynamicResourceBundleHolder(ClassLoader classLoader, String name) {
        this.classLoader = classLoader;
        this.name = name;
    }

    private synchronized ResourceBundle get(Locale locale) {
        return ResourceBundle.getBundle(this.name, locale, this.classLoader);
    }

    public String format(String key, Object ... args) {
        return MessageFormat.format(this.get(LocaleProvider.getLocale()).getString(key), args);
    }
}

