/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.baremetal.jenkins;

import com.oracle.bmc.core.model.Image;
import com.oracle.cloud.baremetal.jenkins.BaremetalCloud;
import com.oracle.cloud.baremetal.jenkins.BaremetalCloudAgentTemplate;
import com.oracle.cloud.baremetal.jenkins.BaremetalCloudInstanceMonitor;
import com.oracle.cloud.baremetal.jenkins.JenkinsUtil;
import com.oracle.cloud.baremetal.jenkins.client.BaremetalCloudClient;
import com.oracle.cloud.baremetal.jenkins.client.BaremetalCloudClientFactory;
import com.oracle.cloud.baremetal.jenkins.client.SDKBaremetalCloudClientFactory;
import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.TaskListener;
import hudson.slaves.Cloud;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

@Extension
public class BaremetalCloudTemplateMonitor
extends AsyncPeriodicWork {
    private static final Logger LOGGER = Logger.getLogger(BaremetalCloudInstanceMonitor.class.getName());
    private static final Long recurrencePeriod = TimeUnit.MINUTES.toMillis(3L);

    public BaremetalCloudTemplateMonitor() {
        super("Oracle Oracle Cloud Infrastructure Compute Templates Monitor");
        LOGGER.log(Level.FINE, "Oracle Cloud Infrastructure Compute Templates Monitor check period is {0}ms", recurrencePeriod);
    }

    protected void execute(TaskListener taskListener) throws IOException {
        for (Cloud c : JenkinsUtil.getJenkinsInstance().clouds) {
            if (!(c instanceof BaremetalCloud)) continue;
            BaremetalCloud cloud = (BaremetalCloud)c;
            for (BaremetalCloudAgentTemplate baremetalCloudAgentTemplate : cloud.getTemplates()) {
                if (baremetalCloudAgentTemplate.isTemplateSleep()) {
                    long retryTimeOutMins = TimeUnit.MINUTES.toMillis(baremetalCloudAgentTemplate.getRetryTimeoutMins());
                    LOGGER.log(Level.INFO, "Monitoring sleeping template " + baremetalCloudAgentTemplate.getDisplayName() + " provided retryTime " + baremetalCloudAgentTemplate.getRetryTimeoutMins() + " minutes.");
                    long differenceTime = System.currentTimeMillis() - baremetalCloudAgentTemplate.getSleepStartTime();
                    if (differenceTime > retryTimeOutMins) {
                        baremetalCloudAgentTemplate.setTemplateSleep(false);
                        if (baremetalCloudAgentTemplate.getDisableCause() == null) {
                            LOGGER.log(Level.INFO, "Template {0} is available for provisioning now.", baremetalCloudAgentTemplate.getDisplayName());
                        } else {
                            LOGGER.log(Level.INFO, "Template {0} is disabled after encountering 20 failures.", baremetalCloudAgentTemplate.getDisplayName());
                        }
                    } else if (baremetalCloudAgentTemplate.getDisableCause() == null) {
                        LOGGER.log(Level.INFO, "Not yet available, wait for atleast {0} minutes.", TimeUnit.MILLISECONDS.toMinutes(retryTimeOutMins - differenceTime) + 1L);
                    }
                }
                if (!baremetalCloudAgentTemplate.getAutoImageUpdate().booleanValue()) continue;
                String imageId = baremetalCloudAgentTemplate.getImageId();
                BaremetalCloudClientFactory factory = SDKBaremetalCloudClientFactory.INSTANCE;
                BaremetalCloudClient client = factory.createClient(cloud.getCredentialsId(), Integer.parseInt(cloud.getMaxAsyncThreads()));
                try {
                    List<Image> images = client.getImagesList(baremetalCloudAgentTemplate.getImageCompartmentId());
                    for (Image image : images) {
                        if (!image.getId().equals(imageId)) continue;
                        String imageName = image.getDisplayName();
                        for (Image image2 : images) {
                            if (!image2.getDisplayName().equals(imageName) || image2.getId().equals(imageId) || image2.getTimeCreated().compareTo(image.getTimeCreated()) <= 0) continue;
                            LOGGER.log(Level.INFO, "A new version of the image {0} was found. It is used in the template.", imageName);
                            baremetalCloudAgentTemplate.setImageId(image2.getId());
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to get images list", e);
                }
            }
        }
    }

    public long getRecurrencePeriod() {
        return recurrencePeriod;
    }

    private BaremetalCloudAgentTemplate createNewTemplate(BaremetalCloudAgentTemplate oldTemplate, String newImageId) {
        return new BaremetalCloudAgentTemplate(oldTemplate.compartmentId, oldTemplate.availableDomain, oldTemplate.vcnCompartmentId, oldTemplate.vcnId, oldTemplate.subnetCompartmentId, oldTemplate.subnetId, oldTemplate.nsgIds, oldTemplate.imageCompartmentId, newImageId, oldTemplate.shape, oldTemplate.sshCredentialsId, oldTemplate.description, oldTemplate.remoteFS, oldTemplate.assignPublicIP, oldTemplate.usePublicIP, oldTemplate.numExecutors, oldTemplate.mode, oldTemplate.labelString, oldTemplate.idleTerminationMinutes, oldTemplate.templateId, oldTemplate.jenkinsAgentUser, oldTemplate.customJavaPath, oldTemplate.customJVMOpts, oldTemplate.initScript, oldTemplate.getExportJenkinsEnvVars(), oldTemplate.sshConnectTimeoutSeconds, oldTemplate.verificationStrategy, oldTemplate.startTimeoutSeconds, oldTemplate.initScriptTimeoutSeconds, oldTemplate.instanceCap, oldTemplate.numberOfOcpus, oldTemplate.getAutoImageUpdate(), oldTemplate.getStopOnIdle(), oldTemplate.getTags(), oldTemplate.getInstanceNamePrefix(), oldTemplate.getMemoryInGBs(), oldTemplate.getDoNotDisable(), oldTemplate.retryTimeoutMins, oldTemplate.disableLegacyImdsEndpoint);
    }
}

