/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.baremetal.jenkins;

import com.oracle.cloud.baremetal.jenkins.BaremetalCloud;
import com.oracle.cloud.baremetal.jenkins.client.BaremetalCloudClient;
import com.oracle.cloud.baremetal.jenkins.client.BaremetalCloudClientFactory;
import com.oracle.cloud.baremetal.jenkins.client.SDKBaremetalCloudClientFactory;
import com.oracle.cloud.baremetal.jenkins.credentials.BaremetalCloudCredentials;
import hudson.Extension;
import hudson.RelativePath;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.ListBoxModel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;

public class BaremetalCloudTagsTemplate
extends AbstractDescribableImpl<BaremetalCloudTagsTemplate> {
    private static final Logger LOGGER = Logger.getLogger(BaremetalCloud.class.getName());
    private final String namespace;
    private final String key;
    private final String value;

    @DataBoundConstructor
    public BaremetalCloudTagsTemplate(String namespace, String key, String value) {
        this.namespace = namespace;
        this.key = key;
        this.value = value;
    }

    @Exported
    public String getNamespace() {
        return this.namespace;
    }

    @Exported
    public String getKey() {
        return this.key;
    }

    @Exported
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.key + ":" + this.value;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<BaremetalCloudTagsTemplate> {
        public ListBoxModel doFillNamespaceItems(@QueryParameter @RelativePath(value="../..") String credentialsId, @QueryParameter @RelativePath(value="../..") String maxAsyncThreads, @QueryParameter @RelativePath(value="..") String compartmentId) {
            ListBoxModel model = new ListBoxModel();
            model.add("<Select a compartment>", "");
            if (credentialsId.isEmpty() || compartmentId.isEmpty()) {
                return model;
            }
            try {
                model.clear();
                model.add("None (add a free-form tag)", "None");
                BaremetalCloudClientFactory factory = SDKBaremetalCloudClientFactory.INSTANCE;
                BaremetalCloudClient client = factory.createClient(credentialsId, Integer.parseInt(maxAsyncThreads));
                BaremetalCloudCredentials credentials = (BaremetalCloudCredentials)BaremetalCloud.matchCredentials(BaremetalCloudCredentials.class, credentialsId);
                if (credentials != null) {
                    compartmentId = credentials.getTenantId();
                }
                client.getTagNamespaces(compartmentId).stream().forEach(n -> model.add(n.getName(), n.getName()));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to get tag namespaces list", e);
            }
            return model;
        }

        public String getDisplayName() {
            return "";
        }
    }
}

