/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.baremetal.jenkins;

import com.oracle.cloud.baremetal.jenkins.BaremetalCloud;
import com.oracle.cloud.baremetal.jenkins.BaremetalCloudAgent;
import com.oracle.cloud.baremetal.jenkins.BaremetalCloudAgentTemplate;
import com.oracle.cloud.baremetal.jenkins.JenkinsUtil;
import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.Cloud;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

@Extension
public class BaremetalCloudInstanceMonitor
extends AsyncPeriodicWork {
    private static final Logger LOGGER = Logger.getLogger(BaremetalCloudInstanceMonitor.class.getName());
    private static final Long recurrencePeriod = TimeUnit.MINUTES.toMillis(10L);

    public BaremetalCloudInstanceMonitor() {
        super("Oracle Oracle Cloud Infrastructure Compute instances monitor");
        LOGGER.log(Level.FINE, "Oracle Cloud Infrastructure Compute check alive period is {0}ms", recurrencePeriod);
    }

    public long getRecurrencePeriod() {
        return recurrencePeriod;
    }

    List<Node> getNodes() {
        return JenkinsUtil.getJenkinsInstance().getNodes();
    }

    List<Cloud> getClouds() {
        return JenkinsUtil.getJenkinsInstance().clouds.toList();
    }

    protected void execute(TaskListener listener) {
        for (Node node : this.getNodes()) {
            if (!(node instanceof BaremetalCloudAgent)) continue;
            BaremetalCloudAgent agent = (BaremetalCloudAgent)node;
            try {
                if (!agent.isAlive()) {
                    LOGGER.info("Cloud Infrastructure instance is offline: " + agent.getDisplayName());
                    agent._terminate(listener);
                    LOGGER.info("Cloud Infrastructure instance is terminated: " + agent.getDisplayName());
                    this.removeNode(agent);
                    continue;
                }
                LOGGER.info("Cloud Infrastructure instance is online: " + agent.getDisplayName());
            }
            catch (IOException | InterruptedException | RuntimeException e) {
                LOGGER.info("Failed to terminate node : " + agent.getDisplayName());
                LOGGER.info("ERROR : " + e.getMessage());
            }
        }
        LOGGER.log(Level.FINE, "Monitoring the compute plugin online instances");
        for (Cloud c : this.getClouds()) {
            if (!(c instanceof BaremetalCloud)) continue;
            BaremetalCloud cloud = (BaremetalCloud)c;
            for (BaremetalCloudAgentTemplate baremetalCloudAgentTemplate : cloud.getTemplates()) {
                cloud.getTemplateNodeCount(baremetalCloudAgentTemplate.getTemplateId());
            }
        }
    }

    void removeNode(BaremetalCloudAgent agent) {
        try {
            JenkinsUtil.getJenkinsInstance().removeNode((Node)agent);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to remove node: " + agent.getDisplayName());
        }
    }
}

