/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.baremetal.jenkins;

import com.oracle.bmc.core.model.Instance;
import com.oracle.cloud.baremetal.jenkins.BaremetalCloud;
import com.oracle.cloud.baremetal.jenkins.BaremetalCloudAgentTemplate;
import com.oracle.cloud.baremetal.jenkins.BaremetalCloudComputer;
import com.oracle.cloud.baremetal.jenkins.BaremetalCloudRetentionStrategy;
import com.oracle.cloud.baremetal.jenkins.JenkinsUtil;
import com.oracle.cloud.baremetal.jenkins.Messages;
import com.oracle.cloud.baremetal.jenkins.client.BaremetalCloudClient;
import com.oracle.cloud.baremetal.jenkins.ssh.SshComputerLauncher;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.NodeProperty;
import hudson.slaves.OfflineCause;
import hudson.slaves.RetentionStrategy;
import hudson.slaves.SlaveComputer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class BaremetalCloudAgent
extends AbstractCloudSlave {
    private static final Logger LOGGER = Logger.getLogger(BaremetalCloud.class.getName());
    private static final long serialVersionUID = 1L;
    public final String cloudName;
    private final String instanceId;
    public final String jenkinsAgentUser;
    public final String customJavaPath;
    public final String customJVMOpts;
    public final String initScript;
    public final int templateId;
    public boolean verificationStrategy;
    private String hostip = "";

    private static RetentionStrategy<? extends Computer> createRetentionStrategy(String idleTerminationMinutes) {
        int idleMinutes;
        int n = idleMinutes = idleTerminationMinutes == null || idleTerminationMinutes.trim().isEmpty() ? 0 : Integer.parseInt(idleTerminationMinutes);
        if (idleMinutes == 0) {
            return new RetentionStrategy.Always();
        }
        return new BaremetalCloudRetentionStrategy(idleMinutes);
    }

    public BaremetalCloudAgent(String name, BaremetalCloudAgentTemplate template, String cloudName, String instanceId, String host) throws IOException, Descriptor.FormException {
        this(name, template.getDescription(), template.getRemoteFS(), template.getSshCredentialsId(), template.getAssignPublicIP(), template.getUsePublicIP(), template.getNumExecutors(), template.getMode(), template.getLabelString(), template.getIdleTerminationMinutes(), Collections.emptyList(), cloudName, template.getSshConnectTimeoutMillis(), template.getVerificationStrategy(), instanceId, template.getJenkinsAgentUser(), template.getCustomJavaPath(), template.getCustomJVMOpts(), template.getInitScriptEnvVarsVersion(), template.getInitScriptTimeoutSeconds(), host, template.getTemplateId());
    }

    @DataBoundConstructor
    public BaremetalCloudAgent(String name, String description, String remoteFS, String sshCredentialsId, Boolean assignPublicIP, Boolean usePrivateIP, int numExecutors, Node.Mode mode, String labelString, String idleTerminationMinutes, List<? extends NodeProperty<?>> nodeProperties, String cloudName, int sshConnectTimeoutMillis, boolean verificationStrategy, String instanceId, String jenkinsAgentUser, String customJavaPath, String customJVMOpts, String initScript, int initScriptTimeoutSeconds, String host, int templateId) throws IOException, Descriptor.FormException {
        super(name, description, remoteFS, numExecutors, mode, labelString, (ComputerLauncher)new SshComputerLauncher(host, sshConnectTimeoutMillis, jenkinsAgentUser, customJavaPath, customJVMOpts, initScript, initScriptTimeoutSeconds, sshCredentialsId, verificationStrategy), BaremetalCloudAgent.createRetentionStrategy(idleTerminationMinutes), nodeProperties);
        this.cloudName = cloudName;
        this.instanceId = instanceId;
        this.jenkinsAgentUser = jenkinsAgentUser;
        this.initScript = initScript;
        this.templateId = templateId;
        this.customJavaPath = customJavaPath;
        this.customJVMOpts = customJVMOpts;
        this.verificationStrategy = verificationStrategy;
        this.hostip = host;
    }

    private BaremetalCloudAgent(String name, String description, String remoteFS, int numExecutors, Node.Mode mode, String labelString, List<? extends NodeProperty<?>> nodeProperties, String cloudName, boolean verificationStrategy, String instanceId, String jenkinsAgentUser, String customJavaPath, String customJVMOpts, String initScript, ComputerLauncher computerLauncher, RetentionStrategy retentionStrategy, int templateId) throws IOException, Descriptor.FormException {
        super(name, description, remoteFS, numExecutors, mode, labelString, computerLauncher, retentionStrategy, nodeProperties);
        this.cloudName = cloudName;
        this.instanceId = instanceId;
        this.jenkinsAgentUser = jenkinsAgentUser;
        this.customJavaPath = customJavaPath;
        this.customJVMOpts = customJVMOpts;
        this.verificationStrategy = verificationStrategy;
        this.initScript = initScript;
        this.templateId = templateId;
    }

    public String getJenkinsAgentUser() {
        return this.jenkinsAgentUser;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public AbstractCloudComputer<BaremetalCloudAgent> createComputer() {
        return new BaremetalCloudComputer(this);
    }

    public BaremetalCloud getCloud() {
        return (BaremetalCloud)JenkinsUtil.getJenkinsInstance().getCloud(this.cloudName);
    }

    void sleep(long millis) throws InterruptedException {
        Thread.sleep(millis);
    }

    protected void _terminate(TaskListener listener) throws IOException, InterruptedException {
        BaremetalCloud cloud;
        SlaveComputer computer = this.getComputer();
        if (computer != null) {
            computer.disconnect(null);
            computer.setTemporarilyOffline(true, OfflineCause.create((Localizable)Messages._BaremetalCloud_termination_offlineCause()));
        }
        if ((cloud = this.getCloud()) == null) {
            LOGGER.log(Level.SEVERE, "Unable to stop or terminate {0} because the Oracle Compute Cloud {1} does not exist", new Object[]{this.instanceId, BaremetalCloud.nameToCloudName(this.cloudName)});
            return;
        }
        boolean stopOnIdle = false;
        Optional<BaremetalCloudAgentTemplate> temp = ((Stream)cloud.getTemplates().stream().parallel()).filter(t -> t.getTemplateId() == this.templateId).findFirst();
        if (temp.isPresent()) {
            stopOnIdle = temp.get().getStopOnIdle();
        }
        if (!stopOnIdle) {
            LOGGER.info("Terminating instance " + this.instanceId);
            cloud.recycleCloudResources(this.instanceId);
            File f1 = new File("./known_hosts");
            if (!f1.exists()) {
                LOGGER.info("File: known_hosts does not exist, skipping modification.");
            } else {
                String line;
                String[] words = null;
                InputStreamReader fr = new InputStreamReader((InputStream)new FileInputStream(f1), StandardCharsets.UTF_8);
                BufferedReader br = new BufferedReader(fr);
                File tempFile = new File("./known_host_temp");
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), StandardCharsets.UTF_8);
                String input = this.hostip;
                while ((line = br.readLine()) != null) {
                    words = line.split(" ");
                    if (words[0].equals(input)) {
                        LOGGER.log(Level.FINE, "IP Address entry to be removed from host file: " + words[0]);
                        continue;
                    }
                    writer.write(line + System.getProperty("line.separator"));
                }
                boolean success = tempFile.renameTo(f1);
                if (!success) {
                    LOGGER.log(Level.INFO, "Cannot rename the file, hence entry not updated.");
                }
                br.close();
                ((Writer)writer).close();
            }
        } else {
            LOGGER.info("Stopping instance " + this.instanceId);
            cloud.stopCloudResources(this.instanceId);
        }
    }

    protected boolean isAlive() throws IOException, InterruptedException {
        BaremetalCloud cloud = this.getCloud();
        if (cloud == null) {
            throw new IllegalStateException("the Oracle Cloud Infrastructure Compute " + this.cloudName + " does not exist");
        }
        BaremetalCloudClient client = this.getCloud().getClient();
        try {
            Instance.LifecycleState currentState = client.getInstanceState(this.instanceId);
            if (currentState.equals((Object)Instance.LifecycleState.Running) || currentState.equals((Object)Instance.LifecycleState.Provisioning) || currentState.equals((Object)Instance.LifecycleState.Starting)) {
                return true;
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return false;
    }

    public Node reconfigure(StaplerRequest req, JSONObject form) {
        if (form == null) {
            return null;
        }
        String newName = this.name;
        try {
            newName = form.getString("name");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        int newNumExecutors = this.getNumExecutors();
        try {
            newNumExecutors = form.getInt("numExecutors");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            return new BaremetalCloudAgent(newName, this.getNodeDescription(), this.getRemoteFS(), newNumExecutors, this.getMode(), this.getLabelString(), (List<? extends NodeProperty<?>>)this.getNodeProperties(), this.cloudName, this.verificationStrategy, this.instanceId, this.jenkinsAgentUser, this.customJavaPath, this.customJVMOpts, this.initScript, this.getLauncher(), this.getRetentionStrategy(), this.templateId);
        }
        catch (Descriptor.FormException | IOException e) {
            LOGGER.warning("Failed to reconfigure BareMetalAgent: " + this.name);
            return this;
        }
    }

    @Extension
    public static class BaremetalAgentDescriptor
    extends Slave.SlaveDescriptor {
        public String getDisplayName() {
            return "";
        }

        public boolean isInstantiable() {
            return false;
        }
    }
}

