/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.oic;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.federation.registration.ClientRegistrationType;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import jenkins.model.Jenkins;
import jenkins.security.FIPS140;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.oic.Messages;
import org.jenkinsci.plugins.oic.OicSecurityRealm;
import org.jenkinsci.plugins.oic.OicServerConfiguration;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class OicServerManualConfiguration
extends OicServerConfiguration {
    private static final long serialVersionUID = 1L;
    private final String authorizationServerUrl;
    private final String tokenServerUrl;
    private OicSecurityRealm.TokenAuthMethod tokenAuthMethod = OicSecurityRealm.TokenAuthMethod.client_secret_post;
    private String jwksServerUrl;
    private String endSessionUrl;
    private String scopes = "openid email";
    private String userInfoServerUrl;
    private boolean useRefreshTokens;
    private String issuer;

    @DataBoundConstructor
    public OicServerManualConfiguration(String issuer, String tokenServerUrl, String authorizationServerUrl) throws Descriptor.FormException {
        this.issuer = OicServerManualConfiguration.validateNonNull("issuer", issuer);
        this.authorizationServerUrl = OicServerManualConfiguration.validateNonNull("authorizationServerUrl", authorizationServerUrl);
        this.tokenServerUrl = OicServerManualConfiguration.validateNonNull("tokenServerUrl", tokenServerUrl);
    }

    @DataBoundSetter
    public void setTokenAuthMethod(OicSecurityRealm.TokenAuthMethod tokenAuthMethod) throws Descriptor.FormException {
        this.tokenAuthMethod = OicServerManualConfiguration.validateNonNull("tokenAuthMethod", tokenAuthMethod);
    }

    @DataBoundSetter
    public void setEndSessionUrl(@Nullable String endSessionUrl) {
        this.endSessionUrl = Util.fixEmptyAndTrim((String)endSessionUrl);
    }

    @DataBoundSetter
    public void setJwksServerUrl(@Nullable String jwksServerUrl) {
        this.jwksServerUrl = Util.fixEmptyAndTrim((String)jwksServerUrl);
    }

    @DataBoundSetter
    public void setScopes(@NonNull String scopes) {
        this.scopes = Objects.requireNonNull(scopes);
    }

    @DataBoundSetter
    public void setUserInfoServerUrl(@Nullable String userInfoServerUrl) {
        this.userInfoServerUrl = Util.fixEmptyAndTrim((String)userInfoServerUrl);
    }

    @DataBoundSetter
    public void setUseRefreshTokens(boolean useRefreshTokens) {
        this.useRefreshTokens = useRefreshTokens;
    }

    public String getAuthorizationServerUrl() {
        return this.authorizationServerUrl;
    }

    public String getEndSessionUrl() {
        return this.endSessionUrl;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public boolean isUseRefreshTokens() {
        return this.useRefreshTokens;
    }

    public String getJwksServerUrl() {
        return this.jwksServerUrl;
    }

    public String getScopes() {
        return this.scopes;
    }

    public OicSecurityRealm.TokenAuthMethod getTokenAuthMethod() {
        return this.tokenAuthMethod;
    }

    public String getTokenServerUrl() {
        return this.tokenServerUrl;
    }

    public String getUserInfoServerUrl() {
        return this.userInfoServerUrl;
    }

    @Override
    protected OIDCProviderMetadata toProviderMetadataInternal() {
        try {
            OIDCProviderMetadata providerMetadata = this.jwksServerUrl == null ? new OIDCProviderMetadata(new Issuer(this.issuer), List.of(SubjectType.PUBLIC), List.of(ClientRegistrationType.AUTOMATIC), null, null, new JWKSet()) : new OIDCProviderMetadata(new Issuer(this.issuer), List.of(SubjectType.PUBLIC), new URI(this.jwksServerUrl));
            if (this.isUseRefreshTokens()) {
                providerMetadata.setGrantTypes(List.of(GrantType.REFRESH_TOKEN));
            }
            providerMetadata.setUserInfoEndpointURI(OicServerManualConfiguration.toURIOrNull(this.userInfoServerUrl));
            providerMetadata.setEndSessionEndpointURI(OicServerManualConfiguration.toURIOrNull(this.endSessionUrl));
            providerMetadata.setAuthorizationEndpointURI(new URI(this.authorizationServerUrl));
            providerMetadata.setTokenEndpointURI(OicServerManualConfiguration.toURIOrNull(this.tokenServerUrl));
            providerMetadata.setJWKSetURI(OicServerManualConfiguration.toURIOrNull(this.jwksServerUrl));
            providerMetadata.setTokenEndpointAuthMethods(List.of(this.getClientAuthenticationMethod()));
            providerMetadata.setScopes(Scope.parse((String)this.getScopes()));
            ArrayList allAlgorithms = new ArrayList(JWSAlgorithm.Family.HMAC_SHA);
            if (FIPS140.useCompliantAlgorithms()) {
                allAlgorithms.addAll(JWSAlgorithm.Family.RSA);
                allAlgorithms.addAll(JWSAlgorithm.Family.EC);
            } else {
                allAlgorithms.addAll(JWSAlgorithm.Family.SIGNATURE);
            }
            providerMetadata.setIDTokenJWSAlgs(allAlgorithms);
            return providerMetadata;
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("could not create provider metadata", e);
        }
    }

    private ClientAuthenticationMethod getClientAuthenticationMethod() {
        if (this.tokenAuthMethod == OicSecurityRealm.TokenAuthMethod.client_secret_post) {
            return ClientAuthenticationMethod.CLIENT_SECRET_POST;
        }
        return ClientAuthenticationMethod.CLIENT_SECRET_BASIC;
    }

    private static <T> T validateNonNull(String fieldName, T value) throws Descriptor.FormException {
        if (value == null) {
            throw new Descriptor.FormException(fieldName + " is mandatory", fieldName);
        }
        return value;
    }

    @CheckForNull
    private static URI toURIOrNull(String uri) throws URISyntaxException {
        if (uri == null || uri.isBlank()) {
            return null;
        }
        return new URI(uri);
    }

    @Extension
    @Symbol(value={"manual"})
    public static class DescriptorImpl
    extends Descriptor<OicServerConfiguration> {
        public String getDisplayName() {
            return Messages.OicServerManualConfiguration_DisplayName();
        }

        @POST
        public FormValidation doCheckAuthorizationServerUrl(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (value == null) {
                return FormValidation.error((String)Messages.OicSecurityRealm_TokenServerURLKeyRequired());
            }
            try {
                new URL(value);
                return FormValidation.ok();
            }
            catch (MalformedURLException e) {
                return FormValidation.error((Throwable)e, (String)Messages.OicSecurityRealm_NotAValidURL());
            }
        }

        @POST
        public FormValidation doCheckEndSessionUrl(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.error((String)Messages.OicSecurityRealm_EndSessionURLKeyRequired());
            }
            try {
                new URL(value);
                return FormValidation.ok();
            }
            catch (MalformedURLException e) {
                return FormValidation.error((Throwable)e, (String)Messages.OicSecurityRealm_NotAValidURL());
            }
        }

        @POST
        public FormValidation doCheckIssuer(@QueryParameter String issuer) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)issuer) == null) {
                return FormValidation.error((String)Messages.OicSecurityRealm_IssuerRequired());
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckJwksServerUrl(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.ok();
            }
            try {
                new URL(value);
                return FormValidation.ok();
            }
            catch (MalformedURLException e) {
                return FormValidation.error((Throwable)e, (String)Messages.OicSecurityRealm_NotAValidURL());
            }
        }

        @POST
        public FormValidation doCheckScopes(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.error((String)Messages.OicSecurityRealm_ScopesRequired());
            }
            if (!value.toLowerCase(Locale.ROOT).contains("openid")) {
                return FormValidation.warning((String)Messages.OicSecurityRealm_RUSureOpenIdNotInScope());
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckTokenServerUrl(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.error((String)Messages.OicSecurityRealm_TokenServerURLKeyRequired());
            }
            try {
                new URL(value);
                return FormValidation.ok();
            }
            catch (MalformedURLException e) {
                return FormValidation.error((Throwable)e, (String)Messages.OicSecurityRealm_NotAValidURL());
            }
        }

        @POST
        public FormValidation doCheckTokenAuthMethod(@QueryParameter String tokenAuthMethod) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)tokenAuthMethod) == null) {
                return FormValidation.error((String)Messages.OicSecurityRealm_TokenAuthMethodRequired());
            }
            return FormValidation.ok();
        }
    }
}

