/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.oic;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.crypto.impl.AESCryptoProvider;
import com.nimbusds.jose.crypto.impl.ContentCryptoProvider;
import com.nimbusds.jose.crypto.impl.PasswordBasedCryptoProvider;
import com.nimbusds.jose.crypto.impl.RSACryptoProvider;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class OicAlgorithmValidatorFIPS140 {
    private static final Set<JWSAlgorithm> JWSSupportedAlgorithms = new LinkedHashSet<JWSAlgorithm>();
    private static final Set<JWEAlgorithm> JWESupportedAlgorithms = new LinkedHashSet<JWEAlgorithm>();
    private static final Set<EncryptionMethod> supportedEncryptionMethod = new LinkedHashSet<EncryptionMethod>();

    public static boolean isJWSAlgorithmFipsCompliant(@NonNull JWSAlgorithm algorithm) {
        return JWSSupportedAlgorithms.contains(algorithm);
    }

    public static boolean isJWEAlgorithmFipsCompliant(@NonNull JWEAlgorithm algorithm) {
        return JWESupportedAlgorithms.contains(algorithm);
    }

    public static boolean isEncryptionMethodFipsCompliant(@NonNull EncryptionMethod encryptionMethod) {
        return supportedEncryptionMethod.contains(encryptionMethod);
    }

    @NonNull
    public static List<JWEAlgorithm> getFipsCompliantJWEAlgorithm(@NonNull List<JWEAlgorithm> algorithms) {
        return OicAlgorithmValidatorFIPS140.filterAlgorithms(algorithms, OicAlgorithmValidatorFIPS140::isJWEAlgorithmFipsCompliant);
    }

    @NonNull
    public static List<JWSAlgorithm> getFipsCompliantJWSAlgorithm(@NonNull List<JWSAlgorithm> algorithms) {
        return OicAlgorithmValidatorFIPS140.filterAlgorithms(algorithms, OicAlgorithmValidatorFIPS140::isJWSAlgorithmFipsCompliant);
    }

    public static List<EncryptionMethod> getFipsCompliantEncryptionMethod(@NonNull List<EncryptionMethod> algorithms) {
        return OicAlgorithmValidatorFIPS140.filterAlgorithms(algorithms, OicAlgorithmValidatorFIPS140::isEncryptionMethodFipsCompliant);
    }

    @NonNull
    private static <T extends Algorithm> List<T> filterAlgorithms(@NonNull List<T> algorithms, @NonNull Function<T, Boolean> criteria) {
        return algorithms.stream().filter(criteria::apply).collect(Collectors.toList());
    }

    static {
        JWSSupportedAlgorithms.addAll(MACSigner.SUPPORTED_ALGORITHMS);
        JWSSupportedAlgorithms.addAll(RSASSASigner.SUPPORTED_ALGORITHMS);
        JWSSupportedAlgorithms.addAll(ECDSASigner.SUPPORTED_ALGORITHMS);
        JWESupportedAlgorithms.addAll(AESCryptoProvider.SUPPORTED_ALGORITHMS);
        JWESupportedAlgorithms.addAll(RSACryptoProvider.SUPPORTED_ALGORITHMS);
        JWESupportedAlgorithms.addAll(PasswordBasedCryptoProvider.SUPPORTED_ALGORITHMS);
        JWESupportedAlgorithms.remove(JWEAlgorithm.RSA1_5);
        supportedEncryptionMethod.addAll(ContentCryptoProvider.SUPPORTED_ENCRYPTION_METHODS);
        supportedEncryptionMethod.remove(EncryptionMethod.XC20P);
        supportedEncryptionMethod.remove(EncryptionMethod.A128CBC_HS256_DEPRECATED);
        supportedEncryptionMethod.remove(EncryptionMethod.A256CBC_HS512_DEPRECATED);
    }
}

