/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nextexecutions.utils;

import hudson.plugins.nextexecutions.NextBuilds;
import hudson.scheduler.CronTabList;
import hudson.triggers.Trigger;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import jenkins.model.ParameterizedJobMixIn;
import org.jenkinsci.plugins.parameterizedscheduler.ParameterizedCronTab;
import org.jenkinsci.plugins.parameterizedscheduler.ParameterizedCronTabList;
import org.jenkinsci.plugins.parameterizedscheduler.ParameterizedTimerTrigger;
import org.kohsuke.accmod.restrictions.suppressions.SuppressRestrictedWarnings;

public class ParameterizedNextExecutionsUtils {
    private ParameterizedNextExecutionsUtils() {
    }

    @SuppressRestrictedWarnings(value={CronTabList.class})
    public static NextBuilds getNextBuild(ParameterizedJobMixIn.ParameterizedJob project, Class<? extends Trigger> triggerClass) {
        Calendar cal = null;
        String paramsTooltip = null;
        if (project.isDisabled()) {
            return null;
        }
        Map triggers = project.getTriggers();
        Iterator iterator = triggers.entrySet().iterator();
        while (iterator.hasNext()) {
            Calendar next;
            ParameterizedCronTab nextTab;
            ParameterizedTimerTrigger ptt;
            ParameterizedCronTabList cronTabList;
            Trigger trigger = (Trigger)iterator.next().getValue();
            if (!trigger.getClass().equals(triggerClass) || !triggerClass.equals(ParameterizedTimerTrigger.class) || (cronTabList = (ptt = (ParameterizedTimerTrigger)trigger).getCronTabList()) == null || (nextTab = cronTabList.nextParameterizedCronTab()) == null || (next = nextTab.next()) == null || cal != null && !cal.after(next)) continue;
            cal = next;
            Map params = nextTab.getParameterValues();
            if (params == null || params.isEmpty()) continue;
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : params.entrySet()) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append((String)entry.getKey()).append("=").append((String)entry.getValue());
            }
            paramsTooltip = sb.toString();
        }
        if (cal != null) {
            return new NextBuilds(project, cal, paramsTooltip);
        }
        return null;
    }
}

