/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nextexecutions;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.plugins.nextexecutions.Messages;
import hudson.plugins.nextexecutions.NextBuilds;
import hudson.plugins.nextexecutions.utils.NextExecutionsUtils;
import hudson.triggers.TimerTrigger;
import hudson.widgets.Widget;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.widgets.WidgetFactory;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class NextExecutionsComputerWidget
extends Widget {
    @NonNull
    private final Computer computer;

    public NextExecutionsComputerWidget(@NonNull Computer computer) {
        this.computer = computer;
    }

    public String getWidgetName() {
        return Messages.NextExecComputer_WidgetName();
    }

    public String getWidgetEmptyMessage() {
        return Messages.NextExec_EmptyWidgetMessage();
    }

    public String getWidgetId() {
        return "next-exec-computer";
    }

    public String getOwnerUrl() {
        return this.computer.getUrl();
    }

    @Exported(name="next_executions_computer")
    public List<NextBuilds> getBuilds() {
        Vector<NextBuilds> nblist = new Vector<NextBuilds>();
        for (AbstractProject project : this.computer.getTiedJobs()) {
            NextBuilds nb = NextExecutionsUtils.getNextBuild((ParameterizedJobMixIn.ParameterizedJob)project, TimerTrigger.class);
            if (nb == null) continue;
            nblist.add(nb);
        }
        Collections.sort(nblist);
        return nblist;
    }

    @Symbol(value={"nextExecutionsComputerWidget"})
    @Extension
    public static final class FactoryImpl
    extends WidgetFactory<Computer, NextExecutionsComputerWidget> {
        public Class<Computer> type() {
            return Computer.class;
        }

        public Class<NextExecutionsComputerWidget> widgetType() {
            return NextExecutionsComputerWidget.class;
        }

        @NonNull
        public Collection<NextExecutionsComputerWidget> createFor(@NonNull Computer target) {
            return List.of(new NextExecutionsComputerWidget(target));
        }
    }
}

