/*
 * Decompiled with CFR 0.152.
 */
package com.netsparker.cloud.model;

import com.google.gson.Gson;
import com.netsparker.cloud.model.ScanRequestBase;
import com.netsparker.cloud.model.ScanTaskState;
import com.netsparker.cloud.utility.AppCommon;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;

public class ScanInfoRequestResult
extends ScanRequestBase {
    private final int httpStatusCode;
    private String data;
    private String scanTaskID;
    private ScanTaskState scanTaskState;
    private HashMap<String, Integer> FoundedSeverityAndCounts;
    private boolean isError;
    private String errorMessage;

    public static ScanInfoRequestResult errorResult(String errorMessage) {
        return new ScanInfoRequestResult(errorMessage);
    }

    private ScanInfoRequestResult(String errorMessage) {
        this.errorMessage = errorMessage;
        this.httpStatusCode = 0;
        this.FoundedSeverityAndCounts = new HashMap();
        this.isError = true;
        this.data = "";
    }

    public ScanInfoRequestResult(ClassicHttpResponse response) throws MalformedURLException, URISyntaxException {
        this.httpStatusCode = response.getCode();
        boolean bl = this.isError = this.httpStatusCode != 200;
        if (!this.isError) {
            try {
                this.data = AppCommon.parseResponseToString(response);
                boolean bl2 = this.isError = (Boolean)AppCommon.parseJsonValue(this.data, "IsValid") == false;
                if (!this.isError) {
                    this.scanTaskID = (String)AppCommon.parseJsonValue(this.data, "ScanTaskId");
                    String sTaskState = (String)AppCommon.parseJsonValue(this.data, "State");
                    this.scanTaskState = ScanTaskState.valueOf(sTaskState);
                    JSONObject foundedSeverityInfo = (JSONObject)AppCommon.parseJsonValue(this.data, "FoundedSeverityAndCounts");
                    if (foundedSeverityInfo != null) {
                        this.FoundedSeverityAndCounts = (HashMap)new Gson().fromJson(foundedSeverityInfo.toString(), HashMap.class);
                    }
                    if (this.FoundedSeverityAndCounts == null) {
                        this.FoundedSeverityAndCounts = new HashMap();
                    }
                } else {
                    this.errorMessage = (String)AppCommon.parseJsonValue(this.data, "ErrorMessage");
                }
            }
            catch (ParseException ex) {
                this.isError = true;
                this.errorMessage = "Scan info request result is not parsable::: " + ex.toString();
            }
            catch (IOException ex) {
                this.isError = true;
                this.errorMessage = "Scan info request result is not readable::: " + ex.toString();
            }
        }
    }

    public String getScanTaskId() {
        return this.scanTaskID;
    }

    public ScanTaskState getScanTaskState() {
        return this.scanTaskState;
    }

    public HashMap<String, Integer> getFoundedSeverityAndCounts() {
        return this.FoundedSeverityAndCounts;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isError() {
        return this.isError;
    }

    public boolean checkSeverity(String ncSeverity) {
        if (this.isError()) {
            return false;
        }
        if (ncSeverity == null) {
            return false;
        }
        for (Map.Entry<String, Integer> entry : this.getFoundedSeverityAndCounts().entrySet()) {
            String foundedSeverityLevel = entry.getKey();
            if (!ncSeverity.contains(foundedSeverityLevel)) continue;
            return true;
        }
        return false;
    }
}

