/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.multiplescms;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import java.util.HashMap;
import java.util.Map;

public class MultiSCMRevisionState
extends SCMRevisionState {
    private final Map<String, SCMRevisionState> revisionStates = new HashMap<String, SCMRevisionState>();

    public void add(@NonNull SCM scm, @NonNull FilePath ws, @Nullable Run<?, ?> build, SCMRevisionState scmState) {
        this.revisionStates.put(scm.getKey(), scmState);
    }

    public SCMRevisionState get(@NonNull SCM scm, FilePath ws, @Nullable AbstractBuild<?, ?> build) {
        SCMRevisionState state = this.revisionStates.get(scm.getKey());
        if (state == null && ws != null) {
            state = this.revisionStates.get(MultiSCMRevisionState.keyFor(scm, ws, build));
        }
        if (state == null) {
            state = this.revisionStates.get(scm.getClass().getName());
        }
        return state;
    }

    private static String keyFor(@NonNull SCM scm, @NonNull FilePath ws, @Nullable AbstractBuild<?, ?> build) {
        StringBuilder b = new StringBuilder(scm.getType());
        for (FilePath root : scm.getModuleRoots(ws, build)) {
            b.append(root.getRemote().substring(ws.getRemote().length()));
        }
        return b.toString();
    }

    public String toString() {
        return "MultiSCMRevisionState" + this.revisionStates;
    }
}

