/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.msbuild;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.msbuild.MsBuildBuilder;
import hudson.plugins.msbuild.MsBuildInstaller;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolProperty;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public final class MsBuildInstallation
extends ToolInstallation
implements NodeSpecific<MsBuildInstallation>,
EnvironmentSpecific<MsBuildInstallation> {
    private static final long serialVersionUID = 1L;
    private final String defaultArgs;

    @DataBoundConstructor
    public MsBuildInstallation(String name, String home, List<? extends ToolProperty<?>> properties, String defaultArgs) {
        super(name, home, properties);
        this.defaultArgs = Util.fixEmptyAndTrim((String)defaultArgs);
    }

    public String getDefaultArgs() {
        return this.defaultArgs;
    }

    public void buildEnvVars(EnvVars env) {
        String msBuildBinPath = this.getHome();
        String msDefaultArgs = this.getDefaultArgs();
        env.put("MSBUILD_HOME", msBuildBinPath);
        env.put("MSBUILD_ARGS", msDefaultArgs != null ? msDefaultArgs : "");
        env.put("PATH+MSBUILD", msBuildBinPath);
    }

    public MsBuildInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new MsBuildInstallation(this.getName(), this.translateFor(node, log), this.getProperties().toList(), this.defaultArgs);
    }

    public MsBuildInstallation forEnvironment(EnvVars environment) {
        return new MsBuildInstallation(this.getName(), environment.expand(this.getHome()), this.getProperties().toList(), this.defaultArgs);
    }

    @Extension
    @Symbol(value={"msbuild"})
    public static class DescriptorImpl
    extends ToolDescriptor<MsBuildInstallation> {
        public String getDisplayName() {
            return "MSBuild";
        }

        public MsBuildInstallation[] getInstallations() {
            return this.getDescriptor().getInstallations();
        }

        public void setInstallations(MsBuildInstallation ... installations) {
            this.getDescriptor().setInstallations(installations);
        }

        private MsBuildBuilder.DescriptorImpl getDescriptor() {
            Jenkins jenkins = Jenkins.get();
            return (MsBuildBuilder.DescriptorImpl)jenkins.getDescriptorByType(MsBuildBuilder.DescriptorImpl.class);
        }

        public List<? extends ToolInstaller> getDefaultInstallers() {
            return Collections.singletonList(new MsBuildInstaller(null));
        }

        public MsBuildInstallation newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            return (MsBuildInstallation)super.newInstance(req, formData);
        }
    }
}

