/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinci.plugins.mock_slave;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.remoting.Which;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.ComputerListener;
import hudson.slaves.SlaveComputer;
import hudson.util.ProcessTree;
import hudson.util.StreamCopyThread;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.FileUtils;
import org.jenkinci.plugins.mock_slave.Throttler;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class MockSlaveLauncher
extends ComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(MockSlaveLauncher.class.getName());
    public final int latency;
    public final int bandwidth;

    @DataBoundConstructor
    public MockSlaveLauncher(int latency, int bandwidth) {
        this.latency = latency;
        this.bandwidth = bandwidth;
    }

    public void launch(final SlaveComputer computer, TaskListener listener) throws IOException, InterruptedException {
        OutputStream os;
        InputStream is;
        Process proc;
        Listener.launchTimes.put((Computer)computer, System.currentTimeMillis());
        listener.getLogger().println("Launching");
        File slaveJar = Which.jarFile(Which.class);
        if (!slaveJar.isFile()) {
            slaveJar = File.createTempFile("slave", ".jar");
            slaveJar.deleteOnExit();
            FileUtils.copyURLToFile((URL)new Slave.JnlpJar("slave.jar").getURL(), (File)slaveJar);
        }
        final EnvVars cookie = EnvVars.createCookie();
        if (this.latency > 0 || this.bandwidth > 0) {
            File portFile = File.createTempFile("jenkins-port", "");
            ProcessBuilder pb = new ProcessBuilder("java", "-jar", slaveJar.getAbsolutePath(), "-tcp", portFile.getAbsolutePath());
            pb.environment().putAll((Map<String, String>)cookie);
            proc = pb.start();
            while (portFile.length() == 0L) {
                Thread.sleep(100L);
            }
            int port = Integer.parseInt(FileUtils.readFileToString((File)portFile, (Charset)StandardCharsets.US_ASCII));
            listener.getLogger().println("connecting to localhost:" + port);
            Socket s = new Socket(InetAddress.getLoopbackAddress(), port);
            is = s.getInputStream();
            os = s.getOutputStream();
            listener.getLogger().printf("throttling with latency=%dms bandwidth=%dbps%n", this.latency, this.bandwidth);
            Throttler t = new Throttler(this.latency, this.bandwidth, is, os);
            is = t.is();
            os = t.os();
        } else {
            ProcessBuilder pb = new ProcessBuilder("java", "-jar", slaveJar.getAbsolutePath());
            pb.environment().putAll((Map<String, String>)cookie);
            proc = pb.start();
            is = proc.getInputStream();
            os = proc.getOutputStream();
        }
        new StreamCopyThread("stderr copier for remote agent on " + computer.getDisplayName(), proc.getErrorStream(), (OutputStream)listener.getLogger()).start();
        computer.setChannel(is, os, (OutputStream)listener.getLogger(), new Channel.Listener(){

            public void onClosed(Channel channel, IOException cause) {
                Jenkins j = Jenkins.get();
                if (j == null || j.isTerminating()) {
                    LOGGER.log(Level.INFO, "Leaving processes running on {0} during shutdown", computer.getName());
                } else {
                    LOGGER.log(Level.FINE, "Killing any processes still running on {0}", computer.getName());
                    try {
                        ProcessTree.get().killAll(proc, (Map)cookie);
                    }
                    catch (InterruptedException e) {
                        LOGGER.log(Level.INFO, "interrupted", e);
                    }
                }
            }
        });
        LOGGER.log(Level.INFO, "agent launched for {0}", computer.getDisplayName());
    }

    @Extension
    public static class Listener
    extends ComputerListener {
        static final Map<Computer, Long> launchTimes = new WeakHashMap<Computer, Long>();

        public void onOnline(Computer c, TaskListener listener) throws IOException, InterruptedException {
            Long launchTime = launchTimes.remove(c);
            if (launchTime != null) {
                long seconds = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - launchTime);
                listener.getLogger().printf("Launched in %ds%n", seconds);
                LOGGER.log(Level.INFO, "Launched {0} in {1}s", new Object[]{c.getName(), seconds});
            }
        }
    }

    @Symbol(value={"mock"})
    @Extension
    public static class DescriptorImpl
    extends Descriptor<ComputerLauncher> {
        public String getDisplayName() {
            return "Mock Agent Launcher";
        }
    }
}

