/*
 * Decompiled with CFR 0.152.
 */
package jenkins.metrics.impl;

import com.codahale.metrics.jmx.ObjectNameFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.lang3.StringUtils;

public class ObjectNameFactoryImpl
implements ObjectNameFactory {
    private static final Logger LOGGER = Logger.getLogger(ObjectNameFactoryImpl.class.getName());
    private static final String[] jmxOrg = new String[]{"type", "class", "name"};

    public ObjectName createName(String type, String domain, String name) {
        String tmpName = StringUtils.removeStart((String)name, (String)"jenkins.");
        tmpName = StringUtils.removeEnd((String)tmpName, (String)".value");
        tmpName = StringUtils.removeEnd((String)tmpName, (String)".duration");
        tmpName = StringUtils.removeEnd((String)tmpName, (String)".count");
        String[] split = tmpName.split("\\.", 3);
        StringBuilder sb = new StringBuilder().append(domain).append(":");
        for (int i = 0; i < split.length; ++i) {
            int orgIndex = i;
            if (i > 0) {
                sb.append(",");
                if (i == split.length - 1) {
                    orgIndex = jmxOrg.length - 1;
                }
            }
            sb.append(jmxOrg[orgIndex]).append("=").append(StringUtils.capitalize((String)split[i]));
        }
        String jmxName = sb.toString();
        try {
            ObjectName objectName = new ObjectName(jmxName);
            if (objectName.isPattern()) {
                objectName = new ObjectName(ObjectName.quote(jmxName));
            }
            return objectName;
        }
        catch (MalformedObjectNameException e) {
            try {
                return new ObjectName(domain, "name", ObjectName.quote(tmpName));
            }
            catch (MalformedObjectNameException e1) {
                String finalName = tmpName;
                LOGGER.log(Level.WARNING, e1, () -> "Unable to register " + type + " " + finalName);
                throw new RuntimeException(e1);
            }
        }
    }
}

