/*
 * Decompiled with CFR 0.152.
 */
package fi.meliora.testlab.ext.jenkins;

import edu.umd.cs.findbugs.annotations.NonNull;
import fi.meliora.testlab.ext.jenkins.CORSFilter;
import fi.meliora.testlab.ext.jenkins.Sender;
import fi.meliora.testlab.ext.jenkins.VariableReplacer;
import fi.meliora.testlab.ext.rest.model.Changeset;
import fi.meliora.testlab.ext.rest.model.TestResult;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitChangeSetList;
import hudson.plugins.mercurial.MercurialChangeSetList;
import hudson.scm.ChangeLogSet;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.ListBoxModel;
import hudson.util.PluginServletFilter;
import hudson.util.Secret;
import io.jenkins.servlet.FilterWrapper;
import jakarta.servlet.Filter;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.scm.RunWithSCM;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest2;

public class TestlabNotifier
extends Notifier
implements SimpleBuildStep {
    private static final Logger log = Logger.getLogger(TestlabNotifier.class.getName());
    public static final String DEFAULT_DESCRIPTION_TEMPLATE = "Jenkins build: ${BUILD_FULL_DISPLAY_NAME} ${BUILD_RESULT}, ${BUILD_URL} - ${BUILD_STATUS}";
    public static final String DEFAULT_AUTOMATIONSOURCE = "${JOB_NAME}";
    private String projectKey;
    private String ruleset;
    private RulesetSettings rulesetSettings;
    private String automationSource;
    private String description;
    private String parameters;
    private PublishRobot publishRobot;
    private PublishTap publishTap;
    private AdvancedSettings advancedSettings;
    private transient String testRunTitle;
    private transient String milestone;
    private transient String testTargetTitle;
    private transient String testEnvironmentTitle;
    private transient IssuesSettings issuesSettings;
    private transient ImportTestCases importTestCases;
    private transient String tags;
    private transient String comment;

    public String getProjectKey() {
        return this.projectKey;
    }

    public String getRuleset() {
        return this.ruleset;
    }

    @DataBoundSetter
    public void setRuleset(String ruleset) {
        this.ruleset = ruleset;
    }

    public RulesetSettings getRulesetSettings() {
        return this.rulesetSettings;
    }

    @DataBoundSetter
    public void setRulesetSettings(RulesetSettings rulesetSettings) {
        this.rulesetSettings = rulesetSettings;
    }

    public String getAutomationSource() {
        return this.automationSource;
    }

    @DataBoundSetter
    public void setAutomationSource(String automationSource) {
        this.automationSource = automationSource;
    }

    public String getDescription() {
        return this.description;
    }

    @DataBoundSetter
    public void setDescription(String description) {
        this.description = description;
    }

    public String getParameters() {
        return this.parameters;
    }

    @DataBoundSetter
    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public PublishRobot getPublishRobot() {
        return this.publishRobot;
    }

    @DataBoundSetter
    public void setPublishRobot(PublishRobot publishRobot) {
        this.publishRobot = publishRobot;
    }

    public PublishTap getPublishTap() {
        return this.publishTap;
    }

    @DataBoundSetter
    public void setPublishTap(PublishTap publishTap) {
        this.publishTap = publishTap;
    }

    public AdvancedSettings getAdvancedSettings() {
        return this.advancedSettings;
    }

    @DataBoundSetter
    public void setAdvancedSettings(AdvancedSettings advancedSettings) {
        this.advancedSettings = advancedSettings;
    }

    protected Object readResolve() {
        if (!TestlabNotifier.isBlank(this.testRunTitle)) {
            if (this.rulesetSettings == null) {
                this.rulesetSettings = new RulesetSettings();
            }
            this.rulesetSettings.testRunTitle = this.testRunTitle;
            log.info("Migrated pre-ruleset configuration testRunTitle: " + this.testRunTitle);
            this.testRunTitle = null;
        }
        if (!TestlabNotifier.isBlank(this.milestone)) {
            if (this.rulesetSettings == null) {
                this.rulesetSettings = new RulesetSettings();
            }
            this.rulesetSettings.milestone = this.milestone;
            log.info("Migrated pre-ruleset configuration milestone: " + this.milestone);
            this.milestone = null;
        }
        if (!TestlabNotifier.isBlank(this.testTargetTitle)) {
            if (this.rulesetSettings == null) {
                this.rulesetSettings = new RulesetSettings();
            }
            this.rulesetSettings.testTargetTitle = this.testTargetTitle;
            log.info("Migrated pre-ruleset configuration testTargetTitle: " + this.testTargetTitle);
            this.testTargetTitle = null;
        }
        if (!TestlabNotifier.isBlank(this.testEnvironmentTitle)) {
            if (this.rulesetSettings == null) {
                this.rulesetSettings = new RulesetSettings();
            }
            this.rulesetSettings.testEnvironmentTitle = this.testEnvironmentTitle;
            log.info("Migrated pre-ruleset configuration testEnvironmentTitle: " + this.testEnvironmentTitle);
            this.testEnvironmentTitle = null;
        }
        if (this.issuesSettings != null) {
            if (this.rulesetSettings == null) {
                this.rulesetSettings = new RulesetSettings();
            }
            if (this.issuesSettings.mergeAsSingleIssue) {
                this.rulesetSettings.setAddIssueStrategy(TestResult.AddIssueStrategy.ADDPERTESTCASE);
            } else {
                this.rulesetSettings.setAddIssueStrategy(TestResult.AddIssueStrategy.ADDPERRESULT);
            }
            this.rulesetSettings.assignToUser = this.issuesSettings.assignToUser;
            this.rulesetSettings.reopenExisting = this.issuesSettings.reopenExisting;
            log.info("Migrated pre-ruleset configuration issuesSettings: " + String.valueOf(this.issuesSettings));
            this.issuesSettings = null;
        }
        if (this.importTestCases != null) {
            if (this.rulesetSettings == null) {
                this.rulesetSettings = new RulesetSettings();
            }
            this.rulesetSettings.importTestCases = true;
            this.rulesetSettings.importTestCasesRootCategory = this.importTestCases.importTestCasesRootCategory;
            log.info("Migrated pre-ruleset configuration importTestCases: " + String.valueOf(this.importTestCases));
            this.importTestCases = null;
        }
        if (this.advancedSettings != null && !TestlabNotifier.isBlank(this.advancedSettings.testCaseMappingField)) {
            if (this.rulesetSettings == null) {
                this.rulesetSettings = new RulesetSettings();
            }
            this.rulesetSettings.testCaseMappingField = this.advancedSettings.testCaseMappingField;
            log.info("Migrated pre-ruleset configuration advancedSettings.testCaseMappingField: " + this.advancedSettings.testCaseMappingField);
            this.advancedSettings.testCaseMappingField = null;
        }
        if (this.publishRobot != null && this.publishRobot.robotCatenateParentKeywords != null && !this.publishRobot.robotCatenateParentKeywords.booleanValue()) {
            if (this.rulesetSettings == null) {
                this.rulesetSettings = new RulesetSettings();
            }
            this.rulesetSettings.robotCatenateParentKeywords = this.publishRobot.robotCatenateParentKeywords;
            log.info("Migrated pre-ruleset configuration publishRobot.robotCatenateParentKeywords: " + this.publishRobot.robotCatenateParentKeywords);
        }
        if (!TestlabNotifier.isBlank(this.tags)) {
            if (this.rulesetSettings == null) {
                this.rulesetSettings = new RulesetSettings();
            }
            String commaSeparatedTags = StringUtils.replace((String)this.tags, (String)" ", (String)",");
            this.rulesetSettings.setTags(commaSeparatedTags);
        }
        if (!TestlabNotifier.isBlank(this.comment)) {
            this.description = this.comment;
            log.info("Migrated pre-ruleset configuration comment to description as: " + this.description);
        }
        log.severe("Configuration resolved: " + String.valueOf((Object)this));
        return this;
    }

    @DataBoundConstructor
    public TestlabNotifier(String projectKey, String ruleset, RulesetSettings rulesetSettings, String description, String parameters, PublishRobot publishRobot, PublishTap publishTap, AdvancedSettings advancedSettings) {
        this.projectKey = projectKey;
        this.ruleset = ruleset;
        this.rulesetSettings = rulesetSettings;
        this.description = description;
        this.parameters = parameters;
        this.publishRobot = publishRobot;
        this.publishTap = publishTap;
        this.advancedSettings = advancedSettings;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull EnvVars env, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        this.doPerform(run, workspace, listener);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        return this.doPerform((Run<?, ?>)build, build.getWorkspace(), (TaskListener)listener);
    }

    protected boolean doPerform(Run<?, ?> build, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        TestResult.AddIssueStrategy addIssueStrategy;
        Secret secretKey;
        listener.getLogger().println("Publishing test results to Testlab project: " + this.projectKey);
        DescriptorImpl d = this.getDescriptor();
        log.fine("perform(): " + String.valueOf((Object)this) + ", descriptor: " + String.valueOf((Object)d));
        Secret secret = secretKey = this.advancedSettings != null ? this.advancedSettings.apiKey : null;
        if (secretKey == null || "".equals(secretKey.getPlainText())) {
            secretKey = d.apiKey;
        }
        String runApiKey = secretKey != null ? secretKey.getPlainText() : null;
        Usingonpremise uop = this.advancedSettings != null && this.advancedSettings.usingonpremise != null ? this.advancedSettings.usingonpremise : d.usingonpremise;
        String runCompanyId = null;
        String runOnpremiseurl = null;
        boolean runUsingonpremise = false;
        if (uop != null && !TestlabNotifier.isBlank(uop.onpremiseurl)) {
            runCompanyId = null;
            runUsingonpremise = true;
            runOnpremiseurl = uop.onpremiseurl;
            log.fine("using on-premise with url: " + runOnpremiseurl);
        } else {
            runCompanyId = !TestlabNotifier.isBlank(this.advancedSettings != null ? this.advancedSettings.companyId : null) ? this.advancedSettings.companyId : d.companyId;
            log.fine("using hosted with company id: " + runCompanyId);
        }
        EnvVars envVars = build.getEnvironment(listener);
        HashMap<String, String> additionalKeys = new HashMap<String, String>();
        additionalKeys.put("BUILD_FULL_DISPLAY_NAME", build.getFullDisplayName());
        Run.Summary summary = build.getBuildStatusSummary();
        additionalKeys.put("BUILD_STATUS", summary.message != null ? summary.message : "[No build status available]");
        Result result = build.getResult();
        additionalKeys.put("BUILD_RESULT", result != null ? result.toString() : "[No build result available]");
        VariableReplacer vr = new VariableReplacer(new Map[]{envVars, additionalKeys});
        if (log.isLoggable(Level.FINE)) {
            log.fine("Environment variables:");
            for (String key : vr.getVars().keySet()) {
                log.fine(" " + key + "=" + vr.getVars().get(key));
            }
        }
        String runProjectKey = vr.replace(this.projectKey);
        String runAutomationSource = vr.replace(TestlabNotifier.isBlank(this.automationSource) ? DEFAULT_AUTOMATIONSOURCE : this.automationSource);
        String runMilestone = vr.replace(this.rulesetSettings != null ? this.rulesetSettings.milestone : null);
        String runTestRunTitle = vr.replace(this.rulesetSettings != null ? this.rulesetSettings.testRunTitle : null);
        String runDescription = vr.replace(TestlabNotifier.isBlank(this.description) ? DEFAULT_DESCRIPTION_TEMPLATE : this.description);
        String runTestTargetTitle = vr.replace(this.rulesetSettings != null ? this.rulesetSettings.testTargetTitle : null);
        String runTestEnvironmentTitle = vr.replace(this.rulesetSettings != null ? this.rulesetSettings.testEnvironmentTitle : null);
        String runTags = vr.replace(this.rulesetSettings != null ? this.rulesetSettings.tags : null);
        String runAssignToUser = vr.replace(this.rulesetSettings != null ? this.rulesetSettings.assignToUser : null);
        String runRuleset = vr.replace(this.ruleset);
        String resultName = vr.replace("${BUILD_URL}");
        String runParameterVariables = vr.replace(this.parameters);
        HashMap<String, String> runParameters = null;
        if (runParameterVariables != null && runParameterVariables.trim().length() > 0) {
            String[] pars = runParameterVariables.split(",");
            Map<String, String> vars = vr.getVars();
            for (String par : pars) {
                String value = vars.get(par = par.trim());
                if (value == null) {
                    value = vars.get(par.toUpperCase());
                }
                if (value == null) continue;
                if (runParameters == null) {
                    runParameters = new HashMap<String, String>();
                }
                runParameters.put(par, value);
            }
        }
        String runTapMappingPrefix = vr.replace(this.publishTap != null ? this.publishTap.tapMappingPrefix : null);
        String abortError = null;
        if (workspace == null) {
            abortError = "The provided build has no workspace.";
        }
        if (!runUsingonpremise && TestlabNotifier.isBlank(runCompanyId)) {
            abortError = "Could not publish results to Testlab: Company ID is not set. Configure it for your job or globally in Jenkins' configuration.";
        }
        if (runUsingonpremise && TestlabNotifier.isBlank(runOnpremiseurl)) {
            abortError = "Could not publish results to Testlab: Testlab URL for on-premise Testlab is not set. Configure it for your job or globally in Jenkins' configuration.";
        }
        if (TestlabNotifier.isBlank(runApiKey)) {
            abortError = "Could not publish results to Testlab: Api Key is not set. Configure it for your job or globally in Jenkins' configuration.";
        }
        if (TestlabNotifier.isBlank(runProjectKey)) {
            abortError = "Could not publish results to Testlab: Project key is not set. Configure it for your job or, if the value contains variable tags make sure they have values.";
        }
        if (abortError != null) {
            log.severe("Aborting with configuration: " + this.toString());
            listener.error(abortError);
            throw new AbortException(abortError);
        }
        ArrayList<String> culprits = null;
        ArrayList<Changeset> changesets = null;
        if (build instanceof RunWithSCM) {
            Set culpritIds;
            RunWithSCM runWithSCM = (RunWithSCM)build;
            List jenkinsChangeSets = runWithSCM.getChangeSets();
            if (runWithSCM.shouldCalculateCulprits()) {
                runWithSCM.calculateCulprits();
            }
            if ((culpritIds = runWithSCM.getCulpritIds()) != null) {
                culprits = new ArrayList<String>(culpritIds);
            }
            log.fine("RunWithSCM, culprits: " + String.valueOf(culpritIds) + ", changesets: " + String.valueOf(jenkinsChangeSets));
            if (jenkinsChangeSets.size() > 0) {
                for (ChangeLogSet cls : jenkinsChangeSets) {
                    MercurialChangeSetList mcsl;
                    Changeset cs;
                    String commitId;
                    List sets;
                    log.fine("Changeset: " + String.valueOf(cls) + ", Kind: " + cls.getKind());
                    if (cls.getItems() == null) continue;
                    if ("git".equals(cls.getKind())) {
                        GitChangeSetList gcsl = (GitChangeSetList)cls;
                        sets = gcsl.getLogs();
                        if (sets == null) continue;
                        for (GitChangeSet set : sets) {
                            commitId = set.getCommitId();
                            if (changesets == null) {
                                changesets = new ArrayList<Changeset>();
                            }
                            cs = new Changeset();
                            cs.setIdentifier(commitId);
                            cs.setType(1);
                            changesets.add(cs);
                        }
                        continue;
                    }
                    if (!"hg".equals(cls.getKind()) && !"mercurial".equals(cls.getKind()) || (sets = (mcsl = (MercurialChangeSetList)cls).getLogs()) == null) continue;
                    for (GitChangeSet set : sets) {
                        commitId = set.getCommitId();
                        if (changesets == null) {
                            changesets = new ArrayList();
                        }
                        cs = new Changeset();
                        cs.setIdentifier(commitId);
                        cs.setType(2);
                        changesets.add(cs);
                    }
                }
            }
            log.fine("RunWithSCM, sending changesets: " + String.valueOf(changesets));
        }
        TestResult.AddIssueStrategy addIssueStrategy2 = addIssueStrategy = this.rulesetSettings != null ? this.rulesetSettings.addIssueStrategy : null;
        if (TestResult.AddIssueStrategy.RULESET_DEFAULT.equals((Object)addIssueStrategy)) {
            addIssueStrategy = null;
        }
        Sender.sendResults(workspace, runCompanyId, runUsingonpremise, runOnpremiseurl, runApiKey, runProjectKey, runRuleset, runMilestone, runTestRunTitle, runDescription, runTestTargetTitle, runTestEnvironmentTitle, runTags, runParameters, addIssueStrategy, this.rulesetSettings != null ? this.rulesetSettings.reopenExisting : null, !TestlabNotifier.isBlank(runAssignToUser) ? runAssignToUser : null, this.publishTap != null, this.publishTap != null && this.publishTap.tapTestsAsSteps, this.publishTap != null && this.publishTap.tapFileNameInIdentifier, this.publishTap != null && this.publishTap.tapTestNumberInIdentifier, runTapMappingPrefix, this.publishRobot != null, this.publishRobot != null ? this.publishRobot.robotOutput : null, this.rulesetSettings != null ? this.rulesetSettings.robotCatenateParentKeywords : null, runAutomationSource, resultName, culprits, changesets, build);
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    public String toString() {
        return "TestlabNotifier{projectKey='" + this.projectKey + "', ruleset='" + this.ruleset + "', rulesetSettings=" + String.valueOf(this.rulesetSettings) + ", description='" + this.description + "', tags='" + this.tags + "', parameters='" + this.parameters + "', publishRobot=" + String.valueOf(this.publishRobot) + ", publishTap=" + String.valueOf(this.publishTap) + ", advancedSettings=" + String.valueOf(this.advancedSettings) + ", testRunTitle(pre)='" + this.testRunTitle + "', milestone(pre)='" + this.milestone + "', testTargetTitle(pre)='" + this.testTargetTitle + "', testEnvironmentTitle(pre)='" + this.testEnvironmentTitle + "', issuesSettings(pre)=" + String.valueOf(this.issuesSettings) + ", descriptor=" + String.valueOf((Object)this.getDescriptor()) + "}";
    }

    public static final class RulesetSettings {
        private String testRunTitle;
        private String milestone;
        private String testTargetTitle;
        private String testEnvironmentTitle;
        private TestResult.AddIssueStrategy addIssueStrategy;
        private String assignToUser;
        private Boolean reopenExisting;
        private Boolean importTestCases;
        private String tags;
        @Deprecated
        private String importTestCasesRootCategory;
        private Boolean robotCatenateParentKeywords;
        @Deprecated
        private String testCaseMappingField;

        public String getTestRunTitle() {
            return this.testRunTitle;
        }

        @DataBoundSetter
        public void setTestRunTitle(String testRunTitle) {
            this.testRunTitle = testRunTitle;
        }

        public String getMilestone() {
            return this.milestone;
        }

        @DataBoundSetter
        public void setMilestone(String milestone) {
            this.milestone = milestone;
        }

        public String getTestTargetTitle() {
            return this.testTargetTitle;
        }

        @DataBoundSetter
        public void setTestTargetTitle(String testTargetTitle) {
            this.testTargetTitle = testTargetTitle;
        }

        public String getTestEnvironmentTitle() {
            return this.testEnvironmentTitle;
        }

        @DataBoundSetter
        public void setTestEnvironmentTitle(String testEnvironmentTitle) {
            this.testEnvironmentTitle = testEnvironmentTitle;
        }

        public TestResult.AddIssueStrategy getAddIssueStrategy() {
            return this.addIssueStrategy;
        }

        @DataBoundSetter
        public void setAddIssueStrategy(TestResult.AddIssueStrategy addIssueStrategy) {
            this.addIssueStrategy = addIssueStrategy;
        }

        public String getAssignToUser() {
            return this.assignToUser;
        }

        @DataBoundSetter
        public void setAssignToUser(String assignToUser) {
            this.assignToUser = assignToUser;
        }

        @DataBoundSetter
        public void setReopenExisting(Boolean reopenExisting) {
            this.reopenExisting = reopenExisting;
        }

        public Boolean getReopenExisting() {
            return this.reopenExisting;
        }

        @DataBoundSetter
        public void setImportTestCases(Boolean importTestCases) {
            this.importTestCases = importTestCases;
        }

        public Boolean getImportTestCases() {
            return this.importTestCases;
        }

        public String getTags() {
            return this.tags;
        }

        @DataBoundSetter
        public void setTags(String tags) {
            this.tags = tags;
        }

        @Deprecated
        @DataBoundSetter
        public void setImportTestCasesRootCategory(String importTestCasesRootCategory) {
            this.importTestCasesRootCategory = importTestCasesRootCategory;
        }

        @Deprecated
        public String getImportTestCasesRootCategory() {
            return this.importTestCasesRootCategory;
        }

        @DataBoundSetter
        public void setRobotCatenateParentKeywords(Boolean robotCatenateParentKeywords) {
            this.robotCatenateParentKeywords = robotCatenateParentKeywords;
        }

        public Boolean getRobotCatenateParentKeywords() {
            return this.robotCatenateParentKeywords;
        }

        @Deprecated
        @DataBoundSetter
        public void setTestCaseMappingField(String testCaseMappingField) {
            this.testCaseMappingField = testCaseMappingField;
        }

        @Deprecated
        public String getTestCaseMappingField() {
            return this.testCaseMappingField;
        }

        public RulesetSettings() {
        }

        @DataBoundConstructor
        public RulesetSettings(String testRunTitle, String milestone, String testTargetTitle, String testEnvironmentTitle, TestResult.AddIssueStrategy addIssueStrategy, Boolean reopenExisting, String assignToUser, Boolean importTestCases, String importTestCasesRootCategory, Boolean robotCatenateParentKeywords, String testCaseMappingField) {
            this.testRunTitle = testRunTitle;
            this.milestone = milestone;
            this.testTargetTitle = testTargetTitle;
            this.testEnvironmentTitle = testEnvironmentTitle;
            this.addIssueStrategy = addIssueStrategy;
            this.reopenExisting = reopenExisting;
            this.assignToUser = assignToUser;
            this.importTestCases = importTestCases;
            this.importTestCasesRootCategory = importTestCasesRootCategory;
            this.robotCatenateParentKeywords = robotCatenateParentKeywords;
            this.testCaseMappingField = testCaseMappingField;
        }

        public String toString() {
            return "RulesetSettings{testRunTitle='" + this.testRunTitle + "', milestone='" + this.milestone + "', testTargetTitle='" + this.testTargetTitle + "', testEnvironmentTitle='" + this.testEnvironmentTitle + "', addIssueStrategy=" + String.valueOf((Object)this.addIssueStrategy) + ", reopenExisting=" + this.reopenExisting + ", assignToUser='" + this.assignToUser + "', robotCatenateParentKeywords=" + this.robotCatenateParentKeywords + "}";
        }
    }

    public static final class PublishRobot {
        private String robotOutput;
        public transient Boolean robotCatenateParentKeywords = true;

        public String getRobotOutput() {
            return this.robotOutput;
        }

        @DataBoundSetter
        public void setRobotOutput(String robotOutput) {
            this.robotOutput = robotOutput;
        }

        @DataBoundConstructor
        public PublishRobot(String robotOutput, Boolean robotCatenateParentKeywords) {
            this.robotOutput = robotOutput;
            this.robotCatenateParentKeywords = robotCatenateParentKeywords == null ? Boolean.TRUE : robotCatenateParentKeywords;
        }

        public String toString() {
            return "PublishRobot{robotOutput='" + this.robotOutput + "'robotCatenateParentKeywords(pre)=" + this.robotCatenateParentKeywords + "}";
        }
    }

    public static final class PublishTap {
        private boolean tapTestsAsSteps;
        private boolean tapFileNameInIdentifier;
        private boolean tapTestNumberInIdentifier;
        private String tapMappingPrefix;

        public boolean isTapTestsAsSteps() {
            return this.tapTestsAsSteps;
        }

        @DataBoundSetter
        public void setTapTestsAsSteps(boolean tapTestsAsSteps) {
            this.tapTestsAsSteps = tapTestsAsSteps;
        }

        public boolean isTapFileNameInIdentifier() {
            return this.tapFileNameInIdentifier;
        }

        @DataBoundSetter
        public void setTapFileNameInIdentifier(boolean tapFileNameInIdentifier) {
            this.tapFileNameInIdentifier = tapFileNameInIdentifier;
        }

        public boolean isTapTestNumberInIdentifier() {
            return this.tapTestNumberInIdentifier;
        }

        @DataBoundSetter
        public void setTapTestNumberInIdentifier(boolean tapTestNumberInIdentifier) {
            this.tapTestNumberInIdentifier = tapTestNumberInIdentifier;
        }

        public String getTapMappingPrefix() {
            return this.tapMappingPrefix;
        }

        @DataBoundSetter
        public void setTapMappingPrefix(String tapMappingPrefix) {
            this.tapMappingPrefix = tapMappingPrefix;
        }

        @DataBoundConstructor
        public PublishTap(boolean tapFileNameInIdentifier, boolean tapTestNumberInIdentifier, boolean tapTestsAsSteps, String tapMappingPrefix) {
            this.tapFileNameInIdentifier = tapFileNameInIdentifier;
            this.tapTestNumberInIdentifier = tapTestNumberInIdentifier;
            this.tapTestsAsSteps = tapTestsAsSteps;
            this.tapMappingPrefix = tapMappingPrefix;
        }

        public String toString() {
            return "PublishTap{tapFileNameInIdentifier=" + this.tapFileNameInIdentifier + ", tapTestsAsSteps=" + this.tapTestsAsSteps + ", tapTestNumberInIdentifier=" + this.tapTestNumberInIdentifier + ", tapMappingPrefix=" + this.tapMappingPrefix + "}";
        }
    }

    public static final class AdvancedSettings {
        private String companyId;
        private Usingonpremise usingonpremise;
        private Secret apiKey;
        public transient String testCaseMappingField;

        public String getCompanyId() {
            return this.companyId;
        }

        @DataBoundSetter
        public void setCompanyId(String companyId) {
            this.companyId = companyId;
        }

        public Usingonpremise getUsingonpremise() {
            return this.usingonpremise;
        }

        @DataBoundSetter
        public void setUsingonpremise(Usingonpremise usingonpremise) {
            this.usingonpremise = usingonpremise;
        }

        public Secret getApiKey() {
            return this.apiKey;
        }

        @DataBoundSetter
        public void setApiKey(Secret apiKey) {
            this.apiKey = apiKey;
        }

        @DataBoundConstructor
        public AdvancedSettings(String companyId, Secret apiKey, String testCaseMappingField, Usingonpremise usingonpremise) {
            this.companyId = companyId;
            this.apiKey = apiKey;
            this.usingonpremise = usingonpremise;
            this.testCaseMappingField = testCaseMappingField;
        }

        public String toString() {
            return "AdvancedSettings{companyId='" + this.companyId + "', usingonpremise=" + String.valueOf(this.usingonpremise) + ", apiKey='hidden'}";
        }
    }

    public static final class IssuesSettings {
        public boolean mergeAsSingleIssue;
        public String assignToUser;
        public boolean reopenExisting;

        @DataBoundConstructor
        public IssuesSettings(boolean mergeAsSingleIssue, String assignToUser, boolean reopenExisting) {
            this.mergeAsSingleIssue = mergeAsSingleIssue;
            this.assignToUser = assignToUser;
            this.reopenExisting = reopenExisting;
        }

        public String toString() {
            return "IssuesSettings{mergeAsSingleIssue(pre)=" + this.mergeAsSingleIssue + ", assignToUser(pre)='" + this.assignToUser + "', reopenExisting(pre)=" + this.reopenExisting + "}";
        }
    }

    @Deprecated
    public static final class ImportTestCases {
        public String importTestCasesRootCategory;

        @DataBoundConstructor
        public ImportTestCases(String importTestCasesRootCategory) {
            this.importTestCasesRootCategory = importTestCasesRootCategory;
        }

        public String toString() {
            return "ImportTestCases{importTestCasesRootCategory(pre)='" + this.importTestCasesRootCategory + "'}";
        }
    }

    @Extension
    @Symbol(value={"melioraTestlab"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String companyId;
        public Secret apiKey;
        public Usingonpremise usingonpremise;
        public Cors cors;
        private static CORSFilter CORSFilter;

        public DescriptorImpl() {
            this.load();
            log.fine("load: " + this.companyId + ", api key hidden, " + String.valueOf(this.usingonpremise) + ", " + String.valueOf(this.usingonpremise) + ", " + String.valueOf(this.cors));
            CORSFilter = new CORSFilter();
            this.configureCORS();
        }

        @Initializer(after=InitMilestone.SYSTEM_CONFIG_ADAPTED)
        public static void startCORS() {
            try {
                PluginServletFilter.addFilter((Filter)FilterWrapper.toJakartaFilter((javax.servlet.Filter)CORSFilter));
                log.info("CORSFilter injected.");
            }
            catch (ServletException se) {
                log.warning("Could not inject CORSFilter.");
                se.printStackTrace();
            }
        }

        public String getDisplayName() {
            return "Publish test results to Testlab";
        }

        public boolean isApplicable(Class type) {
            return true;
        }

        public boolean configure(StaplerRequest2 staplerRequest, JSONObject json) throws Descriptor.FormException {
            this.companyId = json.getString("companyId");
            this.apiKey = Secret.fromString((String)json.getString("apiKey"));
            JSONObject uop = json.getJSONObject("usingonpremise");
            this.usingonpremise = uop != null && !uop.isNullObject() && !uop.isEmpty() ? new Usingonpremise(uop.getString("onpremiseurl")) : null;
            JSONObject c = json.getJSONObject("cors");
            this.cors = c != null && !c.isNullObject() && !c.isEmpty() ? new Cors(c.getString("origin")) : null;
            log.fine("configure: " + this.companyId + ", api key hidden, " + String.valueOf(this.usingonpremise) + ", " + String.valueOf(this.cors));
            this.save();
            this.configureCORS();
            return true;
        }

        protected void configureCORS() {
            CORSFilter.setEnabled(this.cors != null && !TestlabNotifier.isBlank(this.cors.origin));
            if (this.cors != null && this.cors.origin != null) {
                String[] spl = this.cors.origin.split(",");
                ArrayList<String> origins = new ArrayList<String>();
                for (String o : spl) {
                    origins.add(o.trim());
                }
                CORSFilter.setOrigins(origins);
            }
        }

        public String getDefaultDescriptionTemplate() {
            return TestlabNotifier.DEFAULT_DESCRIPTION_TEMPLATE;
        }

        public String getDefaultAutomationSource() {
            return TestlabNotifier.DEFAULT_AUTOMATIONSOURCE;
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillAddIssuesItems() {
            return this.getRulesetDefaultBooleanModel();
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillMergeAsSingleIssueItems() {
            return this.getRulesetDefaultBooleanModel();
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillReopenExistingItems() {
            return this.getRulesetDefaultBooleanModel();
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillImportTestCasesItems() {
            return this.getRulesetDefaultBooleanModel();
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillRobotCatenateParentKeywordsItems() {
            return this.getRulesetDefaultBooleanModel();
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillAddIssueStrategyItems() {
            ListBoxModel m = new ListBoxModel();
            m.add("[Ruleset default]", TestResult.AddIssueStrategy.RULESET_DEFAULT.toString());
            m.add("Do not add issues", TestResult.AddIssueStrategy.DONOTADD.toString());
            m.add("Add an issue per test run", TestResult.AddIssueStrategy.ADDPERTESTRUN.toString());
            m.add("Add an issue per Testlab test case", TestResult.AddIssueStrategy.ADDPERTESTCASE.toString());
            m.add("Add an issue per test result", TestResult.AddIssueStrategy.ADDPERRESULT.toString());
            return m;
        }

        protected ListBoxModel getRulesetDefaultBooleanModel() {
            ListBoxModel m = new ListBoxModel();
            m.add("[Ruleset default]", "null");
            m.add("Yes", "true");
            m.add("No", "false");
            return m;
        }

        public String toString() {
            return "DescriptorImpl{companyId='" + this.companyId + "', apiKey='hidden', usingonpremise=" + String.valueOf(this.usingonpremise) + ", cors=" + String.valueOf(this.cors) + "}";
        }
    }

    public static final class Usingonpremise {
        private String onpremiseurl;

        public String getOnpremiseurl() {
            return this.onpremiseurl;
        }

        @DataBoundSetter
        public void setOnpremiseurl(String onpremiseurl) {
            this.onpremiseurl = onpremiseurl;
        }

        @DataBoundConstructor
        public Usingonpremise(String onpremiseurl) {
            this.onpremiseurl = onpremiseurl;
        }

        public String toString() {
            return "Usingonpremise{onpremiseurl='" + this.onpremiseurl + "'}";
        }
    }

    public static final class Cors {
        private String origin;

        public String getOrigin() {
            return this.origin;
        }

        @DataBoundSetter
        public void setOrigin(String origin) {
            this.origin = origin;
        }

        @DataBoundConstructor
        public Cors(String origin) {
            this.origin = origin;
        }

        public String toString() {
            return "Cors{origin='" + this.origin + "'}";
        }
    }
}

