/*
 * Decompiled with CFR 0.152.
 */
package fi.meliora.testlab.ext.crest;

import fi.meliora.testlab.ext.crest.exception.ConflictException;
import fi.meliora.testlab.ext.crest.exception.NotFoundException;
import fi.meliora.testlab.ext.crest.exception.ServiceUnavailableException;
import fi.meliora.testlab.ext.crest.exception.TestlabAPIException;
import fi.meliora.testlab.ext.crest.exception.UnauthorizedException;
import fi.meliora.testlab.ext.crest.exception.ValidationException;
import java.io.InputStream;
import java.util.Scanner;
import javax.ws.rs.core.Response;
import org.codegist.crest.io.Request;
import org.codegist.crest.io.RequestException;
import org.codegist.crest.io.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorHandler
implements org.codegist.crest.handler.ErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(ErrorHandler.class);

    public <T> T handle(Request request, Exception e) throws Exception {
        RequestException re;
        Response testlabResponse;
        if (e instanceof RequestException && (testlabResponse = (re = (RequestException)e).getResponse()) != null) {
            int statusCode;
            String responseData = this.getResponseIfAny(testlabResponse);
            if (log.isErrorEnabled()) {
                log.error("Testlab REST call failed with response '{}', status code {}, exception: {}", new Object[]{responseData, testlabResponse.getStatusCode(), e});
            }
            if ((statusCode = testlabResponse.getStatusCode()) == Response.Status.NOT_FOUND.getStatusCode()) {
                throw new NotFoundException(responseData);
            }
            if (statusCode == Response.Status.CONFLICT.getStatusCode()) {
                throw new ConflictException(responseData);
            }
            if (statusCode == Response.Status.SERVICE_UNAVAILABLE.getStatusCode()) {
                throw new ServiceUnavailableException(responseData);
            }
            if (statusCode == Response.Status.UNAUTHORIZED.getStatusCode()) {
                throw new UnauthorizedException(responseData);
            }
            if (statusCode == Response.Status.BAD_REQUEST.getStatusCode()) {
                throw new ValidationException(responseData);
            }
            if (responseData != null && responseData.length() > 0) {
                throw new TestlabAPIException(responseData);
            }
        }
        if (log.isErrorEnabled()) {
            log.error("Testlab REST call exception: " + e.getMessage(), (Throwable)e);
        }
        if (e.getCause() != null && e.getCause() instanceof Exception) {
            throw (Exception)e.getCause();
        }
        throw e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getResponseIfAny(Response response) {
        Object responseData = null;
        InputStream is = null;
        try {
            String charset;
            Scanner s;
            is = response.asStream();
            if (is != null && (s = new Scanner(is, charset = response.getCharset() != null ? response.getCharset().name() : "UTF-8").useDelimiter("\\A")).hasNext()) {
                responseData = s.next();
            }
            if (responseData != null && ((String)responseData).length() > 400) {
                responseData = ((String)responseData).substring(0, 400) + "...";
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return responseData;
    }
}

