/*
 * Decompiled with CFR 0.152.
 */
package fi.meliora.testlab.ext.crest;

import org.codegist.crest.CRestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrestEndpointFactory {
    private static final Logger log = LoggerFactory.getLogger(CrestEndpointFactory.class);
    private static CrestEndpointFactory instance = new CrestEndpointFactory();

    public static CrestEndpointFactory getInstance() {
        return instance;
    }

    private CrestEndpointFactory() {
    }

    public <T> T getEndpoint(String url, String username, String password, Class<T> endpointClass) {
        CRestBuilder b = new CRestBuilder().endpoint(url);
        if (username != null && password != null) {
            b = b.basicAuth(username, password);
        }
        Object endpoint = b.build().build(endpointClass);
        if (log.isDebugEnabled()) {
            log.debug("Returning endpoint to {}: {}", (Object)url, endpoint);
        }
        return (T)endpoint;
    }

    public <T> T getTestlabEndpoint(String companyId, String onpremiseUrl, String apiKey, Class<T> endpointClass) {
        String url;
        if (onpremiseUrl != null && onpremiseUrl.trim().length() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(onpremiseUrl);
            if (!onpremiseUrl.endsWith("/")) {
                sb.append('/');
            }
            sb.append("api");
            url = sb.toString();
            companyId = "company";
            if (log.isDebugEnabled()) {
                log.debug("Using on-premise url {} as testlab endpoint.", (Object)url);
            }
        } else {
            url = System.getProperty("TESTLAB_" + companyId.toUpperCase(), "https://" + companyId.toLowerCase() + ".melioratestlab.com/api");
            if (log.isDebugEnabled()) {
                log.debug("Using hosted url {} as testlab endpoint.", (Object)url);
            }
        }
        return this.getEndpoint(url, companyId, apiKey, endpointClass);
    }
}

