/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.logstash.configuration;

import hudson.Extension;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.nio.charset.Charset;
import jenkins.plugins.logstash.Messages;
import jenkins.plugins.logstash.configuration.HostBasedLogstashIndexer;
import jenkins.plugins.logstash.configuration.LogstashIndexer;
import jenkins.plugins.logstash.persistence.RabbitMqDao;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class RabbitMq
extends HostBasedLogstashIndexer<RabbitMqDao> {
    private String queue;
    private String username;
    private Secret password;
    private String charset;
    private String virtualHost;

    @DataBoundConstructor
    public RabbitMq(String charset) {
        this.charset = charset == null || charset.isEmpty() ? Charset.defaultCharset().toString() : Charset.forName(charset).toString();
    }

    protected Object readResolve() {
        if (this.charset == null) {
            this.charset = Charset.defaultCharset().toString();
        }
        if (this.virtualHost == null) {
            this.virtualHost = "/";
        }
        return this;
    }

    public String getCharset() {
        return this.charset;
    }

    @Restricted(value={NoExternalUse.class})
    Charset getEffectiveCharset() {
        try {
            return Charset.forName(this.charset);
        }
        catch (IllegalArgumentException e) {
            return Charset.defaultCharset();
        }
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    @DataBoundSetter
    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public String getQueue() {
        return this.queue;
    }

    @DataBoundSetter
    public void setQueue(String queue) {
        this.queue = queue;
    }

    public String getUsername() {
        return this.username;
    }

    @DataBoundSetter
    public void setUsername(String username) {
        this.username = username;
    }

    public Secret getPassword() {
        return this.password;
    }

    @DataBoundSetter
    public void setPassword(Secret password) {
        this.password = password;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RabbitMq other = (RabbitMq)((Object)obj);
        if (!Secret.toString((Secret)this.password).equals(Secret.toString((Secret)other.getPassword()))) {
            return false;
        }
        if (!StringUtils.equals((String)this.queue, (String)other.queue)) {
            return false;
        }
        if (!StringUtils.equals((String)this.username, (String)other.username)) {
            return false;
        }
        if (!StringUtils.equals((String)this.virtualHost, (String)other.virtualHost)) {
            return false;
        }
        return !(this.charset == null ? other.charset != null : !this.charset.equals(other.charset));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.queue == null ? 0 : this.queue.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        result = 31 * result + (this.charset == null ? 0 : this.charset.hashCode());
        result = 31 * result + (this.virtualHost == null ? 0 : this.virtualHost.hashCode());
        result = 31 * result + Secret.toString((Secret)this.password).hashCode();
        return result;
    }

    @Override
    public RabbitMqDao createIndexerInstance() {
        return new RabbitMqDao(this.getHost(), this.getPort(), this.queue, this.username, Secret.toString((Secret)this.password), this.getEffectiveCharset(), this.getVirtualHost());
    }

    @Extension
    @Symbol(value={"rabbitMq"})
    public static class RabbitMqDescriptor
    extends LogstashIndexer.LogstashIndexerDescriptor {
        public String getDisplayName() {
            return "RabbitMQ";
        }

        @Override
        public int getDefaultPort() {
            return 5672;
        }

        public FormValidation doCheckQueue(@QueryParameter(value="value") String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)Messages.ValueIsRequired());
            }
            return FormValidation.ok();
        }
    }
}

