/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.logstash;

import com.cloudbees.syslog.MessageFormat;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Descriptor;
import hudson.util.Secret;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import jenkins.plugins.logstash.LogstashInstallation;
import jenkins.plugins.logstash.configuration.ElasticSearch;
import jenkins.plugins.logstash.configuration.LogstashIndexer;
import jenkins.plugins.logstash.configuration.RabbitMq;
import jenkins.plugins.logstash.configuration.Redis;
import jenkins.plugins.logstash.configuration.Syslog;
import jenkins.plugins.logstash.persistence.LogstashIndexerDao;
import net.sf.json.JSONObject;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.http.client.utils.URIBuilder;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class LogstashConfiguration
extends GlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger(LogstashConfiguration.class.getName());
    private static final FastDateFormat MILLIS_FORMATTER = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final FastDateFormat LEGACY_FORMATTER = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ssZ");
    private LogstashIndexer<?> logstashIndexer;
    private Boolean enabled;
    private boolean dataMigrated = false;
    private boolean enableGlobally = false;
    private boolean milliSecondTimestamps = true;
    private transient LogstashIndexer<?> activeIndexer;
    private transient boolean configuring = false;

    public LogstashConfiguration() {
        this.load();
        if (this.enabled == null) {
            this.enabled = this.logstashIndexer == null ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        this.activeIndexer = this.logstashIndexer;
    }

    public boolean isEnabled() {
        return this.enabled == null ? false : this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnableGlobally() {
        return this.enableGlobally;
    }

    public void setEnableGlobally(boolean enableGlobally) {
        this.enableGlobally = enableGlobally;
    }

    public boolean isMilliSecondTimestamps() {
        return this.milliSecondTimestamps;
    }

    public void setMilliSecondTimestamps(boolean milliSecondTimestamps) {
        this.milliSecondTimestamps = milliSecondTimestamps;
    }

    public FastDateFormat getDateFormatter() {
        if (this.milliSecondTimestamps) {
            return MILLIS_FORMATTER;
        }
        return LEGACY_FORMATTER;
    }

    public LogstashIndexer<?> getLogstashIndexer() {
        return this.logstashIndexer;
    }

    public void setLogstashIndexer(LogstashIndexer<?> logstashIndexer) {
        this.logstashIndexer = logstashIndexer;
        if (!this.configuring && !Objects.equals(logstashIndexer, this.activeIndexer)) {
            this.activeIndexer = logstashIndexer;
        }
    }

    @CheckForNull
    public LogstashIndexerDao getIndexerInstance() {
        if (this.activeIndexer != null) {
            return this.activeIndexer.getInstance();
        }
        return null;
    }

    public List<?> getIndexerTypes() {
        return LogstashIndexer.all();
    }

    @Initializer(after=InitMilestone.JOB_LOADED)
    public void migrateData() {
        if (!this.dataMigrated) {
            LogstashInstallation.Descriptor descriptor = LogstashInstallation.getLogstashDescriptor();
            if (descriptor.getType() != null) {
                LogstashIndexerDao.IndexerType type = descriptor.getType();
                switch (type) {
                    case REDIS: {
                        LOGGER.log(Level.INFO, "Migrating logstash configuration for Redis");
                        Redis redis = new Redis();
                        redis.setHost(descriptor.getHost());
                        redis.setPort(descriptor.getPort());
                        redis.setKey(descriptor.getKey());
                        redis.setPassword(Secret.fromString((String)descriptor.getPassword()));
                        this.logstashIndexer = redis;
                        this.enabled = true;
                        break;
                    }
                    case ELASTICSEARCH: {
                        LOGGER.log(Level.INFO, "Migrating logstash configuration for Elastic Search");
                        try {
                            URI uri = new URIBuilder(descriptor.getHost()).setPort(descriptor.getPort().intValue()).setPath("/" + descriptor.getKey()).build();
                            ElasticSearch es = new ElasticSearch();
                            es.setUri(uri);
                            es.setUsername(descriptor.getUsername());
                            es.setPassword(Secret.fromString((String)descriptor.getPassword()));
                            this.logstashIndexer = es;
                            this.enabled = true;
                        }
                        catch (URISyntaxException e) {
                            this.enabled = false;
                            LOGGER.log(Level.INFO, "Migrating logstash configuration for Elastic Search failed: " + e.toString());
                        }
                        break;
                    }
                    case RABBIT_MQ: {
                        LOGGER.log(Level.INFO, "Migrating logstash configuration for RabbitMQ");
                        RabbitMq rabbitMq = new RabbitMq("");
                        rabbitMq.setHost(descriptor.getHost());
                        rabbitMq.setPort(descriptor.getPort());
                        rabbitMq.setQueue(descriptor.getKey());
                        rabbitMq.setUsername(descriptor.getUsername());
                        rabbitMq.setPassword(Secret.fromString((String)descriptor.getPassword()));
                        this.logstashIndexer = rabbitMq;
                        this.enabled = true;
                        break;
                    }
                    case SYSLOG: {
                        LOGGER.log(Level.INFO, "Migrating logstash configuration for  SYSLOG");
                        Syslog syslog = new Syslog();
                        syslog.setHost(descriptor.getHost());
                        syslog.setPort(descriptor.getPort());
                        syslog.setSyslogProtocol(descriptor.getSyslogProtocol());
                        switch (descriptor.getSyslogFormat()) {
                            case RFC3164: {
                                syslog.setMessageFormat(MessageFormat.RFC_3164);
                                break;
                            }
                            case RFC5424: {
                                syslog.setMessageFormat(MessageFormat.RFC_5424);
                                break;
                            }
                            default: {
                                syslog.setMessageFormat(MessageFormat.RFC_3164);
                            }
                        }
                        this.logstashIndexer = syslog;
                        this.enabled = true;
                        break;
                    }
                    default: {
                        LOGGER.log(Level.INFO, "unknown logstash Indexer type: " + String.valueOf((Object)type));
                        this.enabled = false;
                    }
                }
                this.milliSecondTimestamps = false;
                this.activeIndexer = this.logstashIndexer;
            }
            this.dataMigrated = true;
            this.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean configure(StaplerRequest staplerRequest, JSONObject json) throws Descriptor.FormException {
        Boolean e = json.getBoolean("enabled");
        if (!e.booleanValue()) {
            this.enabled = false;
            this.save();
            return true;
        }
        this.configuring = true;
        try {
            staplerRequest.bindJSON((Object)this, json);
            try {
                this.logstashIndexer.validate();
            }
            catch (Exception ex) {
                this.logstashIndexer = this.activeIndexer;
                throw new IllegalArgumentException(ex);
            }
            if (!Objects.equals(this.logstashIndexer, this.activeIndexer)) {
                this.activeIndexer = this.logstashIndexer;
            }
            this.save();
            boolean bl = true;
            return bl;
        }
        finally {
            this.configuring = false;
        }
    }

    public static LogstashConfiguration getInstance() {
        return (LogstashConfiguration)((Object)ExtensionList.lookupSingleton(LogstashConfiguration.class));
    }
}

