/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.logparser;

import hudson.console.ConsoleNote;
import hudson.plugins.logparser.LogParserUtils;
import hudson.plugins.logparser.ParsingRulePattern;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class LineToStatus
implements UnaryOperator<String> {
    private final List<ParsingRulePattern> patterns;

    LineToStatus(List<ParsingRulePattern> patterns) {
        this.patterns = patterns;
    }

    @Override
    public String apply(String s) {
        String line = ConsoleNote.removeNotes((String)s);
        for (ParsingRulePattern parsingRulePattern : this.patterns) {
            Pattern pattern;
            Matcher matcher;
            String rule = parsingRulePattern.getRule();
            if (LogParserUtils.skipParsingRule(rule) || !(matcher = (pattern = parsingRulePattern.getPattern()).matcher(line)).find()) continue;
            String status = rule.split("\\s")[0];
            return LogParserUtils.standardizeStatus(status);
        }
        return "NONE";
    }
}

