/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.loadninja.plugins.jenkins;

import com.smartbear.loadninja.api.SimpleAPI;
import com.smartbear.loadninja.helper.TestSummary;
import com.smartbear.loadninja.plugins.jenkins.LoadNinjaTestAction;
import com.smartbear.loadninja.plugins.jenkins.Messages;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class LoadNinjaBuilder
extends Builder
implements SimpleBuildStep {
    private final String apiKey;
    private final String scenarioId;
    private String errorPassCriteria;
    private String durationPassCriteria;

    @DataBoundConstructor
    public LoadNinjaBuilder(String apiKey, String scenarioId, OptionalErrorBlock oeb, OptionalDurationBlock odb) {
        this.apiKey = apiKey;
        this.scenarioId = scenarioId;
        this.errorPassCriteria = oeb != null ? oeb.errorPassCriteria : null;
        this.durationPassCriteria = odb != null ? odb.durationPassCriteria : null;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getScenarioId() {
        return this.scenarioId;
    }

    public int getErrorPassCriteria() {
        return Integer.parseInt(this.errorPassCriteria);
    }

    public double getDurationPassCriteria() {
        return Double.parseDouble(this.durationPassCriteria);
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        Timestamp startTimestamp = new Timestamp(System.currentTimeMillis());
        long startTime = startTimestamp.getTime();
        LoadNinjaTestAction lt = new LoadNinjaTestAction(this.scenarioId);
        run.addAction((Action)lt);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        listener.getLogger().println("[" + df.format(new Date()) + "] Firing load test, from scenario: " + this.scenarioId + ", using APIKEY: " + this.apiKey + "!");
        String scenario = SimpleAPI.getScenarioFromId(this.apiKey, this.scenarioId);
        listener.getLogger().println("[" + df.format(new Date()) + "] Scenario got from scenarioId: " + scenario);
        LoadNinjaBuilder.sleep(10L);
        String testId = SimpleAPI.runTest(this.apiKey, scenario);
        listener.getLogger().println("[" + df.format(new Date()) + "] Running test with testId:  " + testId);
        lt.setTestId(testId);
        String status = "";
        int sleepControl = 0;
        String ts = "";
        while (!status.equals("TEST_COMPLETE")) {
            if (sleepControl % 60 == 0) {
                status = SimpleAPI.getTestStatus(this.apiKey, testId);
                listener.getLogger().println("[" + df.format(new Date()) + "] Check if the test is still running. Test status: " + status);
            }
            if ((ts = SimpleAPI.getTestSummary(this.apiKey, testId)).equals("No test summary results available yet.")) {
                lt.setHasNoData(true);
            } else {
                listener.getLogger().println("[" + df.format(new Date()) + "] " + ts);
                lt.setHasNoData(false);
            }
            sleepControl += 5;
            LoadNinjaBuilder.sleep(5L);
        }
        Timestamp endTimestamp = new Timestamp(System.currentTimeMillis());
        long endTime = endTimestamp.getTime();
        status = "";
        listener.getLogger().println("[" + df.format(new Date()) + "] Load test, " + testId + ", ended ok.");
        ts = SimpleAPI.getTestSummary(this.apiKey, testId);
        listener.getLogger().println("[" + df.format(new Date()) + "]" + ts);
        TestSummary fts = SimpleAPI.getFinalTestSummary(this.apiKey, testId);
        boolean passed = true;
        boolean errorFail = false;
        boolean durationFail = false;
        int numChecks = 0;
        if (fts.getTotalSteps() != -1 && fts.getPassedStepCount() != -1 && fts.getFailedStepCount() != -1 && fts.getAvgResponseTime() != -1) {
            if (this.errorPassCriteria != null) {
                boolean bl = errorFail = !((float)fts.getFailedStepCount() / (float)fts.getTotalSteps() * 100.0f <= (float)this.getErrorPassCriteria());
                if (errorFail) {
                    ++numChecks;
                }
            }
            if (this.durationPassCriteria != null) {
                boolean bl = durationFail = !((double)fts.getAvgResponseTime() <= this.getDurationPassCriteria() * 1000.0);
                if (durationFail) {
                    ++numChecks;
                }
            }
        }
        Object instant = startTimestamp.toString().replace(" ", "T");
        instant = (String)instant + "Z";
        Object jUnit = "";
        jUnit = (String)jUnit + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        jUnit = (String)jUnit + "<testsuites name=\"LoadNinja Load Test (" + testId + ")\" tests=\"1\" failures=\"" + (numChecks > 0 ? 1 : 0) + "\" time=\"" + (endTime - startTime) + "\">\n";
        jUnit = (String)jUnit + "\t<testsuite name=\"LoadNinja Load Test (" + testId + ")\" tests=\"1\" failures=\"" + (numChecks > 0 ? 1 : 0) + "\" hostname=\"localhost\" time=\"" + (endTime - startTime) + "\" timestamp=\"" + (String)instant + "\">\n";
        jUnit = (String)jUnit + "\t\t<testcase name=\"LoadNinja Load Test (" + testId + ")\">\n";
        passed = !errorFail && !durationFail;
        status = passed ? "Load Test Passed" : "Load Test Failed";
        lt.setStatus(status);
        if (!passed) {
            jUnit = (String)jUnit + "\t\t\t<failure message=\"";
            if (errorFail) {
                jUnit = (String)jUnit + "Percentage of errors (" + (float)fts.getFailedStepCount() / (float)fts.getTotalSteps() * 100.0f + "%) has surpassed the error pass criteria of " + this.getErrorPassCriteria() + "%";
                listener.getLogger().println("[" + df.format(new Date()) + "] Load test, " + testId + ", has failed because percentage of errors (" + (float)fts.getFailedStepCount() / (float)fts.getTotalSteps() * 100.0f + "%) has surpassed the error pass criteria of " + this.getErrorPassCriteria() + "%.");
                if (!durationFail) {
                    jUnit = (String)jUnit + ".";
                }
            }
            if (durationFail) {
                if (errorFail) {
                    jUnit = (String)jUnit + " and ";
                }
                jUnit = (String)jUnit + "Average step duration (" + fts.getAvgResponseTime() + "ms) has surpassed the duration pass criteria of " + this.getDurationPassCriteria() * 1000.0 + "ms.";
                listener.getLogger().println("[" + df.format(new Date()) + "] Load test, " + testId + ", has failed because average step duration  (" + fts.getAvgResponseTime() + "ms) has surpassed the duration pass criteria of " + this.getDurationPassCriteria() * 1000.0 + "ms.");
            }
            jUnit = (String)jUnit + " For more information, go to https://app.loadninja.com/test-results/" + testId + ".\"></failure>\n";
            jUnit = (String)jUnit + "\t\t</testcase>\n";
            jUnit = (String)jUnit + "\t</testsuite>\n";
            jUnit = (String)jUnit + "</testsuites>\n";
            FilePath fp = new FilePath(workspace, "results.xml");
            fp.write((String)jUnit, null);
            throw new IOException("[" + df.format(new Date()) + "] Load test, " + testId + " has failed to meet the criteria(s) set.");
        }
        if (passed && fts.getTotalSteps() == -1 && fts.getPassedStepCount() == -1 && fts.getFailedStepCount() == -1 && fts.getAvgResponseTime() == -1) {
            listener.getLogger().println("[" + df.format(new Date()) + "] No test summary results or jUnit xml available. Test was terminated before any data was recorded.");
        }
        listener.getLogger().println("[" + df.format(new Date()) + "] Load test, " + testId + ", has passed.");
        jUnit = (String)jUnit + "\t\t</testcase>\n";
        jUnit = (String)jUnit + "\t</testsuite>\n";
        jUnit = (String)jUnit + "</testsuites>\n";
        FilePath fp = new FilePath(workspace, "results.xml");
        fp.write((String)jUnit, null);
    }

    private static void sleep(long ts) {
        try {
            Thread.sleep(ts * 1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class OptionalErrorBlock {
        private String errorPassCriteria;

        @DataBoundConstructor
        public OptionalErrorBlock(String errorPassCriteria) {
            this.errorPassCriteria = errorPassCriteria;
        }
    }

    public static class OptionalDurationBlock {
        private String durationPassCriteria;

        @DataBoundConstructor
        public OptionalDurationBlock(String durationPassCriteria) {
            this.durationPassCriteria = durationPassCriteria;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public FormValidation doCheckErrorPassCriteria(@QueryParameter(value="errorPassCriteria") String errorPassCriteria) throws IOException, ServletException {
            if (errorPassCriteria.equals("") || Integer.parseInt(errorPassCriteria) < 0 || Integer.parseInt(errorPassCriteria) > 100) {
                FormValidation fv = FormValidation.error((String)"Your pass criteria must be no less than 0 and no more than 100");
                return fv;
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckDurationPassCriteria(@QueryParameter(value="durationPassCriteria") String durationPassCriteria) throws IOException, ServletException {
            if (durationPassCriteria.equals("") || Double.parseDouble(durationPassCriteria) < 0.0) {
                return FormValidation.error((String)"Your pass criteria must be no less than 0");
            }
            String[] tokens = durationPassCriteria.split("\\.");
            if (tokens.length == 2 && tokens[1].length() > 2) {
                return FormValidation.error((String)"Your pass criteria must not have more than 2 digits after the decimal");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doValidateAPIKey(@QueryParameter(value="apiKey") String apiKey) throws IOException, ServletException {
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            try {
                boolean isValid = SimpleAPI.validateAPIKey(apiKey);
                return isValid ? FormValidation.ok((String)"API Key is valid") : FormValidation.error((String)"API Key is not valid");
            }
            catch (Exception e) {
                return FormValidation.error((String)("Client error : " + e.getMessage()));
            }
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.HelloWorldBuilder_DescriptorImpl_DisplayName();
        }
    }
}

