/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.loadninja.api;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.smartbear.loadninja.helper.TestSummary;
import java.util.HashMap;
import java.util.Map;

public class SimpleAPI {
    public static boolean validateAPIKey(String apiKey) {
        try {
            HttpResponse jsonResponse = Unirest.get((String)"https://ldsj2iwi73.execute-api.us-east-1.amazonaws.com/prd/authcheck").headers(SimpleAPI.getHeaders(apiKey)).asJson();
            return jsonResponse.getStatus() == 200;
        }
        catch (UnirestException ue) {
            throw new RuntimeException(ue);
        }
    }

    public static String getScenarioFromId(String apiKey, String scenarioId) {
        try {
            HttpResponse jsonResponse = Unirest.get((String)("https://ldsj2iwi73.execute-api.us-east-1.amazonaws.com/prd/scenario/" + scenarioId)).headers(SimpleAPI.getHeaders(apiKey)).asJson();
            if (jsonResponse.getStatus() == 200) {
                String data = ((JsonNode)jsonResponse.getBody()).getObject().getJSONObject("data").toString();
                return data;
            }
            throw new RuntimeException("Error getting scenario: " + String.valueOf(jsonResponse.getBody()));
        }
        catch (UnirestException ue) {
            throw new RuntimeException(ue);
        }
    }

    public static String runTest(String apiKey, String scenario) {
        try {
            HttpResponse jsonResponse = Unirest.post((String)"https://ldsj2iwi73.execute-api.us-east-1.amazonaws.com/prd/test-run").headers(SimpleAPI.getHeaders(apiKey)).body(scenario).asJson();
            if (jsonResponse.getStatus() == 200) {
                String testId = ((JsonNode)jsonResponse.getBody()).getObject().getJSONObject("data").getString("testId");
                return testId;
            }
            throw new RuntimeException("Error starting test: " + String.valueOf(jsonResponse.getBody()));
        }
        catch (UnirestException ue) {
            throw new RuntimeException(ue);
        }
    }

    private static Map<String, String> getHeaders(String apiKey) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("accept", "application/json");
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", apiKey);
        return headers;
    }

    public static String getTestStatus(String apiKey, String testId) {
        try {
            HttpResponse jsonResponse = Unirest.get((String)("https://ldsj2iwi73.execute-api.us-east-1.amazonaws.com/prd/test-run/" + testId + "/status")).headers(SimpleAPI.getHeaders(apiKey)).asJson();
            if (jsonResponse.getStatus() == 200) {
                String status = ((JsonNode)jsonResponse.getBody()).getObject().getJSONObject("data").getString("status");
                return status;
            }
            throw new RuntimeException("Error getting status of test: " + String.valueOf(jsonResponse.getBody()));
        }
        catch (UnirestException ue) {
            throw new RuntimeException(ue);
        }
    }

    public static String getTestSummary(String apiKey, String testId) {
        try {
            HttpResponse jsonResponse = Unirest.get((String)("https://ldsj2iwi73.execute-api.us-east-1.amazonaws.com/prd/test-run/" + testId + "/summary?lastRow=true")).headers(SimpleAPI.getHeaders(apiKey)).asJson();
            if (jsonResponse.getStatus() == 200) {
                try {
                    return ((JsonNode)jsonResponse.getBody()).getObject().getJSONObject("data").toString().replaceAll("\"", "").replace("{", "").replace("}", "");
                }
                catch (Exception e) {
                    return "No test summary results available yet.";
                }
            }
            throw new RuntimeException("Error getting summary of test: " + String.valueOf(jsonResponse.getBody()));
        }
        catch (UnirestException ue) {
            throw new RuntimeException(ue);
        }
    }

    public static TestSummary getFinalTestSummary(String apiKey, String testId) {
        try {
            HttpResponse jsonResponse = Unirest.get((String)("https://ldsj2iwi73.execute-api.us-east-1.amazonaws.com/prd/test-run/" + testId + "/summary?lastRow=true")).headers(SimpleAPI.getHeaders(apiKey)).asJson();
            if (jsonResponse.getStatus() == 200) {
                try {
                    int totalSteps = ((JsonNode)jsonResponse.getBody()).getObject().getJSONObject("data").getInt("totalSteps");
                    int passedStepCount = ((JsonNode)jsonResponse.getBody()).getObject().getJSONObject("data").getInt("passedSteps");
                    int failedStepCount = ((JsonNode)jsonResponse.getBody()).getObject().getJSONObject("data").getInt("failedSteps");
                    int avgResponseTime = ((JsonNode)jsonResponse.getBody()).getObject().getJSONObject("data").getInt("avgResponseTimeMS");
                    TestSummary ts = new TestSummary(totalSteps, passedStepCount, failedStepCount, avgResponseTime);
                    return ts;
                }
                catch (Exception e) {
                    return new TestSummary(-1, -1, -1, -1);
                }
            }
            throw new RuntimeException("Error getting summary of test: " + String.valueOf(jsonResponse.getBody()));
        }
        catch (UnirestException ue) {
            throw new RuntimeException(ue);
        }
    }
}

