/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.junitattachments;

import hudson.FilePath;
import hudson.Util;
import hudson.plugins.junitattachments.AttachmentTestAction;
import hudson.tasks.junit.ClassResult;
import hudson.tasks.test.TestObject;
import java.util.List;
import java.util.Map;

public class TestClassAttachmentTestAction
extends AttachmentTestAction {
    private final Map<String, List<String>> attachments;
    private final boolean attachmentsStoredAtClassLevel;
    private final List<String> blocks;

    public TestClassAttachmentTestAction(ClassResult classResult, FilePath storage, Map<String, List<String>> attachments, boolean attachmentsStoredAtClassLevel, List<String> blocks) {
        super((TestObject)classResult, storage);
        this.attachments = attachments;
        this.attachmentsStoredAtClassLevel = attachmentsStoredAtClassLevel;
        this.blocks = blocks;
    }

    public Map<String, List<String>> getAttachments() {
        return this.attachments;
    }

    @Override
    public String getUrlName() {
        if (this.blocks == null || this.blocks.isEmpty()) {
            return "attachments";
        }
        return "attachments-" + String.join((CharSequence)"-", this.blocks);
    }

    public String getUrl(String testCase, String filename) {
        if (this.attachmentsStoredAtClassLevel) {
            return this.getUrlName() + "/" + Util.rawEncode((String)filename);
        }
        return this.getUrlName() + "/" + Util.rawEncode((String)testCase) + "/" + Util.rawEncode((String)filename);
    }
}

