/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.junitattachments;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.junitattachments.AttachmentTestAction;
import hudson.plugins.junitattachments.GetTestDataMethodObject;
import hudson.plugins.junitattachments.TestCaseAttachmentTestAction;
import hudson.plugins.junitattachments.TestClassAttachmentTestAction;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.ClassResult;
import hudson.tasks.junit.TestAction;
import hudson.tasks.junit.TestDataPublisher;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.TestObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class AttachmentPublisher
extends TestDataPublisher {
    private Boolean showAttachmentsAtClassLevel = true;
    private Boolean showAttachmentsInStdOut = true;

    @DataBoundConstructor
    public AttachmentPublisher() {
    }

    public boolean isShowAttachmentsAtClassLevel() {
        return this.showAttachmentsAtClassLevel != null ? this.showAttachmentsAtClassLevel : true;
    }

    public boolean isShowAttachmentsInStdOut() {
        return this.showAttachmentsInStdOut != null ? this.showAttachmentsInStdOut : true;
    }

    @DataBoundSetter
    public void setShowAttachmentsAtClassLevel(Boolean showAttachmentsAtClassLevel) {
        this.showAttachmentsAtClassLevel = showAttachmentsAtClassLevel;
    }

    @DataBoundSetter
    public void setShowAttachmentsInStdOut(Boolean showAttachmentsInStdOut) {
        this.showAttachmentsInStdOut = showAttachmentsInStdOut;
    }

    public static FilePath getAttachmentPath(Run<?, ?> build) {
        return new FilePath(new File(build.getRootDir().getAbsolutePath())).child("junit-attachments");
    }

    public static FilePath getAttachmentPath(FilePath root, String className, String testName) {
        FilePath dir = root;
        if (className != null && !className.isEmpty()) {
            dir = dir.child(TestObject.safe((String)className));
            if (testName != null && !testName.isEmpty()) {
                dir = dir.child(TestObject.safe((String)testName).replace("\"", ""));
            }
        }
        return dir;
    }

    public Data contributeTestData(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, TestResult testResult) throws IOException, InterruptedException {
        GetTestDataMethodObject methodObject = new GetTestDataMethodObject(build, workspace, launcher, listener, testResult);
        Map<String, Map<String, List<String>>> attachments = methodObject.getAttachments();
        if (attachments.isEmpty()) {
            return null;
        }
        return new Data(attachments, this.isShowAttachmentsAtClassLevel(), this.isShowAttachmentsInStdOut(), methodObject.getEnclosingBlocks());
    }

    public static class Data
    extends TestResultAction.Data {
        @Deprecated
        private transient Map<String, List<String>> attachments;
        private Map<String, Map<String, List<String>>> attachmentsMap;
        private Boolean showAttachmentsAtClassLevel;
        private Boolean showAttachmentsInStdOut;
        private List<String> enclosingBlocks;

        public Data(Map<String, Map<String, List<String>>> attachmentsMap, Boolean showAttachmentsAtClassLevel, Boolean showAttachmentsInStdOut, List<String> enclosingBlocks) {
            this.attachmentsMap = attachmentsMap;
            this.showAttachmentsAtClassLevel = showAttachmentsAtClassLevel;
            this.showAttachmentsInStdOut = showAttachmentsInStdOut;
            this.enclosingBlocks = enclosingBlocks == null ? null : new ArrayList<String>(enclosingBlocks);
        }

        public List<TestAction> getTestAction(hudson.tasks.junit.TestObject t) {
            AttachmentTestAction action;
            boolean attachmentsStoredAtClassLevel;
            String testName;
            String className;
            String packageName;
            TestObject testObject = (TestObject)t;
            if (testObject instanceof ClassResult) {
                if (!this.showAttachmentsAtClassLevel.booleanValue()) {
                    return Collections.emptyList();
                }
                if (this.enclosingBlocks != null && !this.enclosingBlocks.isEmpty()) {
                    ClassResult classResult = (ClassResult)testObject;
                    boolean found = false;
                    for (CaseResult child : classResult.getChildren()) {
                        if (!this.enclosingBlocks.equals(child.getSuiteResult().getEnclosingBlocks())) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        return Collections.emptyList();
                    }
                }
                packageName = testObject.getParent().getName();
                className = testObject.getName();
                testName = null;
            } else if (testObject instanceof CaseResult) {
                CaseResult caseResult = (CaseResult)testObject;
                if (this.enclosingBlocks != null && !this.enclosingBlocks.isEmpty() && !this.enclosingBlocks.equals(caseResult.getSuiteResult().getEnclosingBlocks())) {
                    return Collections.emptyList();
                }
                packageName = testObject.getParent().getParent().getName();
                className = testObject.getParent().getName();
                testName = testObject.getName();
            } else {
                return Collections.emptyList();
            }
            String fullName = Data.getFullyQualifiedTestClassName(packageName, className);
            Map<String, List<String>> tests = this.attachmentsMap.get(fullName);
            if (tests == null) {
                return Collections.emptyList();
            }
            FilePath root = AttachmentPublisher.getAttachmentPath(testObject.getRun());
            if (this.enclosingBlocks != null && !this.enclosingBlocks.isEmpty()) {
                root = root.child(String.join((CharSequence)"-", this.enclosingBlocks));
            }
            boolean bl = attachmentsStoredAtClassLevel = this.enclosingBlocks == null && this.areAttachmentsStoredAtClassLevel(root, fullName, tests);
            if (testObject instanceof ClassResult) {
                ClassResult cr = (ClassResult)testObject;
                TreeMap<String, List<String>> sortedTests = new TreeMap<String, List<String>>(tests);
                action = new TestClassAttachmentTestAction(cr, AttachmentPublisher.getAttachmentPath(root, fullName, null), sortedTests, attachmentsStoredAtClassLevel, this.enclosingBlocks);
            } else {
                List<String> attachmentPaths = tests.get(testName);
                if (attachmentPaths == null || attachmentPaths.isEmpty()) {
                    return Collections.emptyList();
                }
                FilePath attachmentsDirectory = attachmentsStoredAtClassLevel ? AttachmentPublisher.getAttachmentPath(root, fullName, null) : AttachmentPublisher.getAttachmentPath(root, fullName, testName);
                action = new TestCaseAttachmentTestAction((CaseResult)testObject, attachmentsDirectory, attachmentPaths, this.showAttachmentsInStdOut);
            }
            return Collections.singletonList(action);
        }

        private Object readResolve() {
            if (this.showAttachmentsAtClassLevel == null) {
                this.showAttachmentsAtClassLevel = true;
            }
            if (this.showAttachmentsInStdOut == null) {
                this.showAttachmentsInStdOut = true;
            }
            if (this.attachments != null && this.attachmentsMap == null) {
                this.attachmentsMap = new HashMap<String, Map<String, List<String>>>();
                for (Map.Entry<String, List<String>> entry : this.attachments.entrySet()) {
                    HashMap<String, List<String>> testMap = new HashMap<String, List<String>>();
                    testMap.put("", entry.getValue());
                    this.attachmentsMap.put(entry.getKey(), testMap);
                }
                this.attachments = null;
            }
            return this;
        }

        private static String getFullyQualifiedTestClassName(String packageName, String className) {
            Object fullName = "";
            if (!packageName.equals("(root)")) {
                fullName = (String)fullName + packageName;
                fullName = (String)fullName + ".";
            }
            fullName = (String)fullName + className;
            return fullName;
        }

        private boolean areAttachmentsStoredAtClassLevel(FilePath root, String fullName, Map<String, List<String>> classAttachments) {
            for (Map.Entry<String, List<String>> entry : classAttachments.entrySet()) {
                for (String attachment : entry.getValue()) {
                    FilePath testCaseAttachmentsDirectory = AttachmentPublisher.getAttachmentPath(root, fullName, entry.getKey());
                    FilePath testCaseAttachmentPath = new FilePath(testCaseAttachmentsDirectory, attachment);
                    try {
                        if (!testCaseAttachmentPath.exists()) continue;
                        return false;
                    }
                    catch (IOException | InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return true;
        }
    }

    @Extension
    @Symbol(value={"attachments"})
    public static class DescriptorImpl
    extends Descriptor<TestDataPublisher> {
        public String getDisplayName() {
            return "Publish test attachments";
        }
    }
}

