/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jobcacher;

import hudson.EnvVars;
import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.util.DirScanner;
import hudson.util.FileVisitor;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import jenkins.MasterToSlaveFileCallable;
import jenkins.plugins.itemstorage.ObjectPath;
import org.kohsuke.stapler.Stapler;

public abstract class Cache
extends AbstractDescribableImpl<Cache>
implements ExtensionPoint,
Serializable {
    private static final long serialVersionUID = 1L;

    public abstract Saver cache(ObjectPath var1, ObjectPath var2, Run<?, ?> var3, FilePath var4, Launcher var5, TaskListener var6, EnvVars var7, boolean var8) throws IOException, InterruptedException;

    public abstract String getTitle();

    public Job<?, ?> getJob() {
        return (Job)Stapler.getCurrentRequest2().findAncestorObject(Job.class);
    }

    public static String deriveCachePath(String path) {
        return Util.getDigestOf((String)path);
    }

    public static class DirectorySize
    extends MasterToSlaveFileCallable<Long> {
        private static final long serialVersionUID = 1L;
        private final String glob;
        private final String excludes;

        public DirectorySize(String glob, String excludes) {
            this.glob = glob;
            this.excludes = excludes;
        }

        public Long invoke(File f, VirtualChannel channel) throws IOException {
            final AtomicLong total = new AtomicLong(0L);
            new DirScanner.Glob(this.glob, this.excludes).scan(f, new FileVisitor(){

                public void visit(File f, String relativePath) throws IOException {
                    if (f.isFile()) {
                        total.addAndGet(f.length());
                    }
                }

                public boolean understandsSymlink() {
                    return true;
                }

                public void visitSymlink(File link, String target, String relativePath) throws IOException {
                }
            });
            return total.get();
        }
    }

    public static abstract class Saver
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public abstract long calculateSize(ObjectPath var1, Run<?, ?> var2, FilePath var3, Launcher var4, TaskListener var5) throws IOException, InterruptedException;

        public abstract void save(ObjectPath var1, ObjectPath var2, Run<?, ?> var3, FilePath var4, Launcher var5, TaskListener var6) throws IOException, InterruptedException;
    }
}

