/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jobcacher.arbitrary;

import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import hudson.util.DirScanner;
import hudson.util.io.ArchiverFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import jenkins.MasterToSlaveFileCallable;
import jenkins.plugins.jobcacher.arbitrary.AbstractCompressingArbitraryFileCacheStrategy;
import org.apache.commons.compress.compressors.CompressorException;

public class TarArbitraryFileCacheStrategy
extends AbstractCompressingArbitraryFileCacheStrategy {
    private final CompressingOutputStreamFactory compressingOutputStreamFactory;
    private final CompressingInputStreamFactory compressingInputStreamFactory;
    private final String archiveExtension;

    public TarArbitraryFileCacheStrategy(CompressingOutputStreamFactory compressingOutputStreamFactory, CompressingInputStreamFactory compressingInputStreamFactory, String archiveExtension) {
        this.compressingOutputStreamFactory = compressingOutputStreamFactory;
        this.compressingInputStreamFactory = compressingInputStreamFactory;
        this.archiveExtension = archiveExtension;
    }

    @Override
    protected String getArchiveExtension() {
        return this.archiveExtension;
    }

    @Override
    protected void uncompress(FilePath source, FilePath target) throws IOException, InterruptedException {
        source.act((FilePath.FileCallable)new ExtractTarCallable(target, this.compressingInputStreamFactory));
    }

    @Override
    protected void compress(FilePath source, String includes, String excludes, boolean useDefaultExcludes, FilePath target) throws IOException, InterruptedException {
        target.act((FilePath.FileCallable)new CreateTarCallable(source, includes, excludes, useDefaultExcludes, this.compressingOutputStreamFactory));
    }

    public static interface CompressingOutputStreamFactory
    extends Serializable {
        public OutputStream createCompressingOutputStream(OutputStream var1) throws IOException;
    }

    public static interface CompressingInputStreamFactory
    extends Serializable {
        public InputStream createCompressingInputStream(InputStream var1) throws IOException;
    }

    private static class ExtractTarCallable
    extends MasterToSlaveFileCallable<Void> {
        private final FilePath target;
        private final CompressingInputStreamFactory compressingInputStreamFactory;

        public ExtractTarCallable(FilePath target, CompressingInputStreamFactory compressingInputStreamFactory) {
            this.target = target;
            this.compressingInputStreamFactory = compressingInputStreamFactory;
        }

        public Void invoke(File sourceFile, VirtualChannel channel) throws IOException, InterruptedException {
            try (InputStream inputStream = this.createInputStream(sourceFile);){
                this.target.untarFrom(inputStream, FilePath.TarCompression.NONE);
            }
            catch (CompressorException e) {
                throw new IOException(e);
            }
            return null;
        }

        private InputStream createInputStream(File sourceFile) throws IOException, CompressorException {
            InputStream inputStream = Files.newInputStream(sourceFile.toPath(), new OpenOption[0]);
            inputStream = new BufferedInputStream(inputStream);
            inputStream = this.compressingInputStreamFactory.createCompressingInputStream(inputStream);
            return new BufferedInputStream(inputStream);
        }
    }

    private static class CreateTarCallable
    extends MasterToSlaveFileCallable<Void> {
        private final FilePath source;
        private final String includes;
        private final String excludes;
        private final boolean useDefaultExcludes;
        private final CompressingOutputStreamFactory compressingOutputStreamFactory;

        public CreateTarCallable(FilePath source, String includes, String excludes, boolean useDefaultExcludes, CompressingOutputStreamFactory compressingOutputStreamFactory) {
            this.source = source;
            this.includes = includes;
            this.excludes = excludes;
            this.useDefaultExcludes = useDefaultExcludes;
            this.compressingOutputStreamFactory = compressingOutputStreamFactory;
        }

        public Void invoke(File targetFile, VirtualChannel channel) throws IOException, InterruptedException {
            try (OutputStream outputStream = this.createOutputStream(targetFile);){
                this.source.archive(ArchiverFactory.TAR, outputStream, (DirScanner)new DirScanner.Glob(this.includes, this.excludes, this.useDefaultExcludes));
            }
            catch (CompressorException e) {
                throw new IOException(e);
            }
            return null;
        }

        private OutputStream createOutputStream(File targetFile) throws IOException, CompressorException {
            OutputStream outputStream = Files.newOutputStream(targetFile.toPath(), new OpenOption[0]);
            outputStream = new BufferedOutputStream(outputStream);
            outputStream = this.compressingOutputStreamFactory.createCompressingOutputStream(outputStream);
            return outputStream;
        }
    }
}

