// CHECKSTYLE:OFF

package hudson.plugins.gradle;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code installer.displayName}: {@code Gradle}.
     * 
     * @return
     *     {@code Gradle}
     */
    public static String installer_displayName() {
        return holder.format("installer.displayName");
    }

    /**
     * Key {@code installer.displayName}: {@code Gradle}.
     * 
     * @return
     *     {@code Gradle}
     */
    public static Localizable _installer_displayName() {
        return new Localizable(holder, "installer.displayName");
    }

    /**
     * Key {@code InjectionConfig.InvalidShortLivedTokenExpiry}: {@code
     * Should be a integer between 1 and 24.}.
     * 
     * @return
     *     {@code Should be a integer between 1 and 24.}
     */
    public static String InjectionConfig_InvalidShortLivedTokenExpiry() {
        return holder.format("InjectionConfig.InvalidShortLivedTokenExpiry");
    }

    /**
     * Key {@code InjectionConfig.InvalidShortLivedTokenExpiry}: {@code
     * Should be a integer between 1 and 24.}.
     * 
     * @return
     *     {@code Should be a integer between 1 and 24.}
     */
    public static Localizable _InjectionConfig_InvalidShortLivedTokenExpiry() {
        return new Localizable(holder, "InjectionConfig.InvalidShortLivedTokenExpiry");
    }

    /**
     * Key {@code InjectionConfig.InvalidMavenExtensionCustomCoordinates}:
     * {@code Not a valid Maven groupId:artifactId(:version).}.
     * 
     * @return
     *     {@code Not a valid Maven groupId:artifactId(:version).}
     */
    public static String InjectionConfig_InvalidMavenExtensionCustomCoordinates() {
        return holder.format("InjectionConfig.InvalidMavenExtensionCustomCoordinates");
    }

    /**
     * Key {@code InjectionConfig.InvalidMavenExtensionCustomCoordinates}:
     * {@code Not a valid Maven groupId:artifactId(:version).}.
     * 
     * @return
     *     {@code Not a valid Maven groupId:artifactId(:version).}
     */
    public static Localizable _InjectionConfig_InvalidMavenExtensionCustomCoordinates() {
        return new Localizable(holder, "InjectionConfig.InvalidMavenExtensionCustomCoordinates");
    }

    /**
     * Key {@code wrapper.displayName}: {@code Inspect build log for
     * published build scans}.
     * 
     * @return
     *     {@code Inspect build log for published build scans}
     */
    public static String wrapper_displayName() {
        return holder.format("wrapper.displayName");
    }

    /**
     * Key {@code wrapper.displayName}: {@code Inspect build log for
     * published build scans}.
     * 
     * @return
     *     {@code Inspect build log for published build scans}
     */
    public static Localizable _wrapper_displayName() {
        return new Localizable(holder, "wrapper.displayName");
    }

    /**
     * Key {@code step.displayName}: {@code Invoke Gradle script}.
     * 
     * @return
     *     {@code Invoke Gradle script}
     */
    public static String step_displayName() {
        return holder.format("step.displayName");
    }

    /**
     * Key {@code step.displayName}: {@code Invoke Gradle script}.
     * 
     * @return
     *     {@code Invoke Gradle script}
     */
    public static Localizable _step_displayName() {
        return new Localizable(holder, "step.displayName");
    }

    /**
     * Key {@code InjectionConfig.InvalidVersion}: {@code Not a valid
     * version.}.
     * 
     * @return
     *     {@code Not a valid version.}
     */
    public static String InjectionConfig_InvalidVersion() {
        return holder.format("InjectionConfig.InvalidVersion");
    }

    /**
     * Key {@code InjectionConfig.InvalidVersion}: {@code Not a valid
     * version.}.
     * 
     * @return
     *     {@code Not a valid version.}
     */
    public static Localizable _InjectionConfig_InvalidVersion() {
        return new Localizable(holder, "InjectionConfig.InvalidVersion");
    }

    /**
     * Key {@code InjectionConfig.InvalidAccessKey}: {@code Not a valid
     * access key.}.
     * 
     * @return
     *     {@code Not a valid access key.}
     */
    public static String InjectionConfig_InvalidAccessKey() {
        return holder.format("InjectionConfig.InvalidAccessKey");
    }

    /**
     * Key {@code InjectionConfig.InvalidAccessKey}: {@code Not a valid
     * access key.}.
     * 
     * @return
     *     {@code Not a valid access key.}
     */
    public static Localizable _InjectionConfig_InvalidAccessKey() {
        return new Localizable(holder, "InjectionConfig.InvalidAccessKey");
    }

    /**
     * Key {@code InjectionConfig.Required}: {@code Required.}.
     * 
     * @return
     *     {@code Required.}
     */
    public static String InjectionConfig_Required() {
        return holder.format("InjectionConfig.Required");
    }

    /**
     * Key {@code InjectionConfig.Required}: {@code Required.}.
     * 
     * @return
     *     {@code Required.}
     */
    public static Localizable _InjectionConfig_Required() {
        return new Localizable(holder, "InjectionConfig.Required");
    }

    /**
     * Key {@code InjectionConfig.InvalidUrl}: {@code Not a valid URL.}.
     * 
     * @return
     *     {@code Not a valid URL.}
     */
    public static String InjectionConfig_InvalidUrl() {
        return holder.format("InjectionConfig.InvalidUrl");
    }

    /**
     * Key {@code InjectionConfig.InvalidUrl}: {@code Not a valid URL.}.
     * 
     * @return
     *     {@code Not a valid URL.}
     */
    public static Localizable _InjectionConfig_InvalidUrl() {
        return new Localizable(holder, "InjectionConfig.InvalidUrl");
    }

}
