/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.Item;
import hudson.security.Permission;
import hudson.security.SecurityRealm;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import okhttp3.Authenticator;
import okhttp3.OkHttpClient;
import org.jenkinsci.plugins.GithubOAuthUserDetails;
import org.jenkinsci.plugins.GithubSecurityRealm;
import org.jenkinsci.plugins.JenkinsProxyAuthenticator;
import org.kohsuke.github.GHMyself;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.RateLimitHandler;
import org.kohsuke.github.connector.GitHubConnector;
import org.kohsuke.github.extras.okhttp3.OkHttpGitHubConnector;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class GithubAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 2L;
    private final String accessToken;
    private final String githubServer;
    private final String userName;
    private transient GitHub gh;
    private transient GHMyself me;
    private transient GithubSecurityRealm myRealm = null;
    public static final TimeUnit CACHE_EXPIRY = TimeUnit.HOURS;
    private static final Cache<String, Set<String>> userOrganizationCache = Caffeine.newBuilder().expireAfterWrite(1L, CACHE_EXPIRY).build();
    private static final Cache<String, Cache<String, RepoRights>> repositoriesByUserCache = Caffeine.newBuilder().expireAfterWrite(24L, CACHE_EXPIRY).build();
    private static final Cache<String, Boolean> repositoriesPublicStatusCache = Caffeine.newBuilder().expireAfterWrite(1L, CACHE_EXPIRY).build();
    private static final Cache<String, GithubUser> usersByIdCache = Caffeine.newBuilder().expireAfterWrite(1L, CACHE_EXPIRY).build();
    private static final Cache<String, GithubMyself> usersByTokenCache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
    private static final Cache<String, Map<String, Set<GHTeam>>> userTeamsCache = Caffeine.newBuilder().expireAfterWrite(1L, CACHE_EXPIRY).build();
    private final List<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
    private static final GithubUser UNKNOWN_USER = new GithubUser(null);
    private static final GithubMyself UNKNOWN_TOKEN = new GithubMyself(null);
    private static final Logger LOGGER = Logger.getLogger(GithubAuthenticationToken.class.getName());

    public GithubAuthenticationToken(String accessToken, String githubServer) throws IOException {
        this(accessToken, githubServer, false);
    }

    public GithubAuthenticationToken(String accessToken, String githubServer, boolean clearUserCache) throws IOException {
        super(List.of());
        this.accessToken = accessToken;
        this.githubServer = githubServer;
        this.me = this.loadMyself(accessToken);
        if (this.me == null) {
            throw new UsernameNotFoundException("Token not valid");
        }
        this.setAuthenticated(true);
        this.userName = this.me.getLogin();
        if (clearUserCache) {
            GithubAuthenticationToken.clearCacheForUser(this.userName);
        }
        this.authorities.add(SecurityRealm.AUTHENTICATED_AUTHORITY2);
        Jenkins jenkins = Jenkins.get();
        if (jenkins.getSecurityRealm() instanceof GithubSecurityRealm) {
            if (this.myRealm == null) {
                this.myRealm = (GithubSecurityRealm)jenkins.getSecurityRealm();
            }
            if (this.myRealm.hasScope("read:org") || this.myRealm.hasScope("admin:org") || this.myRealm.hasScope("user") || this.myRealm.hasScope("repo")) {
                Set<String> myOrgs = this.getUserOrgs();
                Map myTeams = (Map)userTeamsCache.get((Object)this.userName, unused -> {
                    try {
                        return this.getGitHub().getMyTeams();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("authorization failed for user = " + this.userName, e);
                    }
                });
                for (String string : myOrgs) {
                    if (myTeams.containsKey(string)) continue;
                    myTeams.put(string, Collections.emptySet());
                }
                for (Map.Entry entry : myTeams.entrySet()) {
                    String orgLogin = (String)entry.getKey();
                    LOGGER.log(Level.FINE, "Fetch teams for user " + this.userName + " in organization " + orgLogin);
                    this.authorities.add((GrantedAuthority)new SimpleGrantedAuthority(orgLogin));
                    for (GHTeam team : (Set)entry.getValue()) {
                        String teamIdentifier = team.getSlug() == null ? team.getName() : team.getSlug();
                        this.authorities.add((GrantedAuthority)new SimpleGrantedAuthority(orgLogin + "*" + teamIdentifier));
                    }
                }
            }
        }
    }

    public static void clearCaches() {
        userOrganizationCache.invalidateAll();
        repositoriesByUserCache.invalidateAll();
        repositoriesPublicStatusCache.invalidateAll();
        usersByIdCache.invalidateAll();
        usersByTokenCache.invalidateAll();
        userTeamsCache.invalidateAll();
    }

    public static void clearCacheForUser(String userName) {
        userOrganizationCache.invalidate((Object)userName);
        repositoriesByUserCache.invalidate((Object)userName);
        usersByIdCache.invalidate((Object)userName);
        userTeamsCache.invalidate((Object)userName);
    }

    String getAccessToken() {
        return this.accessToken;
    }

    String getGithubServer() {
        return this.githubServer;
    }

    GitHub getGitHub() throws IOException {
        if (this.gh == null) {
            String host;
            try {
                host = new URL(this.githubServer).getHost();
            }
            catch (MalformedURLException e) {
                throw new IOException("Invalid GitHub API URL: " + this.githubServer, e);
            }
            OkHttpClient client = new OkHttpClient.Builder().proxy(GithubAuthenticationToken.getProxy(host)).proxyAuthenticator((Authenticator)new JenkinsProxyAuthenticator(Jenkins.get().getProxy())).build();
            this.gh = GitHubBuilder.fromEnvironment().withEndpoint(this.githubServer).withOAuthToken(this.accessToken).withRateLimitHandler(RateLimitHandler.FAIL).withConnector((GitHubConnector)new OkHttpGitHubConnector(client)).build();
        }
        return this.gh;
    }

    @NonNull
    private static Proxy getProxy(@NonNull String host) {
        Jenkins jenkins = Jenkins.get();
        if (jenkins.proxy == null) {
            return Proxy.NO_PROXY;
        }
        return jenkins.proxy.createProxy(host);
    }

    public Collection<GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public Object getCredentials() {
        return "";
    }

    public String getPrincipal() {
        return this.userName;
    }

    public GHMyself getMyself() throws IOException {
        if (this.me == null) {
            this.me = this.getGitHub().getMyself();
        }
        return this.me;
    }

    @NonNull
    private Set<String> getUserOrgs() {
        return (Set)userOrganizationCache.get((Object)this.userName, unused -> {
            try {
                return this.getGitHub().getMyOrganizations().keySet();
            }
            catch (IOException e) {
                throw new UncheckedIOException("authorization failed for user = " + this.userName, e);
            }
        });
    }

    @NonNull
    boolean isMemberOfAnyOrganizationInList(@NonNull Collection<String> organizations) {
        Set<String> userOrgs = this.getUserOrgs();
        for (String orgName : organizations) {
            if (!userOrgs.contains(orgName)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    boolean hasRepositoryPermission(@NonNull String repositoryName, @NonNull Permission permission) {
        Boolean isPublic;
        LOGGER.log(Level.FINEST, "Checking for permission: " + String.valueOf(permission) + " on repo: " + repositoryName + " for user: " + this.userName);
        boolean isReadPermission = this.isReadRelatedPermission(permission);
        if (isReadPermission && (isPublic = (Boolean)repositoriesPublicStatusCache.getIfPresent((Object)repositoryName)) != null && isPublic.booleanValue()) {
            return true;
        }
        RepoRights repository = this.loadRepository(repositoryName);
        if (repository.hasAdminAccess()) {
            return true;
        }
        if (isReadPermission) {
            return !repository.isPrivate() || repository.hasPullAccess() || repository.hasPushAccess();
        }
        if (permission.equals((Object)Item.CANCEL) || permission.equals((Object)Item.EXTENDED_READ)) {
            return repository.hasPushAccess();
        }
        return false;
    }

    @NonNull
    private boolean isReadRelatedPermission(@NonNull Permission permission) {
        return permission.equals((Object)Item.DISCOVER) || permission.equals((Object)Item.READ) || permission.equals((Object)Item.BUILD) || permission.equals((Object)Item.WORKSPACE);
    }

    @NonNull
    private Cache<String, RepoRights> myRepositories() {
        return (Cache)repositoriesByUserCache.get((Object)this.userName, unused -> {
            List userRepositoryList;
            try {
                userRepositoryList = this.getMyself().listRepositories(100).asList();
            }
            catch (IOException e) {
                throw new UncheckedIOException("authorization failed for user = " + this.userName, e);
            }
            Cache repoNameToRightsCache = Caffeine.newBuilder().expireAfterWrite(1L, CACHE_EXPIRY).build();
            for (GHRepository repo : userRepositoryList) {
                RepoRights rights = new RepoRights(repo);
                String repositoryName = repo.getFullName();
                repoNameToRightsCache.put((Object)repositoryName, (Object)rights);
                repositoriesPublicStatusCache.put((Object)repositoryName, (Object)(!rights.isPrivate() ? 1 : 0));
            }
            return repoNameToRightsCache;
        });
    }

    @Nullable
    GHUser loadUser(@NonNull String username) throws IOException {
        GithubUser user;
        try {
            user = (GithubUser)usersByIdCache.getIfPresent((Object)username);
            if (this.gh != null && user == null && this.isAuthenticated()) {
                GHUser ghUser = this.getGitHub().getUser(username);
                user = new GithubUser(ghUser);
                usersByIdCache.put((Object)username, (Object)user);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINEST, e.getMessage(), e);
            user = UNKNOWN_USER;
            usersByIdCache.put((Object)username, (Object)UNKNOWN_USER);
        }
        return user != null ? user.user : null;
    }

    private GHMyself loadMyself(@NonNull String token) throws IOException {
        GithubMyself me;
        try {
            me = (GithubMyself)usersByTokenCache.getIfPresent((Object)token);
            if (me == null) {
                GHMyself ghMyself = this.getGitHub().getMyself();
                me = new GithubMyself(ghMyself);
                usersByTokenCache.put((Object)token, (Object)me);
                String username = ghMyself.getLogin();
                usersByIdCache.put((Object)username, (Object)new GithubUser((GHUser)ghMyself));
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, e.getMessage(), e);
            me = UNKNOWN_TOKEN;
            usersByTokenCache.put((Object)token, (Object)UNKNOWN_TOKEN);
        }
        return me.me;
    }

    @Nullable
    GHOrganization loadOrganization(@NonNull String organization) {
        try {
            if (this.gh != null && this.isAuthenticated()) {
                return this.getGitHub().getOrganization(organization);
            }
        }
        catch (IOException | RuntimeException e) {
            LOGGER.log(Level.FINEST, e.getMessage(), e);
        }
        return null;
    }

    @NonNull
    private RepoRights loadRepository(@NonNull String repositoryName) {
        try {
            if (this.gh != null && this.isAuthenticated() && (this.myRealm.hasScope("repo") || this.myRealm.hasScope("public_repo"))) {
                Cache<String, RepoRights> repoNameToRightsCache = this.myRepositories();
                return (RepoRights)repoNameToRightsCache.get((Object)repositoryName, unused -> {
                    GHRepository repo;
                    try {
                        repo = this.getGitHub().getRepository(repositoryName);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    RepoRights rights = new RepoRights(repo);
                    repositoriesPublicStatusCache.put((Object)repositoryName, (Object)(!rights.isPrivate() ? 1 : 0));
                    return rights;
                });
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "an exception was thrown", e);
            LOGGER.log(Level.WARNING, "Looks like a bad GitHub URL OR the Jenkins user {0} does not have access to the repository {1}. May need to add 'repo' or 'public_repo' to the list of oauth scopes requested.", new Object[]{this.userName, repositoryName});
        }
        return new RepoRights(null);
    }

    @Nullable
    GHTeam loadTeam(@NonNull String organization, @NonNull String team) {
        try {
            GHOrganization org = this.loadOrganization(organization);
            if (org != null) {
                if (org.getTeamBySlug(team) != null) {
                    return org.getTeamBySlug(team);
                }
                return org.getTeamByName(team);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINEST, e.getMessage(), e);
        }
        return null;
    }

    @Nullable
    GithubOAuthUserDetails getUserDetails(@NonNull String username) throws IOException {
        GHUser user = this.loadUser(username);
        if (user != null) {
            return new GithubOAuthUserDetails(user.getLogin(), this.getAuthorities());
        }
        return null;
    }

    static class RepoRights {
        public final boolean hasAdminAccess;
        public final boolean hasPullAccess;
        public final boolean hasPushAccess;
        public final boolean isPrivate;

        public RepoRights(@Nullable GHRepository repo) {
            if (repo != null) {
                this.hasAdminAccess = repo.hasAdminAccess();
                this.hasPullAccess = repo.hasPullAccess();
                this.hasPushAccess = repo.hasPushAccess();
                this.isPrivate = repo.isPrivate();
            } else {
                this.hasAdminAccess = false;
                this.hasPullAccess = false;
                this.hasPushAccess = false;
                this.isPrivate = true;
            }
        }

        public boolean hasAdminAccess() {
            return this.hasAdminAccess;
        }

        public boolean hasPullAccess() {
            return this.hasPullAccess;
        }

        public boolean hasPushAccess() {
            return this.hasPushAccess;
        }

        public boolean isPrivate() {
            return this.isPrivate;
        }
    }

    static class GithubUser {
        public final GHUser user;

        public GithubUser(GHUser user) {
            this.user = user;
        }
    }

    static class GithubMyself {
        public final GHMyself me;

        public GithubMyself(GHMyself me) {
            this.me = me;
        }
    }
}

