/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.github.api.mock;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import hudson.Util;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletException;
import jenkins.plugins.github.api.mock.MockOrganization;
import jenkins.plugins.github.api.mock.MockOwner;
import jenkins.plugins.github.api.mock.MockRepository;
import jenkins.plugins.github.api.mock.MockUser;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.jvnet.hudson.test.ThreadPoolImpl;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class MockGitHub
implements Closeable {
    private AtomicLong nextId = new AtomicLong();
    private Map<String, MockUser> users = new HashMap<String, MockUser>();
    private Map<String, MockOrganization> organizations = new HashMap<String, MockOrganization>();
    private Server server;
    private int localPort = -1;
    private JsonFactory factory = new JsonFactory();

    public String open() throws IOException {
        this.server = new Server((ThreadPool)new ThreadPoolImpl((ExecutorService)new ThreadPoolExecutor(10, 10, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("Jetty Thread Pool");
                return t;
            }
        })));
        ServletContextHandler context = new ServletContextHandler();
        this.server.setHandler((Handler)context);
        context.addServlet(Stapler.class, "/*");
        ServerConnector connector = new ServerConnector(this.server);
        HttpConfiguration config = ((HttpConnectionFactory)connector.getConnectionFactory(HttpConnectionFactory.class)).getHttpConfiguration();
        config.setRequestHeaderSize(12288);
        connector.setHost("localhost");
        this.server.addConnector((Connector)connector);
        try {
            this.server.start();
        }
        catch (IOException | Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.localPort = connector.getLocalPort();
        context.getServletContext().setAttribute("app", (Object)this);
        return this.getUrl();
    }

    public String getUrl() {
        if (this.localPort == -1) {
            throw new IllegalStateException("Not open");
        }
        try {
            return new URI("http", null, "localhost", this.localPort, null, null, null).toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Will never happen", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.localPort = -1;
        try {
            this.server.stop();
        }
        catch (IOException | Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public Map<String, MockUser> getUsers() {
        return this.users;
    }

    public Map<String, MockOrganization> getOrgs() {
        return this.organizations;
    }

    public long nextId() {
        return this.nextId.incrementAndGet();
    }

    public String tz(long time) {
        SimpleDateFormat format = new SimpleDateFormat("YYYY-MM-dd'T'HH:mm:ss'Z'");
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format.format(new Date(time));
    }

    public String pathSegment(String segment) {
        return Util.rawEncode((String)segment);
    }

    public String pathFragment(String fragment) {
        StringBuilder result = new StringBuilder(fragment.length() + 10);
        int i0 = 0;
        int i1 = fragment.indexOf(47);
        while (i0 != -1) {
            if (i0 > 0) {
                result.append('/');
            }
            if (i1 == -1) {
                result.append(this.pathSegment(fragment.substring(i0)));
                i0 = i1;
                continue;
            }
            result.append(this.pathSegment(fragment.substring(i0, i1)));
            i0 = i1 + 1;
            i1 = fragment.indexOf(47, i0);
        }
        return result.toString();
    }

    public String json(Object object) throws IOException {
        if (object == null) {
            return "null";
        }
        StringWriter w = new StringWriter();
        JsonGenerator generator = this.factory.createGenerator((Writer)w);
        generator.writeObject(object);
        generator.close();
        return w.toString();
    }

    public MockUser withUser(String login) {
        MockUser result = new MockUser(this, login);
        this.users.put(login, result);
        return result;
    }

    public MockOrganization withOrg(String login) {
        MockOrganization result = new MockOrganization(this, login);
        this.organizations.put(login, result);
        return result;
    }

    public List<MockOwner<?>> owners() {
        ArrayList result = new ArrayList(this.organizations.size() + this.users.size());
        result.addAll(this.users.values());
        result.addAll(this.organizations.values());
        return result;
    }

    public HttpResponse doRepositories(final @QueryParameter long since) {
        return new HttpResponse(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                ArrayList<MockRepository> repositories = new ArrayList<MockRepository>();
                for (MockOwner<?> o : MockGitHub.this.owners()) {
                    for (MockRepository r : o.repositories().values()) {
                        if (r.getId() <= since || r.isPrivate()) continue;
                        repositories.add(r);
                    }
                }
                Collections.sort(repositories, new Comparator<MockRepository>(){

                    @Override
                    public int compare(MockRepository o1, MockRepository o2) {
                        return Long.compare(o1.getId(), o2.getId());
                    }
                });
                if (repositories.size() > 30) {
                    rsp.addHeader("Link", String.format("<%s/repositories?since=%d>; rel=\"next\", <%s/repositories{?since}>; rel=\"first\"", MockGitHub.this.getUrl(), ((MockRepository)repositories.get(30)).getId(), MockGitHub.this.getUrl()));
                } else {
                    rsp.addHeader("Link", String.format("<%s/repositories{?since}>; rel=\"first\"", MockGitHub.this.getUrl()));
                }
                rsp.setContentType("application/json; charset=utf-8");
                JsonGenerator o = MockGitHub.this.factory.createGenerator((OutputStream)rsp.getOutputStream());
                o.writeStartArray();
                try {
                    for (MockRepository r : repositories.subList(0, Math.min(30, repositories.size()))) {
                        o.writeStartObject();
                        o.writeObjectField("id", (Object)r.getId());
                        o.writeObjectField("name", (Object)r.getName());
                        o.writeObjectField("full_name", (Object)(r.owner().getLogin() + "/" + r.getName()));
                        o.writeFieldName("owner");
                        o.writeStartObject();
                        o.writeObjectField("login", (Object)r.owner().getLogin());
                        o.writeObjectField("id", (Object)r.owner().getId());
                        o.writeObjectField("avatar_url", (Object)r.owner().getAvatarUrl());
                        o.writeObjectField("type", (Object)r.owner().getType());
                        o.writeEndObject();
                        o.writeObjectField("private", (Object)r.isPrivate());
                        o.writeObjectField("html_url", (Object)("https://github.com/" + r.owner().getLogin() + "/" + r.getName()));
                        o.writeEndObject();
                    }
                }
                finally {
                    o.writeEndArray();
                    o.close();
                }
            }
        };
    }
}

