/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.badge.actions;

import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.jenkins.ui.icon.IconSpec;
import org.jenkinsci.plugins.badge.ImageResolver;
import org.jenkinsci.plugins.badge.Messages;
import org.jenkinsci.plugins.badge.PluginImpl;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.WebMethod;

public class RunBadgeAction
implements Action,
IconSpec {
    public final Run<?, ?> run;
    public final Job<?, ?> project;

    public RunBadgeAction(Run<?, ?> run) {
        this.run = run;
        this.project = run.getParent();
    }

    public String getIconFileName() {
        return null;
    }

    public String getIconClassName() {
        return "symbol-shield-outline plugin-ionicons-api";
    }

    public String getDisplayName() {
        return Messages.RunBadgeAction_DisplayName();
    }

    public String getUrlName() {
        return "badge";
    }

    public String getUrl() {
        int badgeIndex;
        String url = "";
        StaplerRequest2 req = Stapler.getCurrentRequest2();
        if (req != null && req.getRequestURL() != null && (badgeIndex = (url = req.getRequestURL().toString()).lastIndexOf("badge/")) != -1) {
            url = url.substring(0, badgeIndex);
        }
        return url;
    }

    public String getUrlEncodedFullName() {
        if (this.project == null) {
            return "null-project-no-url-encoded-fullName";
        }
        if (this.project.getFullName() == null) {
            return "null-project-fullName-no-url-encoded-fullName";
        }
        String fullName = URLEncoder.encode(this.project.getFullName(), StandardCharsets.UTF_8);
        return fullName == null ? "null-url-encoded-fullName" : fullName;
    }

    @WebMethod(name={"icon"})
    public HttpResponse doIcon(@QueryParameter String style, @QueryParameter String subject, @QueryParameter String status, @QueryParameter String color, @QueryParameter String animatedOverlayColor, @QueryParameter String config, @QueryParameter String link) {
        return PluginImpl.iconRequestHandler.handleIconRequestForRun(this.run, style, subject, status, color, animatedOverlayColor, config, link);
    }

    @WebMethod(name={"icon.svg"})
    public HttpResponse doIconDotSvg(@QueryParameter String style, @QueryParameter String subject, @QueryParameter String status, @QueryParameter String color, @QueryParameter String animatedOverlayColor, @QueryParameter String config, @QueryParameter String link) {
        return this.doIcon(style, subject, status, color, animatedOverlayColor, config, link);
    }

    public String doText() {
        return this.run.getIconColor().getDescription();
    }

    @Restricted(value={NoExternalUse.class})
    public String getStatus() {
        return ImageResolver.getStatus(this.run.getIconColor());
    }

    @Restricted(value={NoExternalUse.class})
    public String getColorVariable() {
        String colorName = this.run.getIconColor().getIconName();
        if (colorName.contains("-anime")) {
            return "light-blue";
        }
        switch (colorName) {
            case "blue": {
                return "light-green";
            }
            case "aborted": 
            case "disabled": 
            case "notbuilt": {
                return "text-color-secondary";
            }
        }
        return "light-" + colorName;
    }
}

