/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.durabletask;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.durabletask.AgentInfo;
import org.jenkinsci.plugins.durabletask.DurableTaskDescriptor;
import org.jenkinsci.plugins.durabletask.FileMonitoringTask;
import org.jenkinsci.plugins.durabletask.Messages;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public final class PowershellScript
extends FileMonitoringTask {
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean USE_BINARY_WRAPPER = Boolean.getBoolean(PowershellScript.class.getName() + ".USE_BINARY_WRAPPER");
    private final String script;
    private String powershellBinary = "powershell";
    private boolean usesBom = true;
    private boolean loadProfile;
    private boolean capturingOutput;
    private static final Logger LOGGER = Logger.getLogger(PowershellScript.class.getName());
    private static final String LAUNCH_DIAGNOSTICS_PROP = PowershellScript.class.getName() + ".LAUNCH_DIAGNOSTICS";
    private static boolean LAUNCH_DIAGNOSTICS = Boolean.getBoolean(LAUNCH_DIAGNOSTICS_PROP);

    @DataBoundConstructor
    public PowershellScript(String script) {
        this.script = script;
    }

    public String getPowershellBinary() {
        return this.powershellBinary;
    }

    @DataBoundSetter
    public void setPowershellBinary(String powershellBinary) {
        this.powershellBinary = powershellBinary;
    }

    public boolean isLoadProfile() {
        return this.loadProfile;
    }

    @DataBoundSetter
    public void setLoadProfile(boolean loadProfile) {
        this.loadProfile = loadProfile;
    }

    public String getScript() {
        return this.script;
    }

    @Override
    public void captureOutput() {
        this.capturingOutput = true;
    }

    @Override
    protected FileMonitoringTask.FileMonitoringController doLaunch(FilePath ws, Launcher launcher, TaskListener listener, EnvVars envVars) throws IOException, InterruptedException {
        FilePath binary;
        FilePath nodeRoot = PowershellScript.getNodeRoot(ws);
        AgentInfo agentInfo = PowershellScript.getAgentInfo(nodeRoot);
        PowershellController c = new PowershellController(ws, (String)envVars.get((Object)"JENKINS_SERVER_COOKIE"));
        ArrayList<String> powershellArgs = new ArrayList<String>();
        if (!this.loadProfile) {
            powershellArgs.add("-NoProfile");
        }
        powershellArgs.add("-NonInteractive");
        if (!launcher.isUnix()) {
            powershellArgs.addAll(Arrays.asList("-ExecutionPolicy", "Bypass"));
        }
        if (launcher.isUnix() || "pwsh".equals(this.powershellBinary)) {
            this.usesBom = false;
        }
        List<String> launcherCmd = null;
        boolean pwshLinux = agentInfo.getOs() == AgentInfo.OsType.LINUX && "pwsh".equals(this.powershellBinary);
        if (USE_BINARY_WRAPPER && !pwshLinux && (binary = PowershellScript.requestBinary(nodeRoot, agentInfo, ws, c)) != null) {
            launcherCmd = this.binaryLauncherCmd(c, ws, binary.getRemote(), c.getPowerShellScriptFile(ws).getRemote(), powershellArgs);
            if (!this.usesBom) {
                c.getPowerShellScriptFile(ws).write(this.script, "UTF-8");
            } else {
                PowershellScript.writeWithBom(c.getPowerShellScriptFile(ws), this.script);
            }
        }
        if (launcherCmd == null) {
            launcherCmd = this.scriptLauncherCmd(c, ws, powershellArgs);
            String scriptWrapper = PowershellScript.generateScriptWrapper(this.powershellBinary, powershellArgs, c.getPowerShellScriptFile(ws));
            String scriptWithExit = this.script + "\r\nexit $LASTEXITCODE";
            c.getPowerShellHelperFile(ws).copyFrom(((Object)((Object)this)).getClass().getResource("powershellHelper.ps1"));
            if (!this.usesBom) {
                c.getPowerShellScriptFile(ws).write(scriptWithExit, "UTF-8");
                if (!this.capturingOutput) {
                    c.getPowerShellWrapperFile(ws).write(scriptWrapper, "UTF-8");
                }
            } else {
                PowershellScript.writeWithBom(c.getPowerShellScriptFile(ws), scriptWithExit);
                if (!this.capturingOutput) {
                    PowershellScript.writeWithBom(c.getPowerShellWrapperFile(ws), scriptWrapper);
                }
            }
        }
        LOGGER.log(Level.FINE, "launching {0}", launcherCmd);
        Launcher.ProcStarter ps = launcher.launch().cmds(launcherCmd).envs(PowershellScript.escape(envVars)).pwd(ws).quiet(true);
        ps.readStdout().readStderr();
        Proc p = ps.start();
        c.registerForCleanup(p.getStdout());
        c.registerForCleanup(p.getStderr());
        return c;
    }

    @NonNull
    private List<String> binaryLauncherCmd(PowershellController c, FilePath ws, String binaryPath, String scriptPath, List<String> powershellArgs) throws IOException, InterruptedException {
        String logFile = c.getLogFile(ws).getRemote();
        String resultFile = c.getResultFile(ws).getRemote();
        String outputFile = c.getOutputFile(ws).getRemote();
        String controlDirPath = c.controlDir(ws).getRemote();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(binaryPath);
        cmd.add("-daemon");
        cmd.add(String.format("-executable=%s", this.powershellBinary));
        cmd.add(String.format("-args=%s, -Command, %s", String.join((CharSequence)", ", powershellArgs), PowershellScript.generateCommandWrapper(scriptPath, this.capturingOutput, outputFile, this.usesBom, c.getTemporaryOutputFile(ws).getRemote())));
        cmd.add("-controldir=" + controlDirPath);
        cmd.add("-result=" + resultFile);
        cmd.add("-log=" + logFile);
        if (LAUNCH_DIAGNOSTICS) {
            cmd.add("-debug");
        }
        return cmd;
    }

    private List<String> scriptLauncherCmd(PowershellController c, FilePath ws, List<String> powershellArgs) throws IOException, InterruptedException {
        ArrayList<String> args = new ArrayList<String>();
        String cmd = this.capturingOutput ? String.format(". '%s'; Execute-AndWriteOutput -MainScript '%s' -OutputFile '%s' -LogFile '%s' -ResultFile '%s' -CaptureOutput;", PowershellScript.quote(c.getPowerShellHelperFile(ws)), PowershellScript.quote(c.getPowerShellScriptFile(ws)), PowershellScript.quote(c.getOutputFile(ws)), PowershellScript.quote(c.getLogFile(ws)), PowershellScript.quote(c.getResultFile(ws))) : String.format(". '%s'; Execute-AndWriteOutput -MainScript '%s' -LogFile '%s' -ResultFile '%s';", PowershellScript.quote(c.getPowerShellHelperFile(ws)), PowershellScript.quote(c.getPowerShellWrapperFile(ws)), PowershellScript.quote(c.getLogFile(ws)), PowershellScript.quote(c.getResultFile(ws)));
        args.add(this.powershellBinary);
        args.addAll(powershellArgs);
        args.addAll(Arrays.asList("-Command", cmd));
        return args;
    }

    @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification=" from master might be \\n")
    private static String generateScriptWrapper(String powershellBinary, List<String> powershellArgs, FilePath powerShellScriptFile) {
        return String.format("[CmdletBinding()]\r\nparam()\r\n& %s %s -Command '& {try {& ''%s''} catch {throw}; exit $LASTEXITCODE}'\r\nexit $LASTEXITCODE", powershellBinary, String.join((CharSequence)" ", powershellArgs), PowershellScript.quote(PowershellScript.quote(powerShellScriptFile)));
    }

    private static String generateCommandWrapper(String scriptPath, boolean capturingOutput, String outputPath, boolean usesBom, String tempPath) {
        String wrapper;
        if (capturingOutput) {
            String output = usesBom ? tempPath : outputPath;
            String finallyString = ";";
            if (usesBom) {
                finallyString = String.format(" finally {$outputWithBom = Get-Content \\\"%s\\\"; [IO.File]::WriteAllLines(\\\"%s\\\",$outputWithBom)};", tempPath, outputPath);
            }
            wrapper = String.format("[Console]::OutputEncoding = [Text.Encoding]::UTF8; [Console]::InputEncoding = [System.Text.Encoding]::UTF8; & {try {& \\\"%s\\\" | Out-File -FilePath \\\"%s\\\"} catch {throw}%sexit $LASTEXITCODE}", scriptPath, output, finallyString);
        } else {
            wrapper = String.format("[Console]::OutputEncoding = [Text.Encoding]::UTF8; [Console]::InputEncoding = [System.Text.Encoding]::UTF8; & {try {& \\\"%s\\\"} catch {throw}; exit $LASTEXITCODE}", scriptPath);
        }
        return wrapper;
    }

    private static String quote(FilePath f) {
        return PowershellScript.quote(f.getRemote());
    }

    private static String quote(String f) {
        return f.replace("'", "''");
    }

    private static void writeWithBom(FilePath f, String contents) throws IOException, InterruptedException {
        OutputStream out = f.write();
        out.write(new byte[]{-17, -69, -65});
        out.write(contents.getBytes(Charset.forName("UTF-8")));
        out.flush();
        out.close();
    }

    private static final class PowershellController
    extends FileMonitoringTask.FileMonitoringController {
        private static final long serialVersionUID = 1L;

        private PowershellController(FilePath ws, @NonNull String cookieValue) throws IOException, InterruptedException {
            super(ws, cookieValue);
        }

        public FilePath getPowerShellScriptFile(FilePath ws) throws IOException, InterruptedException {
            return this.controlDir(ws).child("powershellScript.ps1");
        }

        public FilePath getPowerShellHelperFile(FilePath ws) throws IOException, InterruptedException {
            return this.controlDir(ws).child("powershellHelper.ps1");
        }

        public FilePath getPowerShellWrapperFile(FilePath ws) throws IOException, InterruptedException {
            return this.controlDir(ws).child("powershellWrapper.ps1");
        }

        public FilePath getTemporaryOutputFile(FilePath ws) throws IOException, InterruptedException {
            return this.controlDir(ws).child("temporaryOutput.txt");
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends DurableTaskDescriptor {
        public String getDisplayName() {
            return Messages.PowershellScript_powershell();
        }

        public ListBoxModel doFillPowershellBinary() {
            return new ListBoxModel(new ListBoxModel.Option[]{new ListBoxModel.Option("powershell"), new ListBoxModel.Option("pwsh")});
        }
    }
}

