// CHECKSTYLE:OFF

package org.jenkins.ci.plugins;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code displayName}: {@code Configure Job Column Plugin}.
     * 
     * @return
     *     {@code Configure Job Column Plugin}
     */
    public static String displayName() {
        return holder.format("displayName");
    }

    /**
     * Key {@code displayName}: {@code Configure Job Column Plugin}.
     * 
     * @return
     *     {@code Configure Job Column Plugin}
     */
    public static Localizable _displayName() {
        return new Localizable(holder, "displayName");
    }

    /**
     * Key {@code configureJobColumn_displayName}: {@code Configure}.
     * 
     * @return
     *     {@code Configure}
     */
    public static String configureJobColumn_displayName() {
        return holder.format("configureJobColumn_displayName");
    }

    /**
     * Key {@code configureJobColumn_displayName}: {@code Configure}.
     * 
     * @return
     *     {@code Configure}
     */
    public static Localizable _configureJobColumn_displayName() {
        return new Localizable(holder, "configureJobColumn_displayName");
    }

}
