// CHECKSTYLE:OFF

package org.jenkinsci.plugins.configfiles;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code MavenToolchains.SettingsName}: {@code MyToolchains}.
     * 
     * @return
     *     {@code MyToolchains}
     */
    public static String MavenToolchains_SettingsName() {
        return holder.format("MavenToolchains.SettingsName");
    }

    /**
     * Key {@code MavenToolchains.SettingsName}: {@code MyToolchains}.
     * 
     * @return
     *     {@code MyToolchains}
     */
    public static Localizable _MavenToolchains_SettingsName() {
        return new Localizable(holder, "MavenToolchains.SettingsName");
    }

    /**
     * Key {@code groovy_provider_name}: {@code Groovy file}.
     * 
     * @return
     *     {@code Groovy file}
     */
    public static String groovy_provider_name() {
        return holder.format("groovy_provider_name");
    }

    /**
     * Key {@code groovy_provider_name}: {@code Groovy file}.
     * 
     * @return
     *     {@code Groovy file}
     */
    public static Localizable _groovy_provider_name() {
        return new Localizable(holder, "groovy_provider_name");
    }

    /**
     * Key {@code GroovyScript.SettingsName}: {@code GroovyConfig}.
     * 
     * @return
     *     {@code GroovyConfig}
     */
    public static String GroovyScript_SettingsName() {
        return holder.format("GroovyScript.SettingsName");
    }

    /**
     * Key {@code GroovyScript.SettingsName}: {@code GroovyConfig}.
     * 
     * @return
     *     {@code GroovyConfig}
     */
    public static Localizable _GroovyScript_SettingsName() {
        return new Localizable(holder, "GroovyScript.SettingsName");
    }

    /**
     * Key {@code ConfigFilesManagement.configIdCannotBeEmpty}: {@code
     * Configuration ID cannot be empty.}.
     * 
     * @return
     *     {@code Configuration ID cannot be empty.}
     */
    public static String ConfigFilesManagement_configIdCannotBeEmpty() {
        return holder.format("ConfigFilesManagement.configIdCannotBeEmpty");
    }

    /**
     * Key {@code ConfigFilesManagement.configIdCannotBeEmpty}: {@code
     * Configuration ID cannot be empty.}.
     * 
     * @return
     *     {@code Configuration ID cannot be empty.}
     */
    public static Localizable _ConfigFilesManagement_configIdCannotBeEmpty() {
        return new Localizable(holder, "ConfigFilesManagement.configIdCannotBeEmpty");
    }

    /**
     * Key {@code MavenServerIdSpecification_displayname}: {@code Maven
     * 'serverId'}.
     * 
     * @return
     *     {@code Maven 'serverId'}
     */
    public static String MavenServerIdSpecification_displayname() {
        return holder.format("MavenServerIdSpecification_displayname");
    }

    /**
     * Key {@code MavenServerIdSpecification_displayname}: {@code Maven
     * 'serverId'}.
     * 
     * @return
     *     {@code Maven 'serverId'}
     */
    public static Localizable _MavenServerIdSpecification_displayname() {
        return new Localizable(holder, "MavenServerIdSpecification_displayname");
    }

    /**
     * Key {@code PropertiesConfig.SettingsName}: {@code MyPropertiesConfig}.
     * 
     * @return
     *     {@code MyPropertiesConfig}
     */
    public static String PropertiesConfig_SettingsName() {
        return holder.format("PropertiesConfig.SettingsName");
    }

    /**
     * Key {@code PropertiesConfig.SettingsName}: {@code MyPropertiesConfig}.
     * 
     * @return
     *     {@code MyPropertiesConfig}
     */
    public static Localizable _PropertiesConfig_SettingsName() {
        return new Localizable(holder, "PropertiesConfig.SettingsName");
    }

    /**
     * Key {@code XmlConfig.SettingsComment}: {@code }.
     * 
     * @return
     *     {@code }
     */
    public static String XmlConfig_SettingsComment() {
        return holder.format("XmlConfig.SettingsComment");
    }

    /**
     * Key {@code XmlConfig.SettingsComment}: {@code }.
     * 
     * @return
     *     {@code }
     */
    public static Localizable _XmlConfig_SettingsComment() {
        return new Localizable(holder, "XmlConfig.SettingsComment");
    }

    /**
     * Key {@code JsonConfig.SettingsComment}: {@code }.
     * 
     * @return
     *     {@code }
     */
    public static String JsonConfig_SettingsComment() {
        return holder.format("JsonConfig.SettingsComment");
    }

    /**
     * Key {@code JsonConfig.SettingsComment}: {@code }.
     * 
     * @return
     *     {@code }
     */
    public static Localizable _JsonConfig_SettingsComment() {
        return new Localizable(holder, "JsonConfig.SettingsComment");
    }

    /**
     * Key {@code description}: {@code e.g. settings.xml for maven, central
     * managed scripts, custom files, ...}.
     * 
     * @return
     *     {@code e.g. settings.xml for maven, central managed scripts, custom
     *     files, ...}
     */
    public static String description() {
        return holder.format("description");
    }

    /**
     * Key {@code description}: {@code e.g. settings.xml for maven, central
     * managed scripts, custom files, ...}.
     * 
     * @return
     *     {@code e.g. settings.xml for maven, central managed scripts, custom
     *     files, ...}
     */
    public static Localizable _description() {
        return new Localizable(holder, "description");
    }

    /**
     * Key {@code ConfigFilesManagement.selectTypeOfFileToCreate}: {@code
     * Select the type of file to create.}.
     * 
     * @return
     *     {@code Select the type of file to create.}
     */
    public static String ConfigFilesManagement_selectTypeOfFileToCreate() {
        return holder.format("ConfigFilesManagement.selectTypeOfFileToCreate");
    }

    /**
     * Key {@code ConfigFilesManagement.selectTypeOfFileToCreate}: {@code
     * Select the type of file to create.}.
     * 
     * @return
     *     {@code Select the type of file to create.}
     */
    public static Localizable _ConfigFilesManagement_selectTypeOfFileToCreate() {
        return new Localizable(holder, "ConfigFilesManagement.selectTypeOfFileToCreate");
    }

    /**
     * Key {@code GroovyScript.SettingsComment}: {@code }.
     * 
     * @return
     *     {@code }
     */
    public static String GroovyScript_SettingsComment() {
        return holder.format("GroovyScript.SettingsComment");
    }

    /**
     * Key {@code GroovyScript.SettingsComment}: {@code }.
     * 
     * @return
     *     {@code }
     */
    public static Localizable _GroovyScript_SettingsComment() {
        return new Localizable(holder, "GroovyScript.SettingsComment");
    }

    /**
     * Key {@code JsonConfig.SettingsName}: {@code JsonConfig}.
     * 
     * @return
     *     {@code JsonConfig}
     */
    public static String JsonConfig_SettingsName() {
        return holder.format("JsonConfig.SettingsName");
    }

    /**
     * Key {@code JsonConfig.SettingsName}: {@code JsonConfig}.
     * 
     * @return
     *     {@code JsonConfig}
     */
    public static Localizable _JsonConfig_SettingsName() {
        return new Localizable(holder, "JsonConfig.SettingsName");
    }

    /**
     * Key {@code MavenSettings.SettingsComment}: {@code User settings}.
     * 
     * @return
     *     {@code User settings}
     */
    public static String MavenSettings_SettingsComment() {
        return holder.format("MavenSettings.SettingsComment");
    }

    /**
     * Key {@code MavenSettings.SettingsComment}: {@code User settings}.
     * 
     * @return
     *     {@code User settings}
     */
    public static Localizable _MavenSettings_SettingsComment() {
        return new Localizable(holder, "MavenSettings.SettingsComment");
    }

    /**
     * Key {@code json_provider_name}: {@code Json file}.
     * 
     * @return
     *     {@code Json file}
     */
    public static String json_provider_name() {
        return holder.format("json_provider_name");
    }

    /**
     * Key {@code json_provider_name}: {@code Json file}.
     * 
     * @return
     *     {@code Json file}
     */
    public static Localizable _json_provider_name() {
        return new Localizable(holder, "json_provider_name");
    }

    /**
     * Key {@code XmlConfig.SettingsName}: {@code XmlConfig}.
     * 
     * @return
     *     {@code XmlConfig}
     */
    public static String XmlConfig_SettingsName() {
        return holder.format("XmlConfig.SettingsName");
    }

    /**
     * Key {@code XmlConfig.SettingsName}: {@code XmlConfig}.
     * 
     * @return
     *     {@code XmlConfig}
     */
    public static Localizable _XmlConfig_SettingsName() {
        return new Localizable(holder, "XmlConfig.SettingsName");
    }

    /**
     * Key {@code CustomConfig.SettingsName}: {@code MyCustom}.
     * 
     * @return
     *     {@code MyCustom}
     */
    public static String CustomConfig_SettingsName() {
        return holder.format("CustomConfig.SettingsName");
    }

    /**
     * Key {@code CustomConfig.SettingsName}: {@code MyCustom}.
     * 
     * @return
     *     {@code MyCustom}
     */
    public static Localizable _CustomConfig_SettingsName() {
        return new Localizable(holder, "CustomConfig.SettingsName");
    }

    /**
     * Key {@code MvnServerPassword_displayname}: {@code Maven Settings
     * Server with password}.
     * 
     * @return
     *     {@code Maven Settings Server with password}
     */
    public static String MvnServerPassword_displayname() {
        return holder.format("MvnServerPassword_displayname");
    }

    /**
     * Key {@code MvnServerPassword_displayname}: {@code Maven Settings
     * Server with password}.
     * 
     * @return
     *     {@code Maven Settings Server with password}
     */
    public static Localizable _MvnServerPassword_displayname() {
        return new Localizable(holder, "MvnServerPassword_displayname");
    }

    /**
     * Key {@code MavenSettingsConfig.UserSettings}: {@code User settings}.
     * 
     * @return
     *     {@code User settings}
     */
    public static String MavenSettingsConfig_UserSettings() {
        return holder.format("MavenSettingsConfig.UserSettings");
    }

    /**
     * Key {@code MavenSettingsConfig.UserSettings}: {@code User settings}.
     * 
     * @return
     *     {@code User settings}
     */
    public static Localizable _MavenSettingsConfig_UserSettings() {
        return new Localizable(holder, "MavenSettingsConfig.UserSettings");
    }

    /**
     * Key {@code buildstep_provider_name}: {@code Build Step script file }.
     * 
     * @return
     *     {@code Build Step script file }
     */
    public static String buildstep_provider_name() {
        return holder.format("buildstep_provider_name");
    }

    /**
     * Key {@code buildstep_provider_name}: {@code Build Step script file }.
     * 
     * @return
     *     {@code Build Step script file }
     */
    public static Localizable _buildstep_provider_name() {
        return new Localizable(holder, "buildstep_provider_name");
    }

    /**
     * Key {@code groovy_provider_description}: {@code a reusable groovy
     * script}.
     * 
     * @return
     *     {@code a reusable groovy script}
     */
    public static String groovy_provider_description() {
        return holder.format("groovy_provider_description");
    }

    /**
     * Key {@code groovy_provider_description}: {@code a reusable groovy
     * script}.
     * 
     * @return
     *     {@code a reusable groovy script}
     */
    public static Localizable _groovy_provider_description() {
        return new Localizable(holder, "groovy_provider_description");
    }

    /**
     * Key {@code mvn_global_settings_provider_name}: {@code Global Maven
     * settings.xml}.
     * 
     * @return
     *     {@code Global Maven settings.xml}
     */
    public static String mvn_global_settings_provider_name() {
        return holder.format("mvn_global_settings_provider_name");
    }

    /**
     * Key {@code mvn_global_settings_provider_name}: {@code Global Maven
     * settings.xml}.
     * 
     * @return
     *     {@code Global Maven settings.xml}
     */
    public static Localizable _mvn_global_settings_provider_name() {
        return new Localizable(holder, "mvn_global_settings_provider_name");
    }

    /**
     * Key {@code mvn_toolchains_provider_name}: {@code Maven
     * toolchains.xml}.
     * 
     * @return
     *     {@code Maven toolchains.xml}
     */
    public static String mvn_toolchains_provider_name() {
        return holder.format("mvn_toolchains_provider_name");
    }

    /**
     * Key {@code mvn_toolchains_provider_name}: {@code Maven
     * toolchains.xml}.
     * 
     * @return
     *     {@code Maven toolchains.xml}
     */
    public static Localizable _mvn_toolchains_provider_name() {
        return new Localizable(holder, "mvn_toolchains_provider_name");
    }

    /**
     * Key {@code ConfigFilesManagement.configIdAlreadyUsed}: {@code
     * Configuration file named "{0}" is already defined for the id "{1}".}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Configuration file named "{0}" is already defined for the id
     *     "{1}".}
     */
    public static String ConfigFilesManagement_configIdAlreadyUsed(Object arg0, Object arg1) {
        return holder.format("ConfigFilesManagement.configIdAlreadyUsed", arg0, arg1);
    }

    /**
     * Key {@code ConfigFilesManagement.configIdAlreadyUsed}: {@code
     * Configuration file named "{0}" is already defined for the id "{1}".}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Configuration file named "{0}" is already defined for the id
     *     "{1}".}
     */
    public static Localizable _ConfigFilesManagement_configIdAlreadyUsed(Object arg0, Object arg1) {
        return new Localizable(holder, "ConfigFilesManagement.configIdAlreadyUsed", arg0, arg1);
    }

    /**
     * Key {@code display_name}: {@code Managed files}.
     * 
     * @return
     *     {@code Managed files}
     */
    public static String display_name() {
        return holder.format("display_name");
    }

    /**
     * Key {@code display_name}: {@code Managed files}.
     * 
     * @return
     *     {@code Managed files}
     */
    public static Localizable _display_name() {
        return new Localizable(holder, "display_name");
    }

    /**
     * Key {@code mvn_settings_provider_name}: {@code Maven settings.xml}.
     * 
     * @return
     *     {@code Maven settings.xml}
     */
    public static String mvn_settings_provider_name() {
        return holder.format("mvn_settings_provider_name");
    }

    /**
     * Key {@code mvn_settings_provider_name}: {@code Maven settings.xml}.
     * 
     * @return
     *     {@code Maven settings.xml}
     */
    public static Localizable _mvn_settings_provider_name() {
        return new Localizable(holder, "mvn_settings_provider_name");
    }

    /**
     * Key {@code ConfigFilesManagement.configIdContainsInvalidCharacters}:
     * {@code Configuration ID contains invalid characters, only Alphanumeric
     * characters, "_", "." and "-" are allowed.}.
     * 
     * @return
     *     {@code Configuration ID contains invalid characters, only Alphanumeric
     *     characters, "_", "." and "-" are allowed.}
     */
    public static String ConfigFilesManagement_configIdContainsInvalidCharacters() {
        return holder.format("ConfigFilesManagement.configIdContainsInvalidCharacters");
    }

    /**
     * Key {@code ConfigFilesManagement.configIdContainsInvalidCharacters}:
     * {@code Configuration ID contains invalid characters, only Alphanumeric
     * characters, "_", "." and "-" are allowed.}.
     * 
     * @return
     *     {@code Configuration ID contains invalid characters, only Alphanumeric
     *     characters, "_", "." and "-" are allowed.}
     */
    public static Localizable _ConfigFilesManagement_configIdContainsInvalidCharacters() {
        return new Localizable(holder, "ConfigFilesManagement.configIdContainsInvalidCharacters");
    }

    /**
     * Key {@code xml_provider_name}: {@code Simple XML file}.
     * 
     * @return
     *     {@code Simple XML file}
     */
    public static String xml_provider_name() {
        return holder.format("xml_provider_name");
    }

    /**
     * Key {@code xml_provider_name}: {@code Simple XML file}.
     * 
     * @return
     *     {@code Simple XML file}
     */
    public static Localizable _xml_provider_name() {
        return new Localizable(holder, "xml_provider_name");
    }

    /**
     * Key {@code MavenSettings.SettingsName}: {@code MySettings}.
     * 
     * @return
     *     {@code MySettings}
     */
    public static String MavenSettings_SettingsName() {
        return holder.format("MavenSettings.SettingsName");
    }

    /**
     * Key {@code MavenSettings.SettingsName}: {@code MySettings}.
     * 
     * @return
     *     {@code MySettings}
     */
    public static Localizable _MavenSettings_SettingsName() {
        return new Localizable(holder, "MavenSettings.SettingsName");
    }

    /**
     * Key {@code GlobalMavenSettingsConfig.MyGlobalSettingsComment}: {@code
     * Global settings}.
     * 
     * @return
     *     {@code Global settings}
     */
    public static String GlobalMavenSettingsConfig_MyGlobalSettingsComment() {
        return holder.format("GlobalMavenSettingsConfig.MyGlobalSettingsComment");
    }

    /**
     * Key {@code GlobalMavenSettingsConfig.MyGlobalSettingsComment}: {@code
     * Global settings}.
     * 
     * @return
     *     {@code Global settings}
     */
    public static Localizable _GlobalMavenSettingsConfig_MyGlobalSettingsComment() {
        return new Localizable(holder, "GlobalMavenSettingsConfig.MyGlobalSettingsComment");
    }

    /**
     * Key {@code MavenToolchains.SettingsComment}: {@code }.
     * 
     * @return
     *     {@code }
     */
    public static String MavenToolchains_SettingsComment() {
        return holder.format("MavenToolchains.SettingsComment");
    }

    /**
     * Key {@code MavenToolchains.SettingsComment}: {@code }.
     * 
     * @return
     *     {@code }
     */
    public static Localizable _MavenToolchains_SettingsComment() {
        return new Localizable(holder, "MavenToolchains.SettingsComment");
    }

    /**
     * Key {@code properties_provider_description}: {@code Properties file}.
     * 
     * @return
     *     {@code Properties file}
     */
    public static String properties_provider_description() {
        return holder.format("properties_provider_description");
    }

    /**
     * Key {@code properties_provider_description}: {@code Properties file}.
     * 
     * @return
     *     {@code Properties file}
     */
    public static Localizable _properties_provider_description() {
        return new Localizable(holder, "properties_provider_description");
    }

    /**
     * Key {@code MavenSettingsConfig.MySettings}: {@code MySettings}.
     * 
     * @return
     *     {@code MySettings}
     */
    public static String MavenSettingsConfig_MySettings() {
        return holder.format("MavenSettingsConfig.MySettings");
    }

    /**
     * Key {@code MavenSettingsConfig.MySettings}: {@code MySettings}.
     * 
     * @return
     *     {@code MySettings}
     */
    public static Localizable _MavenSettingsConfig_MySettings() {
        return new Localizable(holder, "MavenSettingsConfig.MySettings");
    }

    /**
     * Key {@code GlobalMavenSettingsConfig.MyGlobalSettingsName}: {@code
     * MyGlobalSettings}.
     * 
     * @return
     *     {@code MyGlobalSettings}
     */
    public static String GlobalMavenSettingsConfig_MyGlobalSettingsName() {
        return holder.format("GlobalMavenSettingsConfig.MyGlobalSettingsName");
    }

    /**
     * Key {@code GlobalMavenSettingsConfig.MyGlobalSettingsName}: {@code
     * MyGlobalSettings}.
     * 
     * @return
     *     {@code MyGlobalSettings}
     */
    public static Localizable _GlobalMavenSettingsConfig_MyGlobalSettingsName() {
        return new Localizable(holder, "GlobalMavenSettingsConfig.MyGlobalSettingsName");
    }

    /**
     * Key {@code PropertiesConfig.SettingsComment}: {@code user properties
     * settings}.
     * 
     * @return
     *     {@code user properties settings}
     */
    public static String PropertiesConfig_SettingsComment() {
        return holder.format("PropertiesConfig.SettingsComment");
    }

    /**
     * Key {@code PropertiesConfig.SettingsComment}: {@code user properties
     * settings}.
     * 
     * @return
     *     {@code user properties settings}
     */
    public static Localizable _PropertiesConfig_SettingsComment() {
        return new Localizable(holder, "PropertiesConfig.SettingsComment");
    }

    /**
     * Key {@code buildstep_provider_description}: {@code create a reusable
     * build step}.
     * 
     * @return
     *     {@code create a reusable build step}
     */
    public static String buildstep_provider_description() {
        return holder.format("buildstep_provider_description");
    }

    /**
     * Key {@code buildstep_provider_description}: {@code create a reusable
     * build step}.
     * 
     * @return
     *     {@code create a reusable build step}
     */
    public static Localizable _buildstep_provider_description() {
        return new Localizable(holder, "buildstep_provider_description");
    }

    /**
     * Key {@code CustomConfig.SettingsComment}: {@code }.
     * 
     * @return
     *     {@code }
     */
    public static String CustomConfig_SettingsComment() {
        return holder.format("CustomConfig.SettingsComment");
    }

    /**
     * Key {@code CustomConfig.SettingsComment}: {@code }.
     * 
     * @return
     *     {@code }
     */
    public static Localizable _CustomConfig_SettingsComment() {
        return new Localizable(holder, "CustomConfig.SettingsComment");
    }

    /**
     * Key {@code custom_provider_name}: {@code Custom file}.
     * 
     * @return
     *     {@code Custom file}
     */
    public static String custom_provider_name() {
        return holder.format("custom_provider_name");
    }

    /**
     * Key {@code custom_provider_name}: {@code Custom file}.
     * 
     * @return
     *     {@code Custom file}
     */
    public static Localizable _custom_provider_name() {
        return new Localizable(holder, "custom_provider_name");
    }

}
