/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clover.results;

import hudson.model.Run;
import hudson.plugins.clover.CloverBuildAction;
import hudson.plugins.clover.results.AbstractCloverMetrics;
import hudson.plugins.clover.results.AbstractFileAggregatedMetrics;
import hudson.plugins.clover.results.ClassCoverage;
import hudson.plugins.clover.results.FileCoverage;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public class PackageCoverage
extends AbstractFileAggregatedMetrics {
    private final List<FileCoverage> fileCoverages = new ArrayList<FileCoverage>();

    public List<FileCoverage> getChildren() {
        return this.getFileCoverages();
    }

    public boolean addFileCoverage(FileCoverage result) {
        return this.fileCoverages.add(result);
    }

    public List<FileCoverage> getFileCoverages() {
        return this.fileCoverages;
    }

    @Override
    public FileCoverage findFileCoverage(String name) {
        for (FileCoverage i : this.fileCoverages) {
            if (!name.equals(i.getName())) continue;
            return i;
        }
        return null;
    }

    @Override
    public ClassCoverage findClassCoverage(String name) {
        for (FileCoverage i : this.fileCoverages) {
            ClassCoverage j = i.findClassCoverage(name);
            if (j == null) continue;
            return j;
        }
        return null;
    }

    public Object getDynamic(String token, StaplerRequest2 req, StaplerResponse2 rsp) {
        boolean isPath = false;
        for (FileCoverage i : this.fileCoverages) {
            if (i.getName().equals(token)) {
                return i;
            }
            if (!i.getName().startsWith(token)) continue;
            isPath = true;
            break;
        }
        if (isPath) {
            return new FilePathMapper(token + "/");
        }
        return null;
    }

    @Override
    public AbstractCloverMetrics getPreviousResult() {
        CloverBuildAction action = this.getPreviousCloverBuildAction();
        if (action == null) {
            return null;
        }
        return action.findPackageCoverage(this.getName());
    }

    @Override
    public void setOwner(Run<?, ?> owner) {
        super.setOwner(owner);
        for (FileCoverage fileCoverage : this.fileCoverages) {
            fileCoverage.setOwner(owner);
        }
    }

    public class FilePathMapper {
        private final String pathSoFar;

        public FilePathMapper(String pathSoFar) {
            this.pathSoFar = pathSoFar;
        }

        public Object getDynamic(String token, StaplerRequest2 req, StaplerResponse2 rsp) {
            String testPath = this.pathSoFar + token;
            boolean isPath = false;
            for (FileCoverage i : PackageCoverage.this.fileCoverages) {
                if (i.getName().equals(testPath)) {
                    return i;
                }
                if (!i.getName().startsWith(testPath)) continue;
                isPath = true;
                break;
            }
            if (isPath) {
                return new FilePathMapper(testPath + "/");
            }
            return null;
        }
    }
}

