/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clover;

import com.atlassian.clover.api.ci.CIOptions;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.FreeStyleProject;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.clover.CloverInstallation;
import hudson.plugins.clover.CloverProjectAction;
import hudson.plugins.clover.CloverPublisher;
import hudson.plugins.clover.Messages;
import hudson.remoting.Channel;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;
import org.openclover.ci.AntIntegrationListener;
import org.openclover.util.ClassPathUtil;

public class CloverBuildWrapper
extends BuildWrapper {
    public boolean historical = true;
    public boolean json = true;
    public final String clover;
    public final boolean putValuesInQuotes;

    @DataBoundConstructor
    public CloverBuildWrapper(boolean historical, boolean json, String clover, boolean putValuesInQuotes) {
        this.historical = historical;
        this.json = json;
        this.clover = clover;
        this.putValuesInQuotes = putValuesInQuotes;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) {
        this.addCloverPublisher(build, listener);
        return new BuildWrapper.Environment(){};
    }

    private void addCloverPublisher(AbstractBuild build, BuildListener listener) {
        String DEFAULT_REPORT_DIR = "clover";
        DescribableList publishers = build.getProject().getPublishersList();
        boolean isAlreadyDefined = false;
        for (Publisher publisher : publishers) {
            if (!(publisher instanceof CloverPublisher)) continue;
            isAlreadyDefined = true;
            break;
        }
        if (!isAlreadyDefined) {
            listener.getLogger().println("Adding Clover Publisher with reportDir: clover");
            build.getProject().getPublishersList().add((Object)new CloverPublisher("clover", null));
        }
    }

    public Collection<? extends Action> getProjectActions(AbstractProject job) {
        if (job.getAction(CloverProjectAction.class) == null) {
            return Collections.singletonList(new CloverProjectAction((Job<?, ?>)job));
        }
        return super.getProjectActions(job);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="")
    private CloverInstallation getInstallationForBuild(@NonNull AbstractBuild build, @NonNull Launcher launcher) throws IOException, InterruptedException {
        CloverInstallation installation = CloverInstallation.forName(this.clover);
        return installation == null ? null : installation.forNode(build.getBuiltOn(), launcher.getListener());
    }

    public Launcher decorateLauncher(@NonNull AbstractBuild build, @NonNull Launcher launcher, @NonNull BuildListener listener) throws IOException, InterruptedException, Run.RunnerAbortedException {
        CIOptions.Builder options = new CIOptions.Builder().json(this.json).historical(this.historical).fullClean(true).putValuesInQuotes(this.putValuesInQuotes);
        return new CloverDecoratingLauncher(this, this.getInstallationForBuild(build, launcher), launcher, options);
    }

    public static class CloverDecoratingLauncher
    extends Launcher {
        private final Launcher outer;
        private final CloverBuildWrapper wrapper;
        private final CloverInstallation clover;
        static final Function<String, String> trimDoubleQuotes = new Function<String, String>(){

            public String apply(@Nullable String s) {
                return StringUtils.removeStart((String)StringUtils.removeEnd((String)s, (String)"\""), (String)"\"");
            }
        };

        public CloverDecoratingLauncher(CloverBuildWrapper cloverBuildWrapper, CloverInstallation clover, Launcher outer, CIOptions.Builder options) {
            super(outer);
            this.wrapper = cloverBuildWrapper;
            this.clover = clover;
            this.outer = outer;
        }

        public boolean isUnix() {
            return this.outer.isUnix();
        }

        public Proc launch(Launcher.ProcStarter starter) throws IOException {
            this.decorateArgs(starter);
            return this.outer.launch(starter);
        }

        public void decorateArgs(Launcher.ProcStarter starter) throws IOException {
            LinkedList<String> userArgs = new LinkedList<String>();
            LinkedList<String> preSystemArgs = new LinkedList<String>();
            LinkedList<String> postSystemArgs = new LinkedList<String>();
            List<String> cmds = new ArrayList<String>(starter.cmds());
            if (CloverDecoratingLauncher.isCmdExe(cmds)) {
                int numPreSystemCmds = 2;
                preSystemArgs.addAll(cmds.subList(0, 2));
                cmds = cmds.subList(2, cmds.size());
            }
            if (cmds.size() == 1 && ((String)cmds.get(0)).startsWith("\"")) {
                cmds = Arrays.asList(cmds.get(0).split(" "));
            }
            if (CloverDecoratingLauncher.isAntBat(cmds)) {
                cmds = Lists.transform(cmds, trimDoubleQuotes);
                CloverDecoratingLauncher.splitArgumentsIntoPreUserPost(cmds, preSystemArgs, userArgs, postSystemArgs, true);
            } else if (CloverDecoratingLauncher.isAnt(cmds)) {
                CloverDecoratingLauncher.splitArgumentsIntoPreUserPost(cmds, preSystemArgs, userArgs, postSystemArgs, false);
            } else {
                this.listener.getLogger().printf("Clover did not found Ant command in '%s' - not integrating.%n", StringUtils.join(cmds, (String)" "));
            }
            if (!userArgs.isEmpty()) {
                this.addReportSkipping(userArgs);
                this.addAntIntegrationListener(userArgs);
                if (this.clover != null) {
                    this.addLibCloverFromHome(userArgs);
                } else {
                    this.addLibCloverFromBundledJar(userArgs, starter, this.listener);
                }
                ArrayList<String> allCommands = new ArrayList<String>();
                allCommands.addAll(preSystemArgs);
                allCommands.addAll(userArgs);
                allCommands.addAll(postSystemArgs);
                starter.cmds(allCommands);
                boolean[] masks = new boolean[starter.cmds().size()];
                boolean[] starterMasks = starter.masks();
                if (starterMasks != null) {
                    System.arraycopy(starterMasks, 0, masks, 0, starterMasks.length);
                }
                starter.masks(masks);
            }
        }

        static boolean isCmdExe(List<String> args) {
            return args.size() >= 2 && args.get(0).endsWith("cmd.exe") && args.get(1).equals("/C");
        }

        static boolean isAntBat(List<String> cmds) {
            return cmds.size() > 1 && cmds.get(0).endsWith("ant.bat");
        }

        static boolean isAnt(List<String> cmds) {
            return cmds.size() > 1 && cmds.get(0).endsWith("ant");
        }

        static void splitArgumentsIntoPreUserPost(List<String> cmds, List<String> preSystemArgs, List<String> userArgs, List<String> postSystemArgs, boolean lookForPostSystemArgs) {
            ParseState state = ParseState.PRE;
            for (String arg : cmds) {
                switch (state.ordinal()) {
                    case 0: {
                        preSystemArgs.add(arg);
                        state = ParseState.USER;
                        break;
                    }
                    case 1: {
                        if (lookForPostSystemArgs && "&&".equals(arg)) {
                            state = ParseState.POST;
                            postSystemArgs.add(arg);
                            break;
                        }
                        userArgs.add(arg);
                        break;
                    }
                    case 2: {
                        postSystemArgs.add(arg);
                    }
                }
            }
        }

        private void addReportSkipping(List<String> userArgs) {
            if (!this.wrapper.json) {
                userArgs.add("-Dclover.skip.json=true");
            }
            if (!this.wrapper.historical) {
                userArgs.add("-Dclover.skip.report=true");
            } else {
                userArgs.add("-Dclover.skip.current=true");
            }
        }

        private void addAntIntegrationListener(List<String> userArgs) {
            userArgs.add("-listener");
            userArgs.add(AntIntegrationListener.class.getName());
        }

        private void addLibCloverFromHome(List<String> userArgs) {
            userArgs.add("-lib");
            userArgs.add("\"" + this.clover.getHome() + "\"");
        }

        private void addLibCloverFromBundledJar(List<String> userArgs, @NonNull Launcher.ProcStarter starter, TaskListener listener) throws IOException {
            FilePath starterPwd = starter.pwd();
            if (starterPwd == null) {
                listener.getLogger().print("Could not get clover jar path from " + String.valueOf(starter));
                return;
            }
            FilePath path = new FilePath(new FilePath(starterPwd, ".clover"), "clover.jar");
            try {
                String cloverJarLocation = ClassPathUtil.getCloverJarPath();
                if (cloverJarLocation == null) {
                    listener.getLogger().print("Could not get clover jar path at: " + String.valueOf(path) + ".  Please supply '-lib /path/to/clover.jar'.");
                    return;
                }
                path.copyFrom(new FilePath(new File(cloverJarLocation)));
                userArgs.add("-lib");
                userArgs.add("\"" + path.getRemote() + "\"");
            }
            catch (InterruptedException e) {
                listener.getLogger().print("Could not create clover library file at: " + String.valueOf(path) + ".  Please supply '-lib /path/to/clover.jar'.");
                listener.getLogger().print(e.getMessage());
            }
        }

        public Channel launchChannel(String[] cmd, OutputStream out, FilePath workDir, Map<String, String> envVars) throws IOException, InterruptedException {
            return this.outer.launchChannel(cmd, out, workDir, envVars);
        }

        public void kill(Map<String, String> modelEnvVars) throws IOException, InterruptedException {
            this.outer.kill(modelEnvVars);
        }

        private String addQuotesIfNecessary(String input) {
            return !this.wrapper.putValuesInQuotes || CloverDecoratingLauncher.isWindows() ? input : "\"" + input + "\"";
        }

        private static boolean isWindows() {
            String osName = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    try {
                        return System.getProperty("os.name");
                    }
                    catch (SecurityException ex) {
                        return null;
                    }
                }
            });
            return osName != null && osName.toLowerCase().indexOf("windows") == 0;
        }

        private static enum ParseState {
            PRE,
            USER,
            POST;

        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public DescriptorImpl() {
            super(CloverBuildWrapper.class);
            this.load();
        }

        public String getDisplayName() {
            return Messages.CloverBuildWrapper_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/clover/help-cloverConfig.html";
        }

        public boolean configure(StaplerRequest2 req, JSONObject json) {
            req.bindParameters((Object)this, "clover.");
            this.save();
            return true;
        }

        public boolean isApplicable(AbstractProject item) {
            return item instanceof FreeStyleProject;
        }
    }
}

