/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.computed;

import com.cloudbees.hudson.plugins.folder.AbstractFolderDescriptor;
import com.cloudbees.hudson.plugins.folder.computed.ChildObserver;
import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import com.cloudbees.hudson.plugins.folder.computed.ComputedFolderTest;
import hudson.model.FreeStyleProject;
import hudson.model.ItemGroup;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.util.StreamTaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.model.Statement;
import org.jvnet.hudson.test.RestartableJenkinsRule;
import org.jvnet.hudson.test.TestExtension;

public class ComputedFolder2Test {
    @Rule
    public RestartableJenkinsRule rr = new RestartableJenkinsRule();

    @Test
    public void eventAfterRestart() {
        this.rr.addStep(new Statement(){

            public void evaluate() throws Throwable {
                EventableFolder d = (EventableFolder)ComputedFolder2Test.this.rr.j.jenkins.createProject(EventableFolder.class, "d");
                d.add("one");
                String log = ComputedFolderTest.doRecompute(d, Result.SUCCESS);
                MatcherAssert.assertThat((String)log, (Object)d.getItems(), (Matcher)Matchers.hasSize((Matcher)Matchers.equalTo((Object)1)));
            }
        });
        this.rr.addStep(new Statement(){

            public void evaluate() throws Throwable {
                EventableFolder d = (EventableFolder)ComputedFolder2Test.this.rr.j.jenkins.getItemByFullName("d", EventableFolder.class);
                Assert.assertNotNull((Object)((Object)d));
                MatcherAssert.assertThat((Object)d.getItems(), (Matcher)Matchers.hasSize((Matcher)Matchers.equalTo((Object)1)));
                d.add("two");
                String log = ComputedFolderTest.doRecompute(d, Result.SUCCESS);
                MatcherAssert.assertThat((String)log, (Object)d.getItems(), (Matcher)Matchers.hasSize((Matcher)Matchers.equalTo((Object)1)));
            }
        });
    }

    public static final class EventableFolder
    extends ComputedFolder<FreeStyleProject> {
        private final List<String> kids = new ArrayList<String>();

        public EventableFolder(ItemGroup parent, String name) {
            super(parent, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void computeChildren(ChildObserver<FreeStyleProject> observer, TaskListener listener) throws InterruptedException {
            for (String kid : this.kids) {
                FreeStyleProject p = (FreeStyleProject)observer.shouldUpdate(kid);
                try {
                    if (p != null || !observer.mayCreate(kid)) continue;
                    listener.getLogger().println("loading " + kid);
                    p = new FreeStyleProject((ItemGroup)this, kid);
                    observer.created((TopLevelItem)p);
                }
                finally {
                    observer.completed(kid);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(String kid) throws IOException, InterruptedException {
            try (StreamTaskListener listener = this.getComputation().createEventsListener();
                 ChildObserver observer = this.openEventsChildObserver();){
                FreeStyleProject p = (FreeStyleProject)observer.shouldUpdate(kid);
                try {
                    if (p == null && observer.mayCreate(kid)) {
                        listener.getLogger().println("adding " + kid);
                        this.kids.add(kid);
                        p = new FreeStyleProject((ItemGroup)this, kid);
                        observer.created((TopLevelItem)p);
                    }
                }
                finally {
                    observer.completed(kid);
                }
            }
        }

        @TestExtension(value={"eventAfterRestart"})
        public static final class DescriptorImpl
        extends AbstractFolderDescriptor {
            public TopLevelItem newInstance(ItemGroup parent, String name) {
                return new EventableFolder(parent, name);
            }
        }
    }
}

