/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.hudson.plugins.folder.Folder;
import com.cloudbees.hudson.plugins.folder.config.AbstractFolderConfiguration;
import com.cloudbees.hudson.plugins.folder.properties.AuthorizationMatrixProperty;
import com.cloudbees.hudson.plugins.folder.properties.FolderCredentialsProvider;
import com.cloudbees.plugins.credentials.domains.DomainCredentials;
import hudson.model.AbstractItem;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.ListView;
import hudson.model.ParameterDefinition;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.StringParameterDefinition;
import hudson.model.TopLevelItem;
import hudson.model.User;
import hudson.model.listeners.ItemListener;
import hudson.model.queue.QueueTaskFuture;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.ProjectMatrixAuthorizationStrategy;
import hudson.security.SecurityRealm;
import hudson.security.WhoAmI;
import hudson.tasks.BuildTrigger;
import hudson.util.DescribableList;
import hudson.views.BuildButtonColumn;
import hudson.views.JobColumn;
import hudson.views.ListViewColumn;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Future;
import jenkins.model.Jenkins;
import jenkins.model.RenameAction;
import jenkins.util.Timer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.htmlunit.HttpMethod;
import org.htmlunit.WebRequest;
import org.htmlunit.html.HtmlAnchor;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.HtmlRadioButtonInput;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.MockAuthorizationStrategy;
import org.jvnet.hudson.test.SleepBuilder;
import org.jvnet.hudson.test.TestExtension;
import org.jvnet.hudson.test.recipes.LocalData;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;

public class FolderTest {
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @ClassRule
    public static BuildWatcher bw = new BuildWatcher();

    @Test
    public void rename() throws Exception {
        Folder f = this.createFolder();
        f.setDescription("Some view");
        String oldName = f.getName();
        HtmlForm cfg = this.r.createWebClient().getPage((Item)f, "confirm-rename").getFormByName("config");
        cfg.getInputByName("newName").setValue("newName");
        for (HtmlForm form : this.r.submit(cfg).getForms()) {
            if (!form.getActionAttribute().equals("confirmRename")) continue;
            this.r.submit(form);
            break;
        }
        Assert.assertEquals((Object)"newName", (Object)f.getName());
        Assert.assertEquals((Object)"Some view", (Object)f.getDescription());
        Assert.assertNull((Object)this.r.jenkins.getItem(oldName));
        Assert.assertSame((Object)this.r.jenkins.getItem("newName"), (Object)f);
    }

    @Test
    public void renameProgrammatically() throws Exception {
        Folder f = this.createFolder();
        String folderFullName = f.getFullName();
        FreeStyleProject fsProject = new FreeStyleProject((ItemGroup)f, "p1");
        f.add((TopLevelItem)fsProject, "p1");
        Assert.assertSame((Object)fsProject, (Object)Jenkins.get().getItemByFullName(folderFullName + "/p1"));
        f.renameTo("newName");
        FreeStyleProject itemAfterFolderRename = (FreeStyleProject)Jenkins.get().getItemByFullName("newName/p1", FreeStyleProject.class);
        Assert.assertNotNull((Object)itemAfterFolderRename);
        itemAfterFolderRename.renameTo("newP1");
        Assert.assertEquals((Object)"newP1", (Object)itemAfterFolderRename.getParent().getItemName(itemAfterFolderRename.getRootDir(), (Item)itemAfterFolderRename));
        FreeStyleProject itemAfterRename = (FreeStyleProject)Jenkins.get().getItemByFullName("newName/newP1", FreeStyleProject.class);
        Assert.assertNotNull((Object)itemAfterRename);
        Assert.assertEquals((Object)"newName/newP1", (Object)itemAfterRename.getFullName());
    }

    @Test
    public void configRoundtrip() throws Exception {
        Folder f = this.createFolder();
        this.r.configRoundtrip((Item)f);
    }

    @Test
    public void deleteChild() throws Exception {
        Folder f = this.createFolder();
        FreeStyleProject child = (FreeStyleProject)f.createProject(FreeStyleProject.class, "foo");
        Assert.assertEquals((long)1L, (long)f.getItems().size());
        child.delete();
        Assert.assertEquals((long)0L, (long)f.getItems().size());
    }

    @Test
    public void copyJob() throws Exception {
        FreeStyleProject top = this.r.createFreeStyleProject("foo");
        top.setDescription("top");
        Folder f = this.createFolder();
        FreeStyleProject child = (FreeStyleProject)f.createProject(FreeStyleProject.class, "foo");
        child.setDescription("child");
        JenkinsRule.WebClient wc = this.r.createWebClient();
        this.copyViaHttp(f, wc, "foo", "xyz");
        Assert.assertEquals((Object)"child", (Object)((Job)f.getItem("xyz")).getDescription());
        this.copyViaHttp(f, wc, "/foo", "uvw");
        Assert.assertEquals((Object)"top", (Object)((Job)f.getItem("uvw")).getDescription());
    }

    private void copyViaHttp(Folder f, JenkinsRule.WebClient wc, String fromName, String toName) throws Exception {
        this.r.jenkins.setCrumbIssuer(null);
        URL apiURL = new URL(this.r.jenkins.getRootUrl().toString() + "/" + f.getUrl().toString() + "createItem?mode=copy&from=" + URLEncoder.encode(fromName, StandardCharsets.UTF_8) + "&name=" + URLEncoder.encode(toName, StandardCharsets.UTF_8));
        WebRequest request = new WebRequest(apiURL, HttpMethod.POST);
        request.setEncodingType(null);
        Assert.assertEquals((String)"Copy Job request has failed", (long)200L, (long)this.r.createWebClient().getPage(request).getWebResponse().getStatusCode());
    }

    @Test
    public void itemName() throws IOException {
        Folder f = this.createFolder();
        FreeStyleProject foo = (FreeStyleProject)f.createProject(FreeStyleProject.class, "foo");
        Assert.assertEquals((Object)"foo", (Object)f.getItemName(foo.getRootDir(), (TopLevelItem)foo));
    }

    @Test
    public void copy() throws Exception {
        Folder f = this.createFolder();
        FreeStyleProject c1 = (FreeStyleProject)f.createProject(FreeStyleProject.class, "child1");
        Folder c2 = (Folder)f.createProject(Folder.class, "nested");
        FreeStyleProject c21 = (FreeStyleProject)c2.createProject(FreeStyleProject.class, "child2");
        Folder f2 = (Folder)this.r.jenkins.copy((TopLevelItem)f, "fcopy");
        Assert.assertTrue((boolean)(f2.getItem("child1") instanceof FreeStyleProject));
        Folder n = (Folder)f2.getItem("nested");
        Assert.assertTrue((boolean)(n.getItem("child2") instanceof FreeStyleProject));
    }

    @Test
    public void delete() throws Exception {
        Folder d1 = (Folder)this.r.jenkins.createProject(Folder.class, "d1");
        d1.createProject(FreeStyleProject.class, "p1");
        d1.createProject(FreeStyleProject.class, "p2");
        ((Folder)d1.createProject(Folder.class, "d2")).createProject(FreeStyleProject.class, "p4");
        d1.delete();
        Assert.assertEquals((String)"AbstractFolder.items is sorted by name so we can predict deletion order", (Object)"{d1=[d1], d1/d2=[d1, d1/d2, d1/p1, d1/p2], d1/d2/p4=[d1, d1/d2, d1/d2/p4, d1/p1, d1/p2], d1/p1=[d1, d1/p1, d1/p2], d1/p2=[d1, d1/p2]}", (Object)DeleteListener.whatRemainedWhenDeleted.toString());
    }

    @Test
    public void interruptOnDelete() throws Exception {
        this.r.jenkins.setNumExecutors(2);
        Queue.getInstance().maintain();
        Folder d = (Folder)this.r.createProject(Folder.class, "d");
        FreeStyleProject p = (FreeStyleProject)d.createProject(FreeStyleProject.class, "p");
        p.addProperty((JobProperty)new ParametersDefinitionProperty(new ParameterDefinition[]{new StringParameterDefinition("dummy", "0")}));
        p.setConcurrentBuild(true);
        p.getBuildersList().add((Object)new SleepBuilder(Long.MAX_VALUE));
        FreeStyleBuild build1 = (FreeStyleBuild)p.scheduleBuild2(0).getStartCondition().get();
        FreeStyleBuild build2 = (FreeStyleBuild)p.scheduleBuild2(0).getStartCondition().get();
        QueueTaskFuture build3 = p.scheduleBuild2(0);
        Thread.sleep(1000L);
        d.delete();
        this.r.assertBuildStatus(Result.ABORTED, (Run)((FreeStyleBuild)this.r.waitForCompletion((Run)build1)));
        this.r.assertBuildStatus(Result.ABORTED, (Run)((FreeStyleBuild)this.r.waitForCompletion((Run)build2)));
        Assert.assertTrue((boolean)build3.isCancelled());
    }

    @Test
    public void trigger() throws Exception {
        Folder f = this.createFolder();
        FreeStyleProject a = (FreeStyleProject)f.createProject(FreeStyleProject.class, "a");
        FreeStyleProject b = (FreeStyleProject)f.createProject(FreeStyleProject.class, "b");
        a.getPublishersList().add((Object)new BuildTrigger("b", false));
        FreeStyleBuild a1 = (FreeStyleBuild)this.r.assertBuildStatusSuccess((Future)a.scheduleBuild2(0));
        for (int i = 0; i < 10 && b.getLastBuild() == null; ++i) {
            Thread.sleep(100L);
        }
    }

    @Test
    public void newViewPage() throws Exception {
        Folder f = this.createFolder();
        HtmlPage p = this.r.createWebClient().getPage((Item)f, "newView");
        HtmlForm fm = p.getFormByName("createItem");
        fm.getInputByName("name").setValue("abcView");
        for (HtmlRadioButtonInput r : fm.getRadioButtonsByName("mode")) {
            if (!r.getValue().equals(ListView.class.getName())) continue;
            r.click();
        }
        this.r.submit(fm);
        Assert.assertSame(ListView.class, f.getView("abcView").getClass());
    }

    @LocalData
    @Test
    public void dataCompatibility() throws Exception {
        Folder f = (Folder)this.r.jenkins.getItem("foo");
        ListView pv = (ListView)f.getPrimaryView();
        Assert.assertEquals((long)2L, (long)pv.getColumns().size());
        Assert.assertEquals(JobColumn.class, ((ListViewColumn)pv.getColumns().get(0)).getClass());
        Assert.assertEquals(BuildButtonColumn.class, ((ListViewColumn)pv.getColumns().get(1)).getClass());
        Assert.assertTrue((2 < new ListView("test").getColumns().size() ? 1 : 0) != 0);
    }

    @Test
    public void search() throws Exception {
        FreeStyleProject topJob = (FreeStyleProject)this.r.jenkins.createProject(FreeStyleProject.class, "top job");
        Folder f1 = (Folder)this.r.jenkins.createProject(Folder.class, "f1");
        FreeStyleProject middleJob = (FreeStyleProject)f1.createProject(FreeStyleProject.class, "middle job");
        Folder f2 = (Folder)f1.createProject(Folder.class, "f2");
        FreeStyleProject bottomJob = (FreeStyleProject)f2.createProject(FreeStyleProject.class, "bottom job");
        ArrayList items = new ArrayList();
        f1.getSearchIndex().suggest("job", items);
        Assert.assertEquals(new HashSet<FreeStyleProject>(Arrays.asList(middleJob, bottomJob)), new HashSet(items));
    }

    @Test
    public void reloadJenkinsAndFindBuildInProgress() throws Exception {
        Folder f1 = (Folder)this.r.jenkins.createProject(Folder.class, "f");
        FreeStyleProject p1 = (FreeStyleProject)f1.createProject(FreeStyleProject.class, "test1");
        FreeStyleBuild p1b1 = (FreeStyleBuild)p1.scheduleBuild2(0).get();
        p1.getBuildersList().add((Object)new SleepBuilder(99999999L));
        p1.save();
        FreeStyleBuild p1b2 = (FreeStyleBuild)p1.scheduleBuild2(0).waitForStart();
        this.r.jenkins.reload();
        Folder f2 = (Folder)this.r.jenkins.getItem("f");
        Assert.assertNotSame((Object)f1, (Object)f2);
        FreeStyleProject p2 = (FreeStyleProject)f2.getItem("test1");
        FreeStyleBuild p2b1 = (FreeStyleBuild)p2.getBuildByNumber(1);
        FreeStyleBuild p2b2 = (FreeStyleBuild)p2.getBuildByNumber(2);
        Assert.assertTrue((boolean)p2b2.isBuilding());
        Assert.assertSame((Object)p2b2, (Object)p1b2);
        Assert.assertNotSame((Object)p1b1, (Object)p2b1);
        p1b2.getExecutor().interrupt();
    }

    @Test
    public void discoverPermission() throws Exception {
        this.r.jenkins.setSecurityRealm((SecurityRealm)this.r.createDummySecurityRealm());
        Folder d = (Folder)this.r.jenkins.createProject(Folder.class, "d");
        FreeStyleProject p1 = (FreeStyleProject)d.createProject(FreeStyleProject.class, "p1");
        this.r.jenkins.setAuthorizationStrategy((AuthorizationStrategy)new MockAuthorizationStrategy().grant(new Permission[]{Jenkins.READ}).everywhere().toEveryone().grant(new Permission[]{Item.DISCOVER}).everywhere().toAuthenticated().grant(new Permission[]{Item.READ}).onItems(new Item[]{d}).toEveryone().grant(new Permission[]{Item.READ}).onItems(new Item[]{p1}).to(new String[]{"alice"}));
        FreeStyleProject p2 = (FreeStyleProject)d.createProject(FreeStyleProject.class, "p2");
        try (ACLContext context = ACL.as2((Authentication)Jenkins.ANONYMOUS2);){
            Assert.assertEquals(Collections.emptyList(), (Object)d.getItems());
            Assert.assertNull((Object)d.getItem("p1"));
            Assert.assertNull((Object)d.getItem("p2"));
        }
        context = ACL.as2((Authentication)User.getById((String)"alice", (boolean)true).impersonate2());
        try {
            Assert.assertEquals(Collections.singletonList(p1), (Object)d.getItems());
            Assert.assertEquals((Object)p1, (Object)d.getItem("p1"));
            try {
                d.getItem("p2");
                Assert.fail((String)"should have been told p2 exists");
            }
            catch (AccessDeniedException accessDeniedException) {
                // empty catch block
            }
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    @Test
    public void addAction() throws Exception {
        Folder f = this.createFolder();
        WhoAmI a = new WhoAmI();
        f.addAction((Action)a);
        Assert.assertNotNull((Object)f.getAction(WhoAmI.class));
    }

    @Test
    public void shouldAssignPropertyOwnerOnCreationAndReload() throws Exception {
        Folder folder = (Folder)this.r.jenkins.createProject(Folder.class, "myFolder");
        ProjectMatrixAuthorizationStrategy as = new ProjectMatrixAuthorizationStrategy();
        as.add(Jenkins.ADMINISTER, "alice");
        this.r.jenkins.setAuthorizationStrategy((AuthorizationStrategy)as);
        folder.addProperty((AbstractFolderProperty)new FolderCredentialsProvider.FolderCredentialsProperty(new DomainCredentials[0]));
        this.assertPropertyOwner("After property add", folder, FolderCredentialsProvider.FolderCredentialsProperty.class);
        this.r.jenkins.reload();
        Folder reloadedFolder = (Folder)this.r.jenkins.getItemByFullName("myFolder", Folder.class);
        this.assertPropertyOwner("After reload", reloadedFolder, FolderCredentialsProvider.FolderCredentialsProperty.class);
    }

    @Test
    public void shouldProperlyPersistFolderPropertiesOnMultipleReloads() throws Exception {
        Folder folder = (Folder)this.r.jenkins.createProject(Folder.class, "myFolder");
        folder.addProperty((AbstractFolderProperty)new FolderCredentialsProvider.FolderCredentialsProperty(new DomainCredentials[0]));
        this.r.jenkins.reload();
        HashMap grantedPermissions = new HashMap();
        HashSet<String> sids = new HashSet<String>();
        sids.add("admin");
        grantedPermissions.put(Jenkins.ADMINISTER, sids);
        folder = (Folder)this.r.jenkins.getItemByFullName("myFolder", Folder.class);
        ProjectMatrixAuthorizationStrategy as = new ProjectMatrixAuthorizationStrategy();
        as.add(Jenkins.ADMINISTER, "alice");
        this.r.jenkins.setAuthorizationStrategy((AuthorizationStrategy)as);
        folder.addProperty((AbstractFolderProperty)new AuthorizationMatrixProperty(grantedPermissions));
        this.r.jenkins.reload();
        Folder reloadedFolder = (Folder)this.r.jenkins.getItemByFullName("myFolder", Folder.class);
        MatcherAssert.assertThat((String)"Folder has not been found after the reloading", (Object)reloadedFolder, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)"Property has not been reloaded, hence it has not been saved properly", (Object)((AuthorizationMatrixProperty)reloadedFolder.getProperties().get(AuthorizationMatrixProperty.class)), (Matcher)Matchers.notNullValue());
        this.assertPropertyOwner("After reload", reloadedFolder, FolderCredentialsProvider.FolderCredentialsProperty.class);
        this.assertPropertyOwner("After reload", reloadedFolder, AuthorizationMatrixProperty.class);
    }

    @Test
    public void renameLinksShouldBeValid() throws Exception {
        FreeStyleProject project1 = this.r.createFreeStyleProject();
        Folder folder1 = this.createFolder();
        FreeStyleProject project2 = (FreeStyleProject)folder1.createProject(FreeStyleProject.class, "project2");
        HtmlAnchor anchor = this.findRenameAnchor((AbstractItem)project1);
        anchor.click();
        anchor = this.findRenameAnchor((AbstractItem)project2);
        anchor.click();
        anchor = this.findRenameAnchor((AbstractItem)folder1);
        anchor.click();
    }

    @Test
    public void shouldNotHaveHealthMetricConfiguredGloballyOnCreation() throws Exception {
        MatcherAssert.assertThat((String)"by default, global configuration should not have any health metrics", (Object)AbstractFolderConfiguration.get().getHealthMetrics(), (Matcher)Matchers.hasSize((int)0));
        Folder folder = (Folder)this.r.jenkins.createProject(Folder.class, "myFolder");
        DescribableList healthMetrics = folder.getHealthMetrics();
        MatcherAssert.assertThat((String)"a new created folder should not have any health metrics configured globally", (Object)healthMetrics, (Matcher)Matchers.hasSize((int)0));
        AbstractFolderConfiguration.get().setHealthMetrics(null);
        folder = (Folder)this.r.jenkins.createProject(Folder.class, "myFolder2");
        healthMetrics = folder.getHealthMetrics();
        MatcherAssert.assertThat((String)"a new created folder should not have any health metrics configured globally", (Object)healthMetrics, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void visibleItems() throws IOException, InterruptedException {
        this.r.jenkins.setSecurityRealm((SecurityRealm)this.r.createDummySecurityRealm());
        this.r.jenkins.setAuthorizationStrategy((AuthorizationStrategy)new MockAuthorizationStrategy().grant(new Permission[]{Jenkins.READ}).everywhere().toEveryone().grant(new Permission[]{Item.DISCOVER}).everywhere().toAuthenticated().grant(new Permission[]{Item.READ}).everywhere().to(new String[]{"alice"}));
        Folder f = this.createFolder();
        Assert.assertFalse((boolean)f.hasVisibleItems());
        FreeStyleProject child = (FreeStyleProject)f.createProject(FreeStyleProject.class, "foo");
        Assert.assertTrue((boolean)f.hasVisibleItems());
        try (ACLContext ctx = ACL.as((User)User.get((String)"alice", (boolean)true, Collections.emptyMap()));){
            Assert.assertTrue((boolean)f.hasVisibleItems());
        }
        ctx = ACL.as2((Authentication)Jenkins.ANONYMOUS2);
        try {
            Assert.assertFalse((boolean)f.hasVisibleItems());
        }
        finally {
            if (ctx != null) {
                ctx.close();
            }
        }
        child.delete();
        Assert.assertFalse((boolean)f.hasVisibleItems());
    }

    @Test
    public void getItemsPredicate() throws IOException {
        Folder d = (Folder)this.r.jenkins.createProject(Folder.class, "d");
        FreeStyleProject p1 = (FreeStyleProject)d.createProject(FreeStyleProject.class, "p1");
        FreeStyleProject p2 = (FreeStyleProject)d.createProject(FreeStyleProject.class, "p2");
        FreeStyleProject c1 = (FreeStyleProject)d.createProject(FreeStyleProject.class, "c1");
        MatcherAssert.assertThat((Object)d.getItems(p -> p.getDisplayName().startsWith("p")), (Matcher)Matchers.containsInAnyOrder((Object[])new TopLevelItem[]{p1, p2}));
    }

    private <T extends AbstractFolderProperty<AbstractFolder<?>>> void assertPropertyOwner(String step, Folder folder, Class<T> propertyClass) {
        AbstractFolder propertyOwner = ((AbstractFolderProperty)folder.getProperties().get(propertyClass)).getOwner();
        MatcherAssert.assertThat((String)(step + ": The property owner should be instance of Folder"), (Object)propertyOwner, (Matcher)Matchers.instanceOf(Folder.class));
        MatcherAssert.assertThat((String)(step + ": The owner field of the " + String.valueOf(propertyClass) + " property should point to the owner folder " + String.valueOf(folder)), (Object)((Folder)propertyOwner), (Matcher)Matchers.equalTo((Object)folder));
    }

    private Folder createFolder() throws IOException {
        return (Folder)this.r.jenkins.createProject(Folder.class, "folder" + this.r.jenkins.getItems().size());
    }

    private HtmlAnchor findRenameAnchor(AbstractItem item) throws Exception {
        JenkinsRule.WebClient w = this.r.createWebClient();
        HtmlPage page = w.goTo(item.getUrl());
        String relativeUrl = this.r.contextPath + "/" + item.getUrl() + ((RenameAction)item.getAction(RenameAction.class)).getUrlName();
        return page.getAnchorByHref(relativeUrl);
    }

    @Test
    public void doCreateView() throws Exception {
        Folder f = this.createFolder();
        String folderURL = f.getUrl() + "createView?mode=copy&name=NewView&from=All";
        JenkinsRule.WebClient webClient = this.r.createWebClient().withThrowExceptionOnFailingStatusCode(false);
        Assert.assertEquals((long)404L, (long)webClient.goTo(folderURL).getWebResponse().getStatusCode());
    }

    @Test
    public void doCreateItem() throws Exception {
        Folder f = this.createFolder();
        String folderURL = f.getUrl() + "createItem?mode=copy&name=NewFolder&from=" + f.getName();
        JenkinsRule.WebClient webClient = this.r.createWebClient().withThrowExceptionOnFailingStatusCode(false);
        Assert.assertEquals((long)405L, (long)webClient.goTo(folderURL).getWebResponse().getStatusCode());
    }

    @TestExtension(value={"delete"})
    public static class DeleteListener
    extends ItemListener {
        static Map<String, Set<String>> whatRemainedWhenDeleted = new TreeMap<String, Set<String>>();

        public void onDeleted(Item item) {
            block2: {
                try {
                    whatRemainedWhenDeleted.put(item.getFullName(), Timer.get().submit(() -> {
                        TreeSet<String> remaining = new TreeSet<String>();
                        for (Item i : Jenkins.get().getAllItems()) {
                            remaining.add(i.getFullName());
                            if (!(i instanceof Actionable)) continue;
                            ((Actionable)i).getAllActions();
                        }
                        return remaining;
                    }).get());
                }
                catch (Exception x) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError((Object)x);
                }
            }
        }
    }
}

