// CHECKSTYLE:OFF

package hudson.plugins.build_timeout.operations;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code AbortOperation.DisplayName}: {@code Abort the build}.
     * 
     * @return
     *     {@code Abort the build}
     */
    public static String AbortOperation_DisplayName() {
        return holder.format("AbortOperation.DisplayName");
    }

    /**
     * Key {@code AbortOperation.DisplayName}: {@code Abort the build}.
     * 
     * @return
     *     {@code Abort the build}
     */
    public static Localizable _AbortOperation_DisplayName() {
        return new Localizable(holder, "AbortOperation.DisplayName");
    }

    /**
     * Key {@code FailOperation.DisplayName}: {@code Fail the build}.
     * 
     * @return
     *     {@code Fail the build}
     */
    public static String FailOperation_DisplayName() {
        return holder.format("FailOperation.DisplayName");
    }

    /**
     * Key {@code FailOperation.DisplayName}: {@code Fail the build}.
     * 
     * @return
     *     {@code Fail the build}
     */
    public static Localizable _FailOperation_DisplayName() {
        return new Localizable(holder, "FailOperation.DisplayName");
    }

    /**
     * Key {@code WriteDescriptionOperation.DisplayName}: {@code Writing the
     * build description}.
     * 
     * @return
     *     {@code Writing the build description}
     */
    public static String WriteDescriptionOperation_DisplayName() {
        return holder.format("WriteDescriptionOperation.DisplayName");
    }

    /**
     * Key {@code WriteDescriptionOperation.DisplayName}: {@code Writing the
     * build description}.
     * 
     * @return
     *     {@code Writing the build description}
     */
    public static Localizable _WriteDescriptionOperation_DisplayName() {
        return new Localizable(holder, "WriteDescriptionOperation.DisplayName");
    }

    /**
     * Key {@code BuildStepOperation.DisplayName}: {@code Perform BuildStep}.
     * 
     * @return
     *     {@code Perform BuildStep}
     */
    public static String BuildStepOperation_DisplayName() {
        return holder.format("BuildStepOperation.DisplayName");
    }

    /**
     * Key {@code BuildStepOperation.DisplayName}: {@code Perform BuildStep}.
     * 
     * @return
     *     {@code Perform BuildStep}
     */
    public static Localizable _BuildStepOperation_DisplayName() {
        return new Localizable(holder, "BuildStepOperation.DisplayName");
    }

    /**
     * Key {@code AbortAndRestartOperation.ScheduledRestart}: {@code
     * Scheduled restart of the build (up to {0} times).}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Scheduled restart of the build (up to {0} times).}
     */
    public static String AbortAndRestartOperation_ScheduledRestart(Object arg0) {
        return holder.format("AbortAndRestartOperation.ScheduledRestart", arg0);
    }

    /**
     * Key {@code AbortAndRestartOperation.ScheduledRestart}: {@code
     * Scheduled restart of the build (up to {0} times).}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Scheduled restart of the build (up to {0} times).}
     */
    public static Localizable _AbortAndRestartOperation_ScheduledRestart(Object arg0) {
        return new Localizable(holder, "AbortAndRestartOperation.ScheduledRestart", arg0);
    }

    /**
     * Key {@code AbortAndRestartOperation.InstallNaginator}: {@code You need
     * to install naginator-plugin >= 1.16 to restart a build.}.
     * 
     * @return
     *     {@code You need to install naginator-plugin >= 1.16 to restart a
     *     build.}
     */
    public static String AbortAndRestartOperation_InstallNaginator() {
        return holder.format("AbortAndRestartOperation.InstallNaginator");
    }

    /**
     * Key {@code AbortAndRestartOperation.InstallNaginator}: {@code You need
     * to install naginator-plugin >= 1.16 to restart a build.}.
     * 
     * @return
     *     {@code You need to install naginator-plugin >= 1.16 to restart a
     *     build.}
     */
    public static Localizable _AbortAndRestartOperation_InstallNaginator() {
        return new Localizable(holder, "AbortAndRestartOperation.InstallNaginator");
    }

    /**
     * Key {@code AbortAndRestartOperation.DisplayName}: {@code Abort and
     * restart the build}.
     * 
     * @return
     *     {@code Abort and restart the build}
     */
    public static String AbortAndRestartOperation_DisplayName() {
        return holder.format("AbortAndRestartOperation.DisplayName");
    }

    /**
     * Key {@code AbortAndRestartOperation.DisplayName}: {@code Abort and
     * restart the build}.
     * 
     * @return
     *     {@code Abort and restart the build}
     */
    public static Localizable _AbortAndRestartOperation_DisplayName() {
        return new Localizable(holder, "AbortAndRestartOperation.DisplayName");
    }

}
