/*
 * Decompiled with CFR 0.152.
 */
package au.com.centrumsystems.hudson.plugin.util;

import au.com.centrumsystems.hudson.plugin.util.ProjectUtil;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.FileParameterValue;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.util.RunList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class BuildUtil {
    public static AbstractBuild<?, ?> getDownstreamBuild(AbstractProject<?, ?> downstreamProject, AbstractBuild<?, ?> upstreamBuild) {
        if (downstreamProject != null && upstreamBuild != null) {
            int maxDownstreamDepth = Integer.getInteger(BuildUtil.class.getCanonicalName() + ".MAX_DOWNSTREAM_DEPTH", Integer.MAX_VALUE);
            RunList downstreamBuilds = downstreamProject.getBuilds().limit(maxDownstreamDepth);
            for (AbstractBuild innerBuild : downstreamBuilds) {
                Cause.UpstreamCause cause = (Cause.UpstreamCause)innerBuild.getCause(Cause.UpstreamCause.class);
                if (cause == null || !cause.pointsTo(upstreamBuild)) continue;
                return innerBuild;
            }
        }
        return null;
    }

    public static Action getAllBuildParametersAction(AbstractBuild<?, ?> upstreamBuild, AbstractProject<?, ?> downstreamProject) {
        ParametersAction dsProjectParametersAction = ProjectUtil.getProjectParametersAction(downstreamProject);
        ParametersAction usBuildParametersAction = BuildUtil.getBuildParametersAction(upstreamBuild);
        return BuildUtil.mergeParameters(usBuildParametersAction, dsProjectParametersAction);
    }

    public static ParametersAction getBuildParametersAction(AbstractBuild<?, ?> build) {
        ParametersAction buildParametersAction = null;
        if (build != null) {
            for (Action nextAction : build.getActions()) {
                if (!(nextAction instanceof ParametersAction)) continue;
                buildParametersAction = (ParametersAction)nextAction;
                ArrayList<ParameterValue> parameters = new ArrayList<ParameterValue>();
                for (ParameterValue parameter : buildParametersAction.getParameters()) {
                    if (parameter instanceof FileParameterValue) continue;
                    parameters.add(parameter);
                }
                buildParametersAction = new ParametersAction(parameters);
            }
        }
        return buildParametersAction;
    }

    public static ParametersAction mergeParameters(ParametersAction base, ParametersAction overlay) {
        LinkedHashMap<String, ParameterValue> params = new LinkedHashMap<String, ParameterValue>();
        if (base != null) {
            for (ParameterValue param : base.getParameters()) {
                params.put(param.getName(), param);
            }
        }
        if (overlay != null) {
            for (ParameterValue param : overlay.getParameters()) {
                params.put(param.getName(), param);
            }
        }
        return new ParametersAction(params.values().toArray(new ParameterValue[params.size()]));
    }

    public static Map<String, String> getUnsensitiveParameters(AbstractBuild<?, ?> build) {
        HashMap<String, String> retval = new HashMap<String, String>();
        if (build != null) {
            retval.putAll(build.getBuildVariables());
            Set sensitiveBuildVariables = build.getSensitiveBuildVariables();
            if (sensitiveBuildVariables != null) {
                for (String paramName : sensitiveBuildVariables) {
                    if (!retval.containsKey(paramName)) continue;
                    retval.put(paramName, "********");
                }
            }
        }
        return retval;
    }
}

