/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins;

import com.cloudbees.jenkins.plugins.BitbucketJobProbe;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;

public class BitbucketPayloadProcessor {
    private final BitbucketJobProbe probe;
    private static final Logger LOGGER = Logger.getLogger(BitbucketPayloadProcessor.class.getName());

    public BitbucketPayloadProcessor(BitbucketJobProbe probe) {
        this.probe = probe;
    }

    public BitbucketPayloadProcessor() {
        this(new BitbucketJobProbe());
    }

    public void processPayload(JSONObject payload, HttpServletRequest request) {
        if ("Bitbucket-Webhooks/2.0".equals(request.getHeader("user-agent"))) {
            if ("repo:push".equals(request.getHeader("x-event-key"))) {
                LOGGER.info("Processing new Webhooks payload");
                this.processWebhookPayload(payload);
            }
        } else {
            LOGGER.info("Processing old POST service payload");
            this.processPostServicePayload(payload);
        }
    }

    private void processWebhookPayload(JSONObject payload) {
        JSONObject repo = payload.getJSONObject("repository");
        LOGGER.info("Received commit hook notification for " + repo);
        String user = payload.getJSONObject("actor").getString("username");
        String url = repo.getJSONObject("links").getJSONObject("html").getString("href");
        String scm = repo.has("scm") ? repo.getString("scm") : "git";
        this.probe.triggerMatchingJobs(user, url, scm);
    }

    private void processPostServicePayload(JSONObject payload) {
        JSONObject repo = payload.getJSONObject("repository");
        LOGGER.info("Received commit hook notification for " + repo);
        String user = payload.getString("user");
        String url = payload.getString("canon_url") + repo.getString("absolute_url");
        String scm = repo.getString("scm");
        this.probe.triggerMatchingJobs(user, url, scm);
    }
}

