/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins;

import com.cloudbees.jenkins.plugins.BitBucketTrigger;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitStatus;
import hudson.scm.SCM;
import hudson.security.ACL;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;

public class BitbucketJobProbe {
    private static final Logger LOGGER = Logger.getLogger(BitbucketJobProbe.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerMatchingJobs(String user, String url, String scm) {
        if ("git".equals(scm)) {
            Jenkins.getInstance().getACL();
            SecurityContext old = ACL.impersonate((Authentication)ACL.SYSTEM);
            try {
                URIish remote = new URIish(url);
                for (AbstractProject job : Hudson.getInstance().getAllItems(AbstractProject.class)) {
                    LOGGER.info("considering candidate job " + job.getName());
                    BitBucketTrigger trigger = (BitBucketTrigger)job.getTrigger(BitBucketTrigger.class);
                    if (trigger != null) {
                        if (this.match(job.getScm(), remote)) {
                            trigger.onPost(user);
                            continue;
                        }
                        LOGGER.info("job SCM doesn't match remote repo");
                        continue;
                    }
                    LOGGER.info("job hasn't BitBucketTrigger set");
                }
            }
            catch (URISyntaxException e) {
                LOGGER.warning("invalid repository URL " + url);
            }
            finally {
                SecurityContextHolder.setContext((SecurityContext)old);
            }
        } else {
            throw new UnsupportedOperationException("unsupported SCM type " + scm);
        }
    }

    private boolean match(SCM scm, URIish url) {
        if (scm instanceof GitSCM) {
            for (RemoteConfig remoteConfig : ((GitSCM)scm).getRepositories()) {
                for (URIish urIish : remoteConfig.getURIs()) {
                    if (!GitStatus.looselyMatches((URIish)urIish, (URIish)url)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

