/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins;

import com.cloudbees.jenkins.plugins.BitbucketPayloadProcessor;
import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class BitbucketHookReceiver
implements UnprotectedRootAction {
    private final BitbucketPayloadProcessor payloadProcessor = new BitbucketPayloadProcessor();
    private static final Logger LOGGER = Logger.getLogger(BitbucketHookReceiver.class.getName());

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "bitbucket-hook";
    }

    public void doIndex(StaplerRequest req) throws IOException {
        String body = IOUtils.toString((InputStream)req.getInputStream());
        String contentType = req.getContentType();
        if (contentType != null && contentType.startsWith("application/x-www-form-urlencoded")) {
            body = URLDecoder.decode(body);
        }
        if (body.startsWith("payload=")) {
            body = body.substring(8);
        }
        LOGGER.fine("Received commit hook notification : " + body);
        JSONObject payload = JSONObject.fromObject((Object)body);
        this.payloadProcessor.processPayload(payload, (HttpServletRequest)req);
    }
}

