/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins;

import com.cloudbees.jenkins.plugins.BitBucketPushCause;
import hudson.Extension;
import hudson.Util;
import hudson.console.AnnotatedLargeText;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.SequentialExecutionQueue;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jelly.XMLOutput;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitBucketTrigger
extends Trigger<AbstractProject> {
    private static final Logger LOGGER = Logger.getLogger(BitBucketTrigger.class.getName());

    @DataBoundConstructor
    public BitBucketTrigger() {
    }

    public void onPost(String triggeredByUser) {
        final String pushBy = triggeredByUser;
        this.getDescriptor().queue.execute(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private boolean runPolling() {
                try {
                    StreamTaskListener listener = new StreamTaskListener(BitBucketTrigger.this.getLogFile());
                    try {
                        PrintStream logger = listener.getLogger();
                        long start = System.currentTimeMillis();
                        logger.println("Started on " + DateFormat.getDateTimeInstance().format(new Date()));
                        boolean result = ((AbstractProject)BitBucketTrigger.this.job).poll((TaskListener)listener).hasChanges();
                        logger.println("Done. Took " + Util.getTimeSpanString((long)(System.currentTimeMillis() - start)));
                        if (result) {
                            logger.println("Changes found");
                        } else {
                            logger.println("No changes");
                        }
                        boolean bl = result;
                        return bl;
                    }
                    catch (Error e) {
                        e.printStackTrace(listener.error("Failed to record SCM polling"));
                        LOGGER.log(Level.SEVERE, "Failed to record SCM polling", e);
                        throw e;
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace(listener.error("Failed to record SCM polling"));
                        LOGGER.log(Level.SEVERE, "Failed to record SCM polling", e);
                        throw e;
                    }
                    finally {
                        listener.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Failed to record SCM polling", e);
                    return false;
                }
            }

            public void run() {
                if (this.runPolling()) {
                    BitBucketPushCause cause;
                    String name = " #" + ((AbstractProject)BitBucketTrigger.this.job).getNextBuildNumber();
                    try {
                        cause = new BitBucketPushCause(BitBucketTrigger.this.getLogFile(), pushBy);
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to parse the polling log", e);
                        cause = new BitBucketPushCause(pushBy);
                    }
                    if (((AbstractProject)BitBucketTrigger.this.job).scheduleBuild((Cause)cause)) {
                        LOGGER.info("SCM changes detected in " + ((AbstractProject)BitBucketTrigger.this.job).getName() + ". Triggering " + name);
                    } else {
                        LOGGER.info("SCM changes detected in " + ((AbstractProject)BitBucketTrigger.this.job).getName() + ". Job is already in the queue");
                    }
                }
            }
        });
    }

    public Collection<? extends Action> getProjectActions() {
        return Collections.singleton(new BitBucketWebHookPollingAction());
    }

    public File getLogFile() {
        return new File(((AbstractProject)this.job).getRootDir(), "bitbucket-polling.log");
    }

    public boolean IsLogFileInitialized() {
        File file = new File(((AbstractProject)this.job).getRootDir(), "bitbucket-polling.log");
        return file.exists();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static class DescriptorImpl
    extends TriggerDescriptor {
        private final transient SequentialExecutionQueue queue = new SequentialExecutionQueue(Hudson.MasterComputer.threadPoolForRemoting);

        public boolean isApplicable(Item item) {
            return item instanceof AbstractProject;
        }

        public String getDisplayName() {
            return "Build when a change is pushed to BitBucket";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class BitBucketWebHookPollingAction
    implements Action {
        public AbstractProject<?, ?> getOwner() {
            return (AbstractProject)BitBucketTrigger.this.job;
        }

        public String getIconFileName() {
            return "clipboard.png";
        }

        public String getDisplayName() {
            return "BitBucket Hook Log";
        }

        public String getUrlName() {
            return "BitBucketPollLog";
        }

        public String getLog() throws IOException {
            return Util.loadFile((File)BitBucketTrigger.this.getLogFile());
        }

        public void writeLogTo(XMLOutput out) throws IOException {
            new AnnotatedLargeText(BitBucketTrigger.this.getLogFile(), Charset.defaultCharset(), true, (Object)this).writeHtmlTo(0L, out.asWriter());
        }
    }
}

