/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.azurekeyvaultplugin;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class AzureKeyVaultSecret
extends AbstractDescribableImpl<AzureKeyVaultSecret>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String typeSecret = "Secret";
    public static final String typeCertificate = "Certificate";
    private String secretType;
    private String name;
    private String version;
    private String envVariable;

    public AzureKeyVaultSecret(String secretType, String name, String version, String envVariable) {
        this.secretType = secretType;
        this.name = name;
        this.version = version;
        this.envVariable = envVariable;
    }

    @DataBoundConstructor
    public AzureKeyVaultSecret(String secretType, String name, String envVariable) {
        this(secretType, name, null, envVariable);
    }

    public String getSecretType() {
        return this.secretType;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    @DataBoundSetter
    public void setVersion(String version) {
        this.version = Util.fixEmpty((String)version);
    }

    public String getEnvVariable() {
        return this.envVariable;
    }

    public boolean isPassword() {
        return this.secretType != null && this.secretType.equals(typeSecret);
    }

    public boolean isCertificate() {
        return this.secretType != null && this.secretType.equals(typeCertificate);
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<AzureKeyVaultSecret> {
        public String getDisplayName() {
            return "Secret type, environment variable, and name/version pair for an Azure Key Vault secret";
        }

        public ListBoxModel doFillSecretTypeItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(AzureKeyVaultSecret.typeSecret, AzureKeyVaultSecret.typeSecret);
            items.add(AzureKeyVaultSecret.typeCertificate, AzureKeyVaultSecret.typeCertificate);
            return items;
        }
    }
}

