/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.azurekeyvaultplugin;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.security.auth.login.CredentialNotFoundException;
import jenkins.YesNoMaybe;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.azurekeyvaultplugin.AzureKeyVaultException;
import org.jenkinsci.plugins.azurekeyvaultplugin.AzureKeyVaultGlobalConfiguration;
import org.jenkinsci.plugins.azurekeyvaultplugin.AzureKeyVaultSecret;
import org.jenkinsci.plugins.azurekeyvaultplugin.AzureKeyVaultStep;
import org.jenkinsci.plugins.azurekeyvaultplugin.AzureKeyVaultUtil;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.verb.POST;

public class AzureKeyVaultBuildWrapper
extends Step {
    private static final Logger LOGGER = Logger.getLogger("Jenkins.AzureKeyVaultBuildWrapper");
    private final List<AzureKeyVaultSecret> azureKeyVaultSecrets;
    private String keyVaultURL;
    private String applicationID;
    private String applicationSecret;
    private String credentialID;
    private String tenantId;

    @DataBoundConstructor
    public AzureKeyVaultBuildWrapper(@CheckForNull List<AzureKeyVaultSecret> azureKeyVaultSecrets) {
        this.azureKeyVaultSecrets = azureKeyVaultSecrets;
    }

    public String getKeyVaultURLOverride() {
        return this.keyVaultURL;
    }

    @DataBoundSetter
    public void setKeyVaultURLOverride(String keyVaultURL) {
        this.keyVaultURL = Util.fixEmpty((String)keyVaultURL);
    }

    public String getApplicationIDOverride() {
        return this.applicationID;
    }

    @DataBoundSetter
    public void setApplicationIDOverride(String applicationID) {
        this.applicationID = Util.fixEmpty((String)applicationID);
    }

    public String getApplicationSecretOverride() {
        return this.applicationSecret;
    }

    @DataBoundSetter
    public void setApplicationSecretOverride(String applicationSecret) {
        this.applicationSecret = Util.fixEmpty((String)applicationSecret);
    }

    public String getCredentialIDOverride() {
        return this.credentialID;
    }

    @DataBoundSetter
    public void setCredentialIDOverride(String credentialID) {
        this.credentialID = Util.fixEmpty((String)credentialID);
    }

    public String getTenantIdOverride() {
        return this.tenantId;
    }

    @DataBoundSetter
    public void setTenantIdOverride(String tenantId) {
        this.tenantId = Util.fixEmpty((String)tenantId);
    }

    public String getApplicationID() {
        return this.applicationID;
    }

    public List<AzureKeyVaultSecret> getAzureKeyVaultSecrets() {
        return this.azureKeyVaultSecrets;
    }

    public StepExecution start(StepContext context) throws Exception {
        AzureKeyVaultGlobalConfiguration globalConfiguration = AzureKeyVaultGlobalConfiguration.get();
        String resolvedKeyVaultUrl = (String)ObjectUtils.firstNonNull((Object[])new String[]{this.keyVaultURL, globalConfiguration.getKeyVaultURL()});
        if (StringUtils.isEmpty((CharSequence)resolvedKeyVaultUrl)) {
            throw new AzureKeyVaultException("No key vault url configured, set one globally or in the build wrap step");
        }
        String resolvedCredentialId = (String)ObjectUtils.firstNonNull((Object[])new String[]{this.credentialID, globalConfiguration.getCredentialID()});
        if (this.isLegacyAuth()) {
            TaskListener taskListener = (TaskListener)context.get(TaskListener.class);
            PrintStream logger = taskListener.getLogger();
            logger.println("***************************************************************************************************\nDeprecated: Use a credential ID instead of individual values for the service principal.\nIf you can't then please raise an issue at https://github.com/jenkinsci/azure-keyvault-plugin/issues.\nThis will be removed at some point.\n***************************************************************************************************");
            return new AzureKeyVaultStep.ExecutionImpl(context, resolvedKeyVaultUrl, this.applicationID, this.applicationSecret, this.tenantId, this.azureKeyVaultSecrets);
        }
        if (StringUtils.isEmpty((CharSequence)resolvedCredentialId)) {
            throw new CredentialNotFoundException("Unable to find a valid credential with provided parameters");
        }
        return new AzureKeyVaultStep.ExecutionImpl(context, resolvedKeyVaultUrl, resolvedCredentialId, this.azureKeyVaultSecrets);
    }

    private boolean isLegacyAuth() {
        return StringUtils.isNotEmpty((CharSequence)this.applicationID) && StringUtils.isNotEmpty((CharSequence)this.applicationSecret) && StringUtils.isNotEmpty((CharSequence)this.tenantId);
    }

    @Extension(dynamicLoadable=YesNoMaybe.YES, optional=true)
    public static class DescriptorImpl
    extends StepDescriptor {
        @POST
        public ListBoxModel doFillCredentialIDOverrideItems(@AncestorInPath Item context) {
            return AzureKeyVaultUtil.doFillCredentialIDItems(context);
        }

        @NonNull
        public String getDisplayName() {
            return "Bind credentials in Azure Key Vault to environment variables";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Set.of(Run.class);
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public String getFunctionName() {
            return "withAzureKeyvault";
        }
    }
}

