/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ansible;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.ansible.AnsibleInstallation;
import org.jenkinsci.plugins.ansible.Inventory;
import org.jenkinsci.plugins.plaincredentials.FileCredentials;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;

public abstract class AbstractAnsibleBuilderDescriptor
extends BuildStepDescriptor<Builder> {
    private final String displayName;

    protected AbstractAnsibleBuilderDescriptor(String displayName) {
        this.displayName = displayName;
        this.load();
    }

    protected FormValidation checkNotNullOrEmpty(String parameter, String errorMessage) {
        if (StringUtils.isNotBlank((CharSequence)parameter)) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)errorMessage);
    }

    public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
        StandardListBoxModel result = new StandardListBoxModel();
        if (item == null ? !Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
            return result.includeCurrentValue(credentialsId);
        }
        return result.includeEmptyValue().withMatching(CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(SSHUserPrivateKey.class), CredentialsMatchers.instanceOf(UsernamePasswordCredentials.class)}), (Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)item)).includeCurrentValue(credentialsId);
    }

    public ListBoxModel doFillVaultCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String vaultCredentialsId) {
        return this.fillVaultCredentials(item, vaultCredentialsId);
    }

    public ListBoxModel doFillNewVaultCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String newVaultCredentialsId) {
        return this.fillVaultCredentials(item, newVaultCredentialsId);
    }

    private ListBoxModel fillVaultCredentials(Item item, String credentialsId) {
        StandardListBoxModel result = new StandardListBoxModel();
        if (item == null ? !Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
            return result.includeCurrentValue(credentialsId);
        }
        return result.includeEmptyValue().withMatching(CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(FileCredentials.class), CredentialsMatchers.instanceOf(StringCredentials.class)}), (Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)item)).includeCurrentValue(credentialsId);
    }

    public List<Inventory.InventoryDescriptor> getInventories() {
        return Jenkins.getActiveInstance().getDescriptorList(Inventory.class);
    }

    public boolean isApplicable(Class<? extends AbstractProject> klass) {
        return true;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public AnsibleInstallation[] getInstallations() {
        return AnsibleInstallation.allInstallations();
    }
}

