/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.androidsigning;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.ItemGroup;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.androidsigning.Apk;
import org.jenkinsci.plugins.androidsigning.KeystoreCredentials;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignArtifactPlugin
extends Publisher {
    private List<Apk> entries = Collections.emptyList();

    @DataBoundConstructor
    public SignArtifactPlugin(List<Apk> apks) {
        this.entries = apks;
        if (this.entries == null) {
            this.entries = Collections.emptyList();
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    private boolean isPerformDeployment(AbstractBuild build) {
        Result result = build.getResult();
        if (result == null) {
            return true;
        }
        return build.getResult().isBetterOrEqualTo(Result.UNSTABLE);
    }

    public List<Apk> getEntries() {
        return this.entries;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (this.isPerformDeployment(build)) {
            for (Apk entry : this.entries) {
                StringTokenizer rpmGlobTokenizer = new StringTokenizer(entry.getSelection(), ",");
                KeystoreCredentials keystore = this.getKeystore(entry.getKeyStore());
                listener.getLogger().println("[AndroidSignPlugin] - Signing " + rpmGlobTokenizer.countTokens() + " APKs");
                while (rpmGlobTokenizer.hasMoreTokens()) {
                    String rpmGlob = rpmGlobTokenizer.nextToken();
                    Object[] matchedApks = build.getWorkspace().list(rpmGlob);
                    if (ArrayUtils.isEmpty((Object[])matchedApks)) {
                        listener.getLogger().println("[AndroidSignPlugin] - No APKs matching " + rpmGlob);
                        continue;
                    }
                    for (Object rpmFilePath : matchedApks) {
                        ArgumentListBuilder apkSignCommand = new ArgumentListBuilder();
                        String cleanPath = rpmFilePath.toURI().normalize().getPath();
                        String signedPath = cleanPath.replace("unsigned", "signed");
                        String alignedPath = signedPath.replace("signed", "signed-aligned");
                        FilePath key = keystore.makeTempPath(build.getWorkspace());
                        apkSignCommand.add("jarsigner");
                        apkSignCommand.add(new String[]{"-sigalg", "SHA1withRSA"});
                        apkSignCommand.add(new String[]{"-digestalg", "SHA1"});
                        apkSignCommand.add(new String[]{"-keystore", key.getRemote()});
                        apkSignCommand.add("-storepass");
                        apkSignCommand.addMasked(keystore.getPassphrase());
                        apkSignCommand.add(new String[]{"-signedjar", signedPath});
                        apkSignCommand.add(cleanPath);
                        apkSignCommand.add(entry.getAlias());
                        listener.getLogger().println("[AndroidSignPlugin] - Signing on " + Computer.currentComputer().getDisplayName());
                        Launcher.ProcStarter ps = new Launcher.ProcStarter(launcher);
                        ps = ps.cmds(apkSignCommand).stdout((TaskListener)listener);
                        ps = ps.pwd(rpmFilePath.getParent()).envs((Map)build.getEnvironment((TaskListener)listener));
                        Proc proc = launcher.launch(ps);
                        int retcode = proc.join();
                        key.delete();
                        if (retcode != 0) {
                            listener.getLogger().println("[AndroidSignPlugin] - Failed signing APK");
                            return false;
                        }
                        LinkedHashMap<String, String> artifactsInsideWorkspace = new LinkedHashMap<String, String>();
                        artifactsInsideWorkspace.put(signedPath, this.stripWorkspace(build.getWorkspace(), signedPath));
                        String zipalign = (String)build.getEnvironment((TaskListener)listener).get((Object)"ANDROID_ZIPALIGN");
                        if (zipalign == null || StringUtils.isEmpty((String)zipalign)) {
                            throw new RuntimeException("You must set the environmental variable ANDROID_ZIPALIGN to point to the correct binary");
                        }
                        ArgumentListBuilder zipalignCommand = new ArgumentListBuilder();
                        zipalignCommand.add(zipalign);
                        zipalignCommand.add("4");
                        zipalignCommand.add(signedPath);
                        zipalignCommand.add(alignedPath);
                        Launcher.ProcStarter ps2 = new Launcher.ProcStarter(launcher);
                        ps2 = ps2.cmds(zipalignCommand).stdout((TaskListener)listener);
                        ps2 = ps2.pwd(rpmFilePath.getParent()).envs((Map)build.getEnvironment((TaskListener)listener));
                        Proc proc2 = launcher.launch(ps2);
                        retcode = proc2.join();
                        if (retcode != 0) {
                            listener.getLogger().println("[AndroidSignPlugin] - Failed aligning APK");
                            return true;
                        }
                        artifactsInsideWorkspace.put(alignedPath, this.stripWorkspace(build.getWorkspace(), alignedPath));
                        build.pickArtifactManager().archive(build.getWorkspace(), launcher, listener, artifactsInsideWorkspace);
                    }
                }
            }
            listener.getLogger().println("[AndroidSignPlugin] - Finished signing APKs ...");
        } else {
            listener.getLogger().println("[AndroidSignPlugin] - Skipping signing APKs ...");
        }
        return true;
    }

    private String stripWorkspace(FilePath ws, String path) {
        return path.replace(ws.getRemote(), "");
    }

    private KeystoreCredentials getKeystore(String keyStoreName) {
        List creds = CredentialsProvider.lookupCredentials(KeystoreCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM);
        for (KeystoreCredentials cred : creds) {
            if (!cred.getId().equals(keyStoreName)) continue;
            return cred;
        }
        return null;
    }
}

