/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import hudson.Extension;
import hudson.model.User;
import hudson.plugins.active_directory.ActiveDirectorySecurityRealm;
import hudson.plugins.active_directory.ActiveDirectoryUserDetail;
import hudson.security.SecurityRealm;
import hudson.tasks.MailAddressResolver;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;

@Extension
public class ActiveDirectoryMailAddressResolverImpl
extends MailAddressResolver {
    private static final Logger LOGGER = Logger.getLogger(ActiveDirectoryMailAddressResolverImpl.class.getName());

    public String findMailAddressFor(User u) {
        SecurityRealm realm = Jenkins.getActiveInstance().getSecurityRealm();
        if (!(realm instanceof ActiveDirectorySecurityRealm)) {
            return null;
        }
        try {
            UserDetailsService uds = realm.getSecurityComponents().userDetails2;
            UserDetails userDetails = uds.loadUserByUsername(u.getId());
            if (userDetails instanceof ActiveDirectoryUserDetail) {
                String mail = ((ActiveDirectoryUserDetail)userDetails).getMail();
                LOGGER.log(Level.FINE, () -> "Email address = '" + mail + "'");
                return mail;
            }
            if (userDetails == null) {
                return null;
            }
            LOGGER.log(Level.FINER, () -> "Unexpected UserDetails type from AD: " + userDetails.getClass().getName() + " uds: " + uds.getClass().getName());
        }
        catch (AccessDeniedException e) {
            LOGGER.log(Level.FINE, "Failed to look Active Directory for e-mail address", e);
        }
        catch (AuthenticationException e) {
            LOGGER.log(Level.FINE, "Failed to look up Active Directory for e-mail address", e);
        }
        return null;
    }
}

