// CHECKSTYLE:OFF

package hudson.plugins.active_directory;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code TlsConfiguration.AdministrativeMonitor.DisplayName}: {@code
     * Active Directory TLS Configuration Monitor}.
     * 
     * @return
     *     {@code Active Directory TLS Configuration Monitor}
     */
    public static String TlsConfiguration_AdministrativeMonitor_DisplayName() {
        return holder.format("TlsConfiguration.AdministrativeMonitor.DisplayName");
    }

    /**
     * Key {@code TlsConfiguration.AdministrativeMonitor.DisplayName}: {@code
     * Active Directory TLS Configuration Monitor}.
     * 
     * @return
     *     {@code Active Directory TLS Configuration Monitor}
     */
    public static Localizable _TlsConfiguration_AdministrativeMonitor_DisplayName() {
        return new Localizable(holder, "TlsConfiguration.AdministrativeMonitor.DisplayName");
    }

    /**
     * Key {@code passwordTooShortFIPS}: {@code Password is too short (< 14
     * characters)}.
     * 
     * @return
     *     {@code Password is too short (< 14 characters)}
     */
    public static String passwordTooShortFIPS() {
        return holder.format("passwordTooShortFIPS");
    }

    /**
     * Key {@code passwordTooShortFIPS}: {@code Password is too short (< 14
     * characters)}.
     * 
     * @return
     *     {@code Password is too short (< 14 characters)}
     */
    public static Localizable _passwordTooShortFIPS() {
        return new Localizable(holder, "passwordTooShortFIPS");
    }

    /**
     * Key {@code ActiveDirectorySecurityRealm.NoUsers}: {@code The bind with
     * the managerDn was successful but AD was not able to find any user.}.
     * 
     * @return
     *     {@code The bind with the managerDn was successful but AD was not able
     *     to find any user.}
     */
    public static String ActiveDirectorySecurityRealm_NoUsers() {
        return holder.format("ActiveDirectorySecurityRealm.NoUsers");
    }

    /**
     * Key {@code ActiveDirectorySecurityRealm.NoUsers}: {@code The bind with
     * the managerDn was successful but AD was not able to find any user.}.
     * 
     * @return
     *     {@code The bind with the managerDn was successful but AD was not able
     *     to find any user.}
     */
    public static Localizable _ActiveDirectorySecurityRealm_NoUsers() {
        return new Localizable(holder, "ActiveDirectorySecurityRealm.NoUsers");
    }

    /**
     * Key {@code GroupLookupStrategy.TokenGroups}: {@code Token-Groups user
     * attribute}.
     * 
     * @return
     *     {@code Token-Groups user attribute}
     */
    public static String GroupLookupStrategy_TokenGroups() {
        return holder.format("GroupLookupStrategy.TokenGroups");
    }

    /**
     * Key {@code GroupLookupStrategy.TokenGroups}: {@code Token-Groups user
     * attribute}.
     * 
     * @return
     *     {@code Token-Groups user attribute}
     */
    public static Localizable _GroupLookupStrategy_TokenGroups() {
        return new Localizable(holder, "GroupLookupStrategy.TokenGroups");
    }

    /**
     * Key {@code TlsConfiguration.CertificateError}: {@code Choosing an
     * insecure TLS configuration in FIPS mode is not allowed. Please do not
     * trust all certificates.}.
     * 
     * @return
     *     {@code Choosing an insecure TLS configuration in FIPS mode is not
     *     allowed. Please do not trust all certificates.}
     */
    public static String TlsConfiguration_CertificateError() {
        return holder.format("TlsConfiguration.CertificateError");
    }

    /**
     * Key {@code TlsConfiguration.CertificateError}: {@code Choosing an
     * insecure TLS configuration in FIPS mode is not allowed. Please do not
     * trust all certificates.}.
     * 
     * @return
     *     {@code Choosing an insecure TLS configuration in FIPS mode is not
     *     allowed. Please do not trust all certificates.}
     */
    public static Localizable _TlsConfiguration_CertificateError() {
        return new Localizable(holder, "TlsConfiguration.CertificateError");
    }

    /**
     * Key {@code GroupLookupStrategy.Auto}: {@code Automatic}.
     * 
     * @return
     *     {@code Automatic}
     */
    public static String GroupLookupStrategy_Auto() {
        return holder.format("GroupLookupStrategy.Auto");
    }

    /**
     * Key {@code GroupLookupStrategy.Auto}: {@code Automatic}.
     * 
     * @return
     *     {@code Automatic}
     */
    public static Localizable _GroupLookupStrategy_Auto() {
        return new Localizable(holder, "GroupLookupStrategy.Auto");
    }

    /**
     * Key {@code ActiveDirectoryStatus.ActiveDirectoryHealthStatus}: {@code
     * Active Directory Health Status}.
     * 
     * @return
     *     {@code Active Directory Health Status}
     */
    public static String ActiveDirectoryStatus_ActiveDirectoryHealthStatus() {
        return holder.format("ActiveDirectoryStatus.ActiveDirectoryHealthStatus");
    }

    /**
     * Key {@code ActiveDirectoryStatus.ActiveDirectoryHealthStatus}: {@code
     * Active Directory Health Status}.
     * 
     * @return
     *     {@code Active Directory Health Status}
     */
    public static Localizable _ActiveDirectoryStatus_ActiveDirectoryHealthStatus() {
        return new Localizable(holder, "ActiveDirectoryStatus.ActiveDirectoryHealthStatus");
    }

    /**
     * Key {@code GroupLookupStrategy.Recursive}: {@code Recursive group
     * queries}.
     * 
     * @return
     *     {@code Recursive group queries}
     */
    public static String GroupLookupStrategy_Recursive() {
        return holder.format("GroupLookupStrategy.Recursive");
    }

    /**
     * Key {@code GroupLookupStrategy.Recursive}: {@code Recursive group
     * queries}.
     * 
     * @return
     *     {@code Recursive group queries}
     */
    public static Localizable _GroupLookupStrategy_Recursive() {
        return new Localizable(holder, "GroupLookupStrategy.Recursive");
    }

    /**
     * Key {@code TlsConfiguration.JdkTrustStore}: {@code JDK TrustStore}.
     * 
     * @return
     *     {@code JDK TrustStore}
     */
    public static String TlsConfiguration_JdkTrustStore() {
        return holder.format("TlsConfiguration.JdkTrustStore");
    }

    /**
     * Key {@code TlsConfiguration.JdkTrustStore}: {@code JDK TrustStore}.
     * 
     * @return
     *     {@code JDK TrustStore}
     */
    public static Localizable _TlsConfiguration_JdkTrustStore() {
        return new Localizable(holder, "TlsConfiguration.JdkTrustStore");
    }

    /**
     * Key {@code TlsConfiguration.ErrorMessage}: {@code Disabling TLS in
     * FIPS mode is not allowed. Either enable StartTls or Require TLS.}.
     * 
     * @return
     *     {@code Disabling TLS in FIPS mode is not allowed. Either enable
     *     StartTls or Require TLS.}
     */
    public static String TlsConfiguration_ErrorMessage() {
        return holder.format("TlsConfiguration.ErrorMessage");
    }

    /**
     * Key {@code TlsConfiguration.ErrorMessage}: {@code Disabling TLS in
     * FIPS mode is not allowed. Either enable StartTls or Require TLS.}.
     * 
     * @return
     *     {@code Disabling TLS in FIPS mode is not allowed. Either enable
     *     StartTls or Require TLS.}
     */
    public static Localizable _TlsConfiguration_ErrorMessage() {
        return new Localizable(holder, "TlsConfiguration.ErrorMessage");
    }

    /**
     * Key {@code GroupLookupStrategy.ChainMatch}: {@code
     * LDAP_MATCHING_RULE_IN_CHAIN}.
     * 
     * @return
     *     {@code LDAP_MATCHING_RULE_IN_CHAIN}
     */
    public static String GroupLookupStrategy_ChainMatch() {
        return holder.format("GroupLookupStrategy.ChainMatch");
    }

    /**
     * Key {@code GroupLookupStrategy.ChainMatch}: {@code
     * LDAP_MATCHING_RULE_IN_CHAIN}.
     * 
     * @return
     *     {@code LDAP_MATCHING_RULE_IN_CHAIN}
     */
    public static Localizable _GroupLookupStrategy_ChainMatch() {
        return new Localizable(holder, "GroupLookupStrategy.ChainMatch");
    }

    /**
     * Key {@code TlsConfiguration.TrustAllCertificates}: {@code (Insecure)
     * Trust all Certificates}.
     * 
     * @return
     *     {@code (Insecure) Trust all Certificates}
     */
    public static String TlsConfiguration_TrustAllCertificates() {
        return holder.format("TlsConfiguration.TrustAllCertificates");
    }

    /**
     * Key {@code TlsConfiguration.TrustAllCertificates}: {@code (Insecure)
     * Trust all Certificates}.
     * 
     * @return
     *     {@code (Insecure) Trust all Certificates}
     */
    public static Localizable _TlsConfiguration_TrustAllCertificates() {
        return new Localizable(holder, "TlsConfiguration.TrustAllCertificates");
    }

    /**
     * Key {@code DisplayName}: {@code Active Directory}.
     * 
     * @return
     *     {@code Active Directory}
     */
    public static String DisplayName() {
        return holder.format("DisplayName");
    }

    /**
     * Key {@code DisplayName}: {@code Active Directory}.
     * 
     * @return
     *     {@code Active Directory}
     */
    public static Localizable _DisplayName() {
        return new Localizable(holder, "DisplayName");
    }

}
